<item
	name				= "SCET_UR8"
	dataType			= "double"
	fixed_value			= "CCSDS_SCET_UR8"
	dateCreated			= "1.3.2005"
	description			= "SpaceCraft Event Time (UR8).  
						This value is the time at which the event was acquired.
						That is, it is the time well past the end of the event.
						Other timing values should be used for precise datation.
						This value is accurate to about 4ms." >
</item>


<item
	name				= "EventID"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "0"
	lengthInBits			= "32"
	dateCreated			= "3.11.2004"
	description			= "TDS event ID number - as acquired from nature (usually large)" >
</item>

<item
	name				= "TDS_Clock"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "4 * 8"
	lengthInBits			= "32"
	dateCreated			= "24.3.2005"
	description			= "TDS clock value - datation at end of event acquisition (plus delay buffer)" >
</item>

<item
	name				= "CPU_Clock"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "8 * 8"
	lengthInBits			= "32"
	dateCreated			= "24.3.2005"
	description			= "High resolution 32-bit CPU clock - datation at end of event acquisition (plus delay bufffer)(tics (about 100ns/tic (see item CPU_Clock_to_Seconds)))" >
</item>

<item
	name				= "CAL_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "12 * 8 + 7"
	lengthInBits			= "1"
	dateCreated			= "30.11.2005"
	description			= "Calibration state during this event" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "NsamplesMAX"
	dataType			= "Integer"
	fixed_value			= "16384"
	hidden				= "true"
	dateCreated			= "21.9.2007"
	description			= "Maximum number of samples in a TDS event as defined by the FIFO size (16k)" >
</item>
<item
	name				= "Nsamples"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "13 * 8"
	lengthInBits			= "15"
	dateCreated			= "7.10.2004"
	description			= "Actual number of samples in this event (less than or equal to 16k)" >
</item>

<item
	name				= "Thruster_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "2.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "Thruster_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14 * 8 + 7"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "2.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "2.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14 * 8 + 6"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "2.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Trigger_Position"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14 * 8"
	lengthInBits			= "16"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "24.3.2005"
	description			= "Center position for event trigger (samples)" >
</item>
<item
	name				= "Trigger_Position"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8"
	lengthInBits			= "14"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "24.3.2005"
	description			= "Center position for event trigger (samples)" >
</item>

<item
	name				= "Event_Quality"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "16 * 8"
	lengthInBits			= "32"
	dateCreated			= "24.3.2005"
	description			= "Quality value for this event" >
</item>

<item
	name				= "Threshold_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20 * 8"
	lengthInBits			= "16"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Trigger threshold for this event (TM units)" >
</item>
<item
	name				= "Threshold_mV"
	dataType			= "float"
	fixed_value			= "Threshold_Raw / mV2counts"
	dateCreated			= "5.3.2007"
	description			= "Trigger threshold for this event (mVolts)" >
</item>
<item
	name				= "Threshold"
	dataType			= "float"
	fixed_value			= "Threshold_mV / 1000."
	dateCreated			= "5.3.2007"
	description			= "Trigger threshold for this event (Volts)" >
</item>
<item
	name				= "Threshold_dBs"
	dataType			= "float"
	fixed_value			= "2 * Signed_Int_2dBs_v1(Threshold_Raw)"
	dateCreated			= "5.3.2007"
	description			= "Trigger threshold for this event (dBs)" >
</item>

<item
	name				= "Sample_Speed"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 5"
	lengthInBits			= "3"
	dateCreated			= "24.3.2005"
	description			= "Indicates the TDS sampling speed (TM units)" >
	<xlate value="0" string="250ks/s" />
	<xlate value="1" string="125ks/s" />
	<xlate value="2" string="63ks/s" />
	<xlate value="3" string="32ks/s" />
	<xlate value="4" string="16ks/s" />
	<xlate value="5" string="8ks/s" />
	<xlate value="6" string="4ks/s" />
	<xlate value="7" string="2ks/s" />
</item>

<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "4"
	validity			= "Sample_Speed .EQ. 0"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Sample period (microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "8"
	validity			= "Sample_Speed .EQ. 1"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Sample period (microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "16"
	validity			= "Sample_Speed .EQ. 2"
	hidden				= "true"
	dateCreated			= "23.12.2005"
	description			= "Sample period (unused)(microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "32"
	validity			= "Sample_Speed .EQ. 3"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Sample period (microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "64"
	validity			= "Sample_Speed .EQ. 4"
	hidden				= "true"
	dateCreated			= "23.12.2005"
	description			= "Sample period (unused)(microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "128"
	validity			= "Sample_Speed .EQ. 5"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Sample period (microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "256"
	validity			= "Sample_Speed .EQ. 6"
	hidden				= "true"
	dateCreated			= "23.12.2005"
	description			= "Sample period (unused)(microseconds)" >
</item>
<item
	name				= "Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "512"
	validity			= "Sample_Speed .EQ. 7"
	hidden				= "true"
	dateCreated			= "23.12.2005"
	description			= "Sample period (unused)(microseconds)" >
</item>

<item
	name				= "Sample_Speed_SPS"
	dataType			= "float"
	fixed_value			= "1000000 / Sample_Period_uSec"
	dateCreated			= "24.3.2005"
	description			= "Sampling speed (samples per second)" >
</item>

<item
	name				= "Sample_Period_Seconds"
	dataType			= "float"
	fixed_value			= "Sample_Period_uSec / 1000000."
	dateCreated			= "13.10.2005"
	description			= "Sample period (seconds)" >
</item>

<item
	name				= "Event_Period_Seconds"
	dataType			= "float"
	fixed_value			= "Sample_Period_Seconds * Nsamples"
	dateCreated			= "13.10.2005"
	description			= "Event period (seconds)" >
</item>

<item
	name				= "Path_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 0"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates the source antenna for TDS channel 1" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey-Ez" />
</item>

<item
	name				= "Path_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 1"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates the source antenna for TDS channel 2" >
	<xlate value="0" string="Ey" />
	<xlate value="1" string="Ex-Ez" />
</item>

<item
	name				= "Path_Ch3"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 2"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates the source antenna for TDS channel 3" >
	<xlate value="0" string="Ez" />
	<xlate value="1" string="Ex-Ey" />
</item>

<item
	name				= "Path_Ch4"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 3"
	lengthInBits			= "2"
	dateCreated			= "24.3.2005"
	description			= "Indicates the source antenna for TDS channel 4" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "Filter"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "23*8 + 4"
	lengthInBits			= "2"
	dateCreated			= "24.3.2005"
	description			= "Indicates the TDS low-pass filter setting (TM units)" >
	<xlate value="0" string="108kHz" />
	<xlate value="1" string="54kHz" />
	<xlate value="2" string="13.5kHz" />
	<xlate value="3" string="3.375kHz" />
</item>

<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "108000"
	validity			= "Filter .EQ. 0"
	dateCreated			= "24.3.2005"
	description			= "The TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "54000"
	validity			= "Filter .EQ. 1"
	dateCreated			= "24.3.2005"
	description			= "The TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "13500"
	validity			= "Filter .EQ. 2"
	dateCreated			= "24.3.2005"
	description			= "The TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "3375"
	validity			= "Filter .EQ. 3"
	dateCreated			= "24.3.2005"
	description			= "The TDS low-pass filter setting (Hertz)" >
</item>

<item
	name				= "Trigger"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "23*8 + 0"
	lengthInBits			= "4"
	dateCreated			= "24.3.2005"
	description			= "Indicates the TDS trigger source (TM units)" >
	<xlate value="0" string="None" />
	<xlate value="1" string="Ch1-1point" />
	<xlate value="2" string="Ch2-1point" />
	<xlate value="3" string="Ch3-1point" />
	<xlate value="4" string="Ch4-1point" />
	<xlate value="5" string="Ch1-2point" />
	<xlate value="6" string="Ch2-2point" />
	<xlate value="7" string="Ch3-2point" />
	<xlate value="8" string="Ch4-2point" />
	<xlate value="9" string="Manual" />
</item>

<item
	name				= "Trigger_Type"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "Trigger .EQ. 0"
	dateCreated			= "24.3.2005"
	description			= "Trigger type" >
	<xlate value="0" string="None" />
	<xlate value="1" string="Single Point" />
	<xlate value="2" string="Double Point" />
	<xlate value="3" string="Manual" />
</item>
<item
	name				= "Trigger_Type"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "(Trigger .EQ. 1) .OR. (Trigger .EQ. 2) .OR. (Trigger .EQ. 3) .OR. (Trigger .EQ. 4)"
	dateCreated			= "24.3.2005"
	description			= "Trigger type" >
	<xlate value="0" string="None" />
	<xlate value="1" string="Single Point" />
	<xlate value="2" string="Double Point" />
	<xlate value="3" string="Manual" />
</item>
<item
	name				= "Trigger_Type"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "(Trigger .EQ. 5) .OR. (Trigger .EQ. 6) .OR. (Trigger .EQ. 7) .OR. (Trigger .EQ. 8)"
	dateCreated			= "24.3.2005"
	description			= "Trigger type" >
	<xlate value="0" string="None" />
	<xlate value="1" string="Single Point" />
	<xlate value="2" string="Double Point" />
	<xlate value="3" string="Manual" />
</item>
<item
	name				= "Trigger_Type"
	dataType			= "Integer"
	fixed_value			= "3"
	validity			= "Trigger .EQ. 9"
	dateCreated			= "24.3.2005"
	description			= "Trigger type" >
	<xlate value="0" string="None" />
	<xlate value="1" string="Single Point" />
	<xlate value="2" string="Double Point" />
	<xlate value="3" string="Manual" />
</item>

<item
	name				= "Trigger_Channel"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "(Trigger .EQ. 0) .OR. (Trigger .EQ. 9)"
	dateCreated			= "24.3.2005"
	description			= "Trigger source (channel)" >
	<xlate value="0" string="Manual" />
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>
<item
	name				= "Trigger_Channel"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "(Trigger .EQ. 1) .OR. (Trigger .EQ. 5)"
	dateCreated			= "24.3.2005"
	description			= "Trigger source (channel)" >
	<xlate value="0" string="Manual" />
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>
<item
	name				= "Trigger_Channel"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "(Trigger .EQ. 2) .OR. (Trigger .EQ. 6)"
	dateCreated			= "24.3.2005"
	description			= "Trigger source (channel)" >
	<xlate value="0" string="Manual" />
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>
<item
	name				= "Trigger_Channel"
	dataType			= "Integer"
	fixed_value			= "3"
	validity			= "(Trigger .EQ. 3) .OR. (Trigger .EQ. 7)"
	dateCreated			= "24.3.2005"
	description			= "Trigger source (channel)" >
	<xlate value="0" string="Manual" />
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>
<item
	name				= "Trigger_Channel"
	dataType			= "Integer"
	fixed_value			= "4"
	validity			= "(Trigger .EQ. 4) .OR. (Trigger .EQ. 8)"
	dateCreated			= "24.3.2005"
	description			= "Trigger source (channel)" >
	<xlate value="0" string="Manual" />
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>

<item
	name				= "Trigger_Source"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "Trigger_Channel .EQ. 0"
	dateCreated			= "24.3.2005"
	description			= "Source antenna for triggering" >
	<xlate value="0" string="Manual" />
</item>
<item
	name				= "Trigger_Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch1"
	validity			= "Trigger_Channel .EQ. 1"
	dateCreated			= "24.3.2005"
	description			= "Source antenna for triggering" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey-Ez" />
</item>
<item
	name				= "Trigger_Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch2"
	validity			= "Trigger_Channel .EQ. 2"
	dateCreated			= "24.3.2005"
	description			= "Source antenna for triggering" >
	<xlate value="0" string="Ey" />
	<xlate value="1" string="Ex-Ez" />
</item>
<item
	name				= "Trigger_Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch3"
	validity			= "Trigger_Channel .EQ. 3"
	dateCreated			= "24.3.2005"
	description			= "Source antenna for triggering" >
	<xlate value="0" string="Ez" />
	<xlate value="1" string="Ex-Ey" />
</item>
<item
	name				= "Trigger_Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch4"
	validity			= "Trigger_Channel .EQ. 4"
	dateCreated			= "24.3.2005"
	description			= "Source antenna for triggering" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "Stream"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "24*8 + 7"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates the current TDS stream (honesty or quality)" >
	<xlate value="0" string="Honesty" />
	<xlate value="1" string="Quality" />
</item>

<item
	name				= "Ping_Pong"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "24*8 + 6"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates whether we came from a ping buffer or a pong buffer" >
	<xlate value="0" string="Ping" />
	<xlate value="1" string="Pong" />
</item>

<item
	name				= "RAM_Buffer"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "24*8 + 0"
	lengthInBits			= "6"
	dateCreated			= "24.3.2005"
	description			= "Indicates which TDS RAM buffer we came from" >
</item>

<item
	name				= "Event_to_TM_seconds"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	hidden				= "true"
	dateCreated			= "3.4.2008"
	description			= "The time this event went to TM (seconds since Jan 1, 1958 00:00:00 UTC)"
/>
<item
	name				= "Event_to_TM_seconds"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "25 * 8"
	lengthInBits			= "32"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	hidden				= "true"
	dateCreated			= "3.4.2008"
	description			= "The time this event went to TM (seconds since Jan 1, 1958 00:00:00 UTC)"
/>

<item
	name				= "Event_to_TM_sub_seconds"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	hidden				= "true"
	dateCreated			= "3.4.2008"
	description			= "The time this event went to TM (subseconds (1/256))"
/>
<item
	name				= "Event_to_TM_sub_seconds"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "29 * 8"
	lengthInBits			= "8"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	hidden				= "true"
	dateCreated			= "3.4.2008"
	description			= "The time this event went to TM (subseconds (1/256))"
/>

<item
	name				= "Event_to_TM_UR8"
	dataType			= "double"
	fixed_value			= "UR8fromCCSDStime(Event_to_TM_seconds,Event_to_TM_sub_seconds)"
	dateCreated			= "3.4.2008"
	description			= "The time this event went to TM (UR8)"
/>

<item
	name				= "EventID_to_TM"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "3.4.2008"
	description			= "TDS event ID number - as sent to the ground (includes both streams)" >
</item>
<item
	name				= "EventID_to_TM"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "30 * 8"
	lengthInBits			= "24"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "3.4.2008"
	description			= "TDS event ID number - as sent to the ground (includes both streams)" >
</item>
