<item
	name				= "Channel_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "23*8 + 6"
	lengthInBits			= "2"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "The current Channel (counting from zero)" >
	<xlate value="0" string="Ch1" />
	<xlate value="1" string="Ch2" />
	<xlate value="2" string="Ch3" />
	<xlate value="3" string="Ch4" />
</item>
<item
	name				= "Channel"
	dataType			= "Integer"
	fixed_value			= "Channel_Raw + 1"
	dateCreated			= "1.3.2005"
	description			= "TDS Channel number" >
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>

<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch1"
	validity			= "Channel_Raw .EQ. 0"
	dateCreated			= "24.3.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey-Ez" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch2"
	validity			= "Channel_Raw .EQ. 1"
	dateCreated			= "24.3.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ey" />
	<xlate value="1" string="Ex-Ez" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch3"
	validity			= "Channel_Raw .EQ. 2"
	dateCreated			= "24.3.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ez" />
	<xlate value="1" string="Ex-Ey" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch4"
	validity			= "Channel_Raw .EQ. 3"
	dateCreated			= "24.3.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "DataChunk1_Offset"
	dataType			= "Integer"
	fixed_value			= "25 * 8"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	hidden				= "true"
	dateCreated			= "2.4.2008"
	description			= "Offset to the start of time series data chunk 1 (of 1)" >
</item>
<item
	name				= "DataChunk1_Offset"
	dataType			= "Integer"
	fixed_value			= "41 * 8"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	hidden				= "true"
	dateCreated			= "2.4.2008"
	description			= "Offset to the start of time series data chunk 1 (of 1)" >
</item>

<item
	name				= "data"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "DataChunk1_Offset"
	lengthInBits			= "16"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "Nsamples"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	signed				= "1"
	hidden				= "true"
	dateCreated			= "7.10.2004"
	description			= "TDS data time series array of length Nsamples (TM units)" >
</item>

<item
	name				= "Time_Series_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "DataChunk1_Offset"
	lengthInBits			= "16"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "Nsamples"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	signed				= "1"
	dateCreated			= "24.3.2005"
	description			= "TDS data time series array of length Nsamples (TM units).
						16 bit raw digital values range from -32k to +32k and represent Voltage as a function of time." >
</item>

<item
	name				= "mV2counts"
	dataType			= "Integer"
	fixed_value			= "-187"
	hidden				= "true"
	dateCreated			= "18.10.2005"
	description			= "Convert TDS counts to mVolts or vice-versa without proper frequency response (counts/mV)" >
</item>

<item
	name				= "Time_Series_mV"
	dataType			= "float"
	fixed_value			= "Time_Series_Raw / mV2counts"
	dateCreated			= "18.10.2005"
	description			= "TDS data time series array of length Nsamples without frequency correction (mVolts).
						Values range from about -175mV to +175mV and is the voltage at the preamp input." >
</item>
<item
	name				= "Time_Series_V"
	dataType			= "float"
	fixed_value			= "Time_Series_mV / 1000."
	dateCreated			= "3.8.2006"
	description			= "TDS data time series array of length Nsamples without frequency correction (Volts).
						Values range from about -0.175V to +0.175V and is the voltage at the preamp input." >
</item>
<item
	name				= "Time_Series_dBs"
	dataType			= "float"
	fixed_value			= "-2 * Signed_Int_2dBs_v1(Time_Series_Raw)"
	dateCreated			= "8.6.2007"
	note				= "Here we multiply dBs by 2 to go to Volts and by -1 to account for the analog inversion"
	description			= "TDS data time series array of length Nsamples without frequency correction (signed dBs).
						Time series gives a burst of signed voltage as a function of time.
						Values range from about -90dBs to +90dBs." >
</item>

<item
	name				= "Spectrum_dBs"
	dataType			= "float"
	fixed_value			= "Time_Series2Spectrum_dBs_V1(Time_Series_V)"
	dateCreated			= "29.1.2009"
	description			= "TDS power spectrum in dBs. 
						Uncorrected TDS time series (in Volts) is FFTed and converted to dBs.
						This is an array of length Spectrum_Length.
						Conversion will fail in rare cases when the TDS event length is not a power of two.
						Values range from about TBD dBs to TBD dBs." >
</item>
<item
	name				= "Spectrum_f0"
	dataType			= "float"
	fixed_value			= "Sample_Speed_SPS/Nsamples"
	dateCreated			= "29.1.2009"
	description			= "The first/lowest frequency and the frequency step size in the TDS spectrum (Hertz)" >
</item>
<item
	name				= "Spectrum_fMax"
	dataType			= "float"
	fixed_value			= "Sample_Speed_SPS/2."
	dateCreated			= "29.1.2009"
	description			= "The top/highest or Nyquist frequency in the TDS spectrum (Hertz)" >
</item>
<item
	name				= "Spectrum_Length"
	dataType			= "Integer"
	fixed_value			= "Nsamples/2 + 1"
	dateCreated			= "29.1.2009"
	description			= "Length of the various TDS spectrum arrays (nominally this is N/2+1)" >
</item>
<item
	name				= "Spectrum_Frequencies"
	dataType			= "Float"
	fixed_value			= "R4GEN(0,1,Spectrum_Length,1,1,Spectrum_f0,0.)"
	dateCreated			= "29.1.2009"
	description			= "Frequency values for the TDS spectra starting at zero (DC) and counting up to Spectrum_fMax (Hertz).
						This is an array of length Spectrum_Length." >
</item>

<item
	name				= "Noffset"
	dataType			= "Integer"
	fixed_value			= "-NsamplesMAX - Trigger_Position"
	hidden				= "true"
	dateCreated			= "1.2.2007"
	description			= "Number of samples in the past for the first sample of this event (a negative number)" >
</item>
<item
	name				= "Noffset_Start"
	dataType			= "Integer"
	fixed_value			= "NsamplesMAX + Trigger_Position"
	hidden				= "true"
	dateCreated			= "21.9.2007"
	description			= "Number of samples in the past for the first sample of this event (a positive number)" >
</item>
<item
	name				= "Noffset_Center"
	dataType			= "Integer"
	fixed_value			= "NsamplesMAX"
	hidden				= "true"
	dateCreated			= "21.9.2007"
	description			= "Number of samples in the past for the approximate center/trigger of this event (a positive number)" >
</item>
<item
	name				= "Noffset_End"
	dataType			= "Integer"
	fixed_value			= "NsamplesMAX - Nsamples + Trigger_Position + 1"
	hidden				= "true"
	dateCreated			= "21.9.2007"
	description			= "Number of samples in the past for the last sample of this event (a positive number)" >
</item>

<item
	name				= "Time_Series_Times"
	dataType			= "Float"
	fixed_value			= "R4GEN(0,1,Nsamples,1,1,Sample_Period_Seconds,0.)"
	dateCreated			= "1.2.2007"
	description			= "Time values for the TDS time series starting at zero and counting up (seconds).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond."
/>
<item
	name				= "Time_Series_Times_Centered"
	dataType			= "Float"
	fixed_value			= "R4GEN(-Trigger_Position+1,1,Nsamples,1,1,Sample_Period_Seconds,0.)"
	dateCreated			= "21.9.2007"
	description			= "Time values for the TDS time series starting negative and counting up (seconds).
						Time zero is approximately at the trigger point.
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond."
/>
<item
	name				= "Time_Series_Sample_Times"
	dataType			= "Float"
	fixed_value			= "R4GEN(Noffset,1,Nsamples,1,1,Sample_Period_Seconds,0.)"
	dateCreated			= "1.2.2007"
	description			= "Sample times for the TDS time series w/r/t the SCET - negative and counting up (seconds).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond."
/>
<item
	name				= "Time_Series_Sample_Times_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Series_Sample_Times*Seconds2UR8"
	dateCreated			= "1.2.2007"
	description			= "Actual time values for the TDS time series (UR8).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond but some numerical accuracy may be lost.
						Absolute timing is only accurate to 4ms."
/>
<item
	name				= "Time_Series_SCET_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Series_Sample_Times*Seconds2UR8"
	dateCreated			= "5.3.2007"
	description			= "Actual time values for the TDS time series (UR8).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond but some numerical accuracy may be lost.
						Absolute timing is only accurate to 4ms."
/>

<item
	name				= "SCET_Start_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 - Noffset_Start*Sample_period_Seconds*Seconds2UR8"
	dateCreated			= "21.9.2007"
	description			= "Corrected time for the first sample of the TDS time series (UR8).
						Absolute timing is accurate to 4ms."
/>
<item
	name				= "SCET_Center_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 - Noffset_Center*Sample_period_Seconds*Seconds2UR8"
	dateCreated			= "21.9.2007"
	description			= "Corrected time for the approximate center/trigger of the TDS time series (UR8).
						Absolute timing is accurate to 4ms."
/>
<item
	name				= "SCET_End_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 - Noffset_End*Sample_period_Seconds*Seconds2UR8"
	dateCreated			= "21.9.2007"
	description			= "Corrected time for the last sample of the TDS time series (UR8).
						Absolute timing is accurate to 4ms."
/>
