<item
	name				= "SCET_UR8"
	dataType			= "double"
	fixed_value			= "CCSDS_SCET_UR8"
	dateCreated			= "4.12.2005"
	description			= "SpaceCraft Event Time (UR8).  
						This value is the time at which the histogram was fully acquired.
						That is, it is the time of the end of the event.
						This value is accurate to about 4ms." >
</item>

<item
	name				= "SCET_Start_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 - Seconds_Per_Histogram*Seconds2UR8"
	dateCreated			= "5.6.2008"
	description			= "Time of the start of the histogram acquisition period (UR8)."
/>
<item
	name				= "SCET_Center_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 - Seconds_Per_Histogram*Seconds2UR8/2."
	dateCreated			= "21.9.2007"
	description			= "Time of the center of the histogram acquisition period (UR8)."
/>
<item
	name				= "SCET_End_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8"
	dateCreated			= "21.9.2007"
	description			= "Time of the center of the histogram acquisition period (UR8).
						This value is the same as the SCET_UR8."
/>

<item
	name				= "EventID"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "0"
	lengthInBits			= "8"
	dateCreated			= "4.12.2005"
	description			= "LWS event ID number" >
</item>

<item
	name				= "TDS_Clock_Start"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "1 * 8"
	lengthInBits			= "32"
	dateCreated			= "4.12.2005"
	description			= "TDS clock value at start of event acquisition" >
</item>

<item
	name				= "TDS_Clock_End"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "5 * 8"
	lengthInBits			= "32"
	dateCreated			= "4.12.2005"
	description			= "TDS clock value at end of event acquisition" >
</item>

<item
	name				= "CPU_Clock_End"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "9 * 8"
	lengthInBits			= "32"
	dateCreated			= "4.12.2005"
	description			= "High resolution 32-bit CPU clock at end of event acquisition (tics (about 100ns/tic (see item CPU_Clock_to_Seconds)))" >
</item>

<item
	name				= "Nbins"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "13 * 8"
	lengthInBits			= "16"
	dateCreated			= "4.12.2005"
	description			= "Number of histogram bins in this event" >
</item>

<item
	name				= "Nsamples_Per_Bin"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8"
	lengthInBits			= "16"
	dateCreated			= "4.12.2005"
	description			= "Number of TDS samples in each binning period" >
</item>

<item
	name				= "Nbin_Periods_Per_Histogram"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "17 * 8"
	lengthInBits			= "16"
	dateCreated			= "4.12.2005"
	description			= "Number of binning periods in this histogram" >
</item>

<item
	name				= "Nsamples_Per_Histogram"
	dataType			= "Integer"
	fixed_value			= "Nsamples_Per_Bin * Nbin_Periods_Per_Histogram"
	dateCreated			= "27.1.2007"
	description			= "Number of TDS samples in this histogram period" >
</item>

<item
	name				= "Seconds_Per_Sample"
	dataType			= "float"
	fixed_value			= "TDS_Sample_Period_Seconds"
	dateCreated			= "27.1.2007"
	description			= "TDS sample period (seconds)" >
</item>
<item
	name				= "Seconds_Per_Bin"
	dataType			= "float"
	fixed_value			= "Nsamples_Per_Bin * TDS_Sample_Period_Seconds"
	dateCreated			= "27.1.2007"
	description			= "Duration of each binning period (seconds)" >
</item>
<item
	name				= "Seconds_Per_Histogram"
	dataType			= "float"
	fixed_value			= "Nsamples_Per_Histogram * TDS_Sample_Period_Seconds"
	dateCreated			= "27.1.2007"
	description			= "Duration of this histogram (seconds)" >
</item>

<item
	name				= "TDS_Sample_Speed"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "19*8 + 5"
	lengthInBits			= "3"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the TDS sampling speed (TM units)" >
	<xlate value="0" string="250ks/s" />
	<xlate value="1" string="125ks/s" />
	<xlate value="2" string="63ks/s" />
	<xlate value="3" string="32ks/s" />
	<xlate value="4" string="16ks/s" />
	<xlate value="5" string="8ks/s" />
	<xlate value="6" string="4ks/s" />
	<xlate value="7" string="2ks/s" />
</item>

<item
	name				= "TDS_Sample_Speed_SPS"
	dataType			= "float"
	fixed_value			= "1000000 / TDS_Sample_Period_uSec"
	family				= "TDS State"
	dateCreated			= "11.2.2006"
	description			= "TDS sampling speed (samples per second)" >
</item>

<item
	name				= "TDS_Sample_Period_Seconds"
	dataType			= "float"
	fixed_value			= "TDS_Sample_Period_uSec / 1000000."
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (seconds)" >
</item>

<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "4"
	validity			= "TDS_Sample_Speed .EQ. 0"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "8"
	validity			= "TDS_Sample_Speed .EQ. 1"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "16"
	validity			= "TDS_Sample_Speed .EQ. 2"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "32"
	validity			= "TDS_Sample_Speed .EQ. 3"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "128"
	validity			= "TDS_Sample_Speed .EQ. 5"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "256"
	validity			= "TDS_Sample_Speed .EQ. 6"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>
<item
	name				= "TDS_Sample_Period_uSec"
	dataType			= "Integer"
	fixed_value			= "512"
	validity			= "TDS_Sample_Speed .EQ. 7"
	hidden				= "true"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "TDS sample period (microseconds)" >
</item>

<item
	name				= "Bin_Period_Seconds"
	dataType			= "float"
	fixed_value			= "TDS_Sample_Period_Seconds * Nsamples_Per_Bin"
	dateCreated			= "4.12.2005"
	description			= "Period for each histogram bin (seconds)" >
</item>

<item
	name				= "Event_Period_Seconds"
	dataType			= "float"
	fixed_value			= "Bin_Period_Seconds * Nbin_Periods_Per_Histogram"
	dateCreated			= "4.12.2005"
	description			= "Event/histogram period (seconds)" >
</item>

<item
	name				= "Path_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "19*8 + 0"
	lengthInBits			= "1"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the source antenna for LWS/TDS channel 1" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey-Ez" />
</item>

<item
	name				= "Path_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "19*8 + 1"
	lengthInBits			= "1"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the source antenna for LWS/TDS channel 2" >
	<xlate value="0" string="Ey" />
	<xlate value="1" string="Ex-Ez" />
</item>

<item
	name				= "Path_Ch3"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "19*8 + 2"
	lengthInBits			= "1"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the source antenna for LWS/TDS channel 3" >
	<xlate value="0" string="Ez" />
	<xlate value="1" string="Ex-Ey" />
</item>

<item
	name				= "Path_Ch4"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "19*8 + 3"
	lengthInBits			= "2"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the source antenna for LWS/TDS channel 4" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "Filter"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20*8 + 3"
	lengthInBits			= "2"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "Indicates the LWS/TDS low-pass filter setting (TM units)" >
	<xlate value="0" string="108kHz" />
	<xlate value="1" string="54kHz" />
	<xlate value="2" string="13.5kHz" />
	<xlate value="3" string="3.375kHz" />
</item>

<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "108000"
	validity			= "Filter .EQ. 0"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "The LWS/TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "54000"
	validity			= "Filter .EQ. 1"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "The LWS/TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "13500"
	validity			= "Filter .EQ. 2"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "The LWS/TDS low-pass filter setting (Hertz)" >
</item>
<item
	name				= "Filter_Hz"
	dataType			= "Integer"
	fixed_value			= "3375"
	validity			= "Filter .EQ. 3"
	family				= "TDS State"
	dateCreated			= "4.12.2005"
	description			= "The LWS/TDS low-pass filter setting (Hertz)" >
</item>

<item
	name				= "TDS_Stable"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20 * 8 + 2"
	lengthInBits			= "1"
	dateCreated			= "4.12.2005"
	description			= "Indicates that we had TDS state changes during histogram collection" >
	<xlate value="0" string="Stable" />
	<xlate value="1" string="Changed" />
</item>

<item
	name				= "CAL_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20 * 8 + 1"
	lengthInBits			= "1"
	dateCreated			= "4.12.2005"
	description			= "Calibration state during this histogram" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Thruster_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "Thruster_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8 + 3"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>
<item
	name				= "Thruster_State_TEST"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8 + 3"
	lengthInBits			= "1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad).
						Should be used only after 2 April 2008." >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8 + 2"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>
<item
	name				= "HGA_Motion_State_TEST"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8 + 2"
	lengthInBits			= "1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event.
						Should be used only after 2 April 2008." >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Accumulate16bits"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8 + 1"
	lengthInBits			= "1"
	dateCreated			= "5.12.2005"
	description			= "Indicates that the histogram accumulation words are 16 bits long" >
	<xlate value="0" string="NOT 16-bits" />
	<xlate value="1" string="16-bits" />
</item>

<item
	name				= "Absolute_Values"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "21 * 8"
	lengthInBits			= "1"
	dateCreated			= "4.12.2005"
	description			= "Indicates that we are doing absolute valued histograms" >
	<xlate value="0" string="Signed" />
	<xlate value="1" string="Absolute Value" />
</item>
