<item
	name				= "Channel_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20*8 + 5"
	lengthInBits			= "3"
	dateCreated			= "4.12.2005"
	description			= "The current channel (counting from one)" >
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>
<item
	name				= "Channel"
	dataType			= "Integer"
	fixed_value			= "Channel_Raw"
	dateCreated			= "4.12.2005"
	description			= "LWS histogram channel number" >
	<xlate value="1" string="Ch1" />
	<xlate value="2" string="Ch2" />
	<xlate value="3" string="Ch3" />
	<xlate value="4" string="Ch4" />
</item>

<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch1"
	validity			= "Channel_Raw .EQ. 1"
	dateCreated			= "4.12.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey-Ez" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch2"
	validity			= "Channel_Raw .EQ. 2"
	dateCreated			= "4.12.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ey" />
	<xlate value="1" string="Ex-Ez" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch3"
	validity			= "Channel_Raw .EQ. 3"
	dateCreated			= "4.12.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ez" />
	<xlate value="1" string="Ex-Ey" />
</item>
<item
	name				= "Source"
	dataType			= "Integer"
	fixed_value			= "Path_Ch4"
	validity			= "Channel_Raw .EQ. 4"
	dateCreated			= "4.12.2005"
	description			= "Source antenna" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "data"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "26 * 8"
	lengthInBits			= "16"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "Nbins"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	hidden				= "true"
	dateCreated			= "4.12.2005"
	description			= "LWS histogram data (counts).
						Return is an integer array of size Nbins."
/>

<item
	name				= "Histogram"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "26 * 8"
	lengthInBits			= "16"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "Nbins"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	dateCreated			= "27.1.2007"
	description			= "LWS histogram data (counts).
						Return is an integer array of size Nbins."
/>

<item
	name				= "Bin_Width"
	dataType			= "float"
	fixed_value			= "65536/Nbins"
	validity			= "Absolute_Values .EQ. 0"
	hidden				= "true"
	dateCreated			= "27.1.2007"
	description			= "The width of an LWS bin in TDS counts (counts/bin)" >
</item>
<item
	name				= "Bin_Width"
	dataType			= "float"
	fixed_value			= "32768/Nbins"
	validity			= "Absolute_Values .EQ. 1"
	hidden				= "true"
	dateCreated			= "27.1.2007"
	description			= "The width of an LWS bin in TDS counts (counts/bin)" >
</item>

<item
	name				= "TDS_mV2counts"
	dataType			= "Integer"
	fixed_value			= "-187"
	hidden				= "true"
	dateCreated			= "18.10.2005"
	description			= "Convert TDS counts to mVolts without proper frequency response (counts/mV)" >
</item>
<item
	name				= "TDS_V2counts"
	dataType			= "float"
	fixed_value			= "TDS_mV2counts / 1000. "
	hidden				= "true"
	dateCreated			= "30.4.2008"
	description			= "Convert TDS counts to Volts (counts/V)" >
</item>

<item
	name				= "mV2counts"
	dataType			= "float"
	fixed_value			= "TDS_mv2counts/Bin_width"
	hidden				= "true"
	dateCreated			= "18.10.2005"
	description			= "Convert LWS bins to mVolts (bins/mV)" >
</item>
<item
	name				= "V2counts"
	dataType			= "float"
	fixed_value			= "mV2counts / 1000. "
	hidden				= "true"
	dateCreated			= "18.10.2005"
	description			= "Convert LWS bins to Volts (bins/V)" >
</item>

<item
	name				= "Starting_Bin"
	dataType			= "Integer"
	fixed_value			= "-Nbins/2"
	validity			= "Absolute_Values .EQ. 0"
	hidden				= "true"
	dateCreated			= "27.1.2007"
	description			= "Starting point for histogram range (counts)" >
</item>
<item
	name				= "Starting_Bin"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "Absolute_Values .EQ. 1"
	hidden				= "true"
	dateCreated			= "27.1.2007"
	description			= "Starting point for histogram range (counts)" >
</item>

<item
	name				= "Histogram_Range_Bins"
	dataType			= "Integer"
	fixed_value			= "I4GEN(Starting_Bin,1,NBins,1,1)"
	hidden				= "true"
	dateCreated			= "27.1.2007"
	description			= "The range of histogram bins - typically from -128 to +127.
						Return is an integer array of size Nbins."
/>

<item
	name				= "Histogram_Range_Raw"
	dataType			= "float"
	fixed_value			= "Histogram_Range_Bins * Bin_Width"
	dateCreated			= "30.4.2008"
	description			= "The range of histogram bins in TDS TM units - typically from -32,768 to +32,767 (counts).
						Values are the raw TDS TM value at the bottom of the bin (toward negative infinity).
						Return is a floating point (but the elements are usually integers) array of size Nbins."
/>

<item
	name				= "Histogram_Range_mV"
	dataType			= "float"
	fixed_value			= "Histogram_Range_Bins / mV2counts"
	dateCreated			= "27.1.2007"
	description			= "The range of histogram bins - typically from about -175mV to about +175mV and is the voltage at the preamp input (milliVolts).
						Return is a floating point array of size Nbins."
/>
<item
	name				= "Histogram_Range_Volts"
	dataType			= "float"
	fixed_value			= "Histogram_Range_Bins / V2counts"
	dateCreated			= "27.1.2007"
	description			= "The range of histogram bins - typcially from -0.175V to +0.175V and is the voltage at the preamp input (Volts).
						Return is a floating point array of size Nbins."
/>
