<item
	name				= "SCET_UR8"
	dataType			= "double"
	fixed_value			= "CCSDS_SCET_UR8"
	dateCreated			= "1.3.2005"
	description			= "SpaceCraft Event Time (UR8).  
						This value is the time at which the event was acquired.
						That is, it is the time of the end of the event.
						Other timing values should be used for precise datation.
						This value is accurate to about 4ms." >
</item>


<item
	name				= "EventID"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "0"
	lengthInBits			= "32"
	dateCreated			= "21.9.2005"
	description			= "LRS burst event ID number" >
</item>

<item
	name				= "TDS_Clock"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "4 * 8"
	lengthInBits			= "32"
	dateCreated			= "21.9.2005"
	description			= "TDS clock value - datation at end of event acquisition" >
</item>

<item
	name				= "CPU_Clock"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "8 * 8"
	lengthInBits			= "32"
	dateCreated			= "21.9.2005"
	description			= "High resolution 32-bit CPU clock - datation at end of event acquisition (tics (about 100ns/tic (see item CPU_Clock_to_Seconds)))" >
</item>

<item
	name				= "Nsamples"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "12 * 8"
	lengthInBits			= "16"
	dateCreated			= "21.9.2004"
	description			= "Number of samples in this event" >
</item>

<item
	name				= "Trigger_Mode"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14 * 8 + 5"
	lengthInBits			= "3"
	dateCreated			= "21.9.2005"
	description			= "Current triggering mode" >
	<xlate value="0" string="?0" />
	<xlate value="1" string="?1" />
	<xlate value="2" string="?2" />
	<xlate value="3" string="?3" />
	<xlate value="4" string="?4" />
	<xlate value="5" string="?5" />
	<xlate value="6" string="?6" />
	<xlate value="7" string="?7" />
</item>

<item
	name				= "Trigger_Cause"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14 * 8 + 2"
	lengthInBits			= "3"
	dateCreated			= "21.9.2005"
	description			= "Triggering mechanism for this event" >
	<xlate value="0" string="?0" />
	<xlate value="1" string="?1" />
	<xlate value="2" string="?2" />
	<xlate value="3" string="?3" />
	<xlate value="4" string="?4" />
	<xlate value="5" string="?5" />
	<xlate value="6" string="?6" />
	<xlate value="7" string="?7" />
</item>

<item
	name				= "Channel"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 7"
	lengthInBits			= "3"
	dateCreated			= "21.9.2005"
	description			= "Channel for this event" >
	<xlate value="0" string="Ex APM" />
	<xlate value="1" string="Ey APM" />
	<xlate value="2" string="Ez APM" />
	<xlate value="3" string="Ex LRS" />
	<xlate value="4" string="Ey LRS" />
	<xlate value="5" string="Ez LRS" />
	<xlate value="6" string="Ex-Ey LRS" />
	<xlate value="7" string="Ex-Ez LRS" />
</item>

<item
	name				= "Antenna"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 7"
	lengthInBits			= "3"
	dateCreated			= "4.10.2005"
	description			= "Antenna for this event" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex" />
	<xlate value="4" string="Ey" />
	<xlate value="5" string="Ez" />
	<xlate value="6" string="Ex-Ey" />
	<xlate value="7" string="Ex-Ez" />
</item>

<item
	name				= "Source"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 7"
	lengthInBits			= "3"
	dateCreated			= "18.10.2005"
	description			= "Source antenna for this event" >
	<xlate value="0" string="Ex" />
	<xlate value="1" string="Ey" />
	<xlate value="2" string="Ez" />
	<xlate value="3" string="Ex" />
	<xlate value="4" string="Ey" />
	<xlate value="5" string="Ez" />
	<xlate value="6" string="Ex-Ey" />
	<xlate value="7" string="Ex-Ez" />
</item>

<item
	name				= "Type"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 7"
	lengthInBits			= "3"
	dateCreated			= "4.10.2005"
	description			= "Band (LRS or APM) for this event" >
	<xlate value="0" string="APM" />
	<xlate value="1" string="APM" />
	<xlate value="2" string="APM" />
	<xlate value="3" string="LRS" />
	<xlate value="4" string="LRS" />
	<xlate value="5" string="LRS" />
	<xlate value="6" string="LRS" />
	<xlate value="7" string="LRS" />
</item>

<item
	name				= "Calibration_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 6"
	lengthInBits			= "1"
	dateCreated			= "24.3.2005"
	description			= "Indicates a calibration event" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Thruster_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "Thruster_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 5"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>
<item
	name				= "Thruster_State_TEST"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 5"
	lengthInBits			= "1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C was thrusting during or near this event (On is apt to be bad).
						Should be used only after 2 April 2008." >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "SWAVES_Packet_SubType .LE. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="2" string="Unknown" />
</item>
<item
	name				= "HGA_Motion_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 4"
	lengthInBits			= "1"
	validity			= "SWAVES_Packet_SubType .GT. 1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>
<item
	name				= "HGA_Motion_State_TEST"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8 + 4"
	lengthInBits			= "1"
	dateCreated			= "10.4.2008"
	description			= "Indicates S/C high gain antenna was moving during or near this event.
						Should be used only after 2 April 2008." >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Spare"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "15 * 8"
	lengthInBits			= "4"
	hidden				= "true"
	dateCreated			= "24.3.2005"
	description			= "Spare bits" >
</item>

<item
	name				= "Sample_Speed"
	dataType			= "Integer"
	fixed_value			= "64"
	dateCreated			= "13.10.2005"
	description			= "LRS uncorrected sampling speed (64 samples per second)" >
	<xlate value="64" string="64s/s" />
</item>

<item
	name				= "Sample_Speed_SPS"
	dataType			= "float"
	fixed_value			= "ADC_Speed_SPS/128."
	dateCreated			= "13.10.2005"
	description			= "LRS true sampling speed (samples per second)" >
</item>

<item
	name				= "Sample_Period_Seconds"
	dataType			= "float"
	fixed_value			= "1. / Sample_Speed_SPS"
	dateCreated			= "13.10.2005"
	description			= "Sample period (seconds)" >
</item>

<item
	name				= "Event_Period_Seconds"
	dataType			= "float"
	fixed_value			= "Sample_Period_Seconds * Nsamples"
	dateCreated			= "13.10.2005"
	description			= "Event period (seconds)" >
</item>

<item
	name				= "ADC_Speed_SPS"
	dataType			= "float"
	fixed_value			= "8137.748"
	hidden				= "true"
	dateCreated			= "21.02.2007"
	note				= "Astoundingly, this value is correct.  The 64sps sampling speed is actually 63.58sps.  Dunno why."
	description			= "LRS ADC true sampling speed (samples per second)" >
</item>

<item
	name				= "ADC_Period_Seconds"
	dataType			= "float"
	fixed_value			= "1. / ADC_Speed_SPS"
	hidden				= "true"
	dateCreated			= "21.02.2007"
	description			= "ADC sample period (seconds)" >
</item>
