<item
	name				= "Time_Series_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "16 * 8"
	lengthInBits			= "16"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "Nsamples"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	signed				= "1"
	hidden				= "true"
	dateCreated			= "21.9.2005"
	description			= "LRSburst time series array of length Nsamples (TM units)" >
</item>

<item
	name				= "Time_Series_mV"
	dataType			= "float"
	fixed_value			= "Time_Series_Raw / mV2counts"
	dateCreated			= "4.10.2005"
	description			= "LRSburst time series array of length Nsamples (mVolts (no frequency correction)).
						 Value is the voltage at the preamp input" >
</item>

<item
	name				= "Time_Series_V"
	dataType			= "float"
	fixed_value			= "Time_Series_mV / 1000."
	dateCreated			= "4.10.2005"
	description			= "LRSburst time series array of length Nsamples (Volts (no frequency correction)).
						 Value is the voltage at the preamp input" >
</item>

<item
	name				= "Spectrum_dBs"
	dataType			= "float"
	fixed_value			= "Time_Series2Spectrum_dBs_V1(Time_Series_V)"
	dateCreated			= "29.1.2009"
	description			= "LRS power spectrum in dBs. 
						Uncorrected LRS time series (in Volts) is FFTed and converted to dBs.
						This is an array of length Spectrum_Length.
						Conversion will fail in rare cases when the LRS event length is not a power of two.
						Values range from about TBD dBs to TBD dBs." >
</item>
<item
	name				= "Spectrum_f0"
	dataType			= "float"
	fixed_value			= "Sample_Speed_SPS/Nsamples"
	dateCreated			= "29.1.2009"
	description			= "The first/lowest frequency and the frequency step size in the LRS spectrum (Hertz)" >
</item>
<item
	name				= "Spectrum_fMax"
	dataType			= "float"
	fixed_value			= "Sample_Speed_SPS/2."
	dateCreated			= "29.1.2009"
	description			= "The top/highest or Nyquist frequency in the LRS spectrum (Hertz)" >
</item>
<item
	name				= "Spectrum_Length"
	dataType			= "Integer"
	fixed_value			= "Nsamples/2 + 1"
	dateCreated			= "29.1.2009"
	description			= "Length of the various LRS spectrum arrays (nominally this is N/2+1)" >
</item>
<item
	name				= "Spectrum_Frequencies"
	dataType			= "Float"
	fixed_value			= "R4GEN(0,1,Spectrum_Length,1,1,Spectrum_f0,0.)"
	dateCreated			= "29.1.2009"
	description			= "Frequency values for the LRS spectra starting at zero (DC) and counting up to Spectrum_fMax (Hertz).
						This is an array of length Spectrum_Length." >
</item>

<item
	name				= "Noffset"
	dataType			= "Integer"
	fixed_value			= "1 - Nsamples"
	hidden				= "true"
	dateCreated			= "1.2.2007"
	description			= "Number of samples in the past for the start of this event (a negative value)" >
</item>

<item
	name				= "Toffset"
	dataType			= "Float"
	fixed_value			= "(Channel - 27) * ADC_Period_Seconds"
	hidden				= "true"
	dateCreated			= "21.2.2007"
	description			= "Number of seconds in the past for this channel (a negative value)" >
</item>

<item
	name				= "Time_Series_Times"
	dataType			= "Float"
	fixed_value			= "R4GEN(0,1,Nsamples,1,1,Sample_Period_Seconds,0.)"
	dateCreated			= "1.2.2007"
	description			= "Time values for the LRS burst time series starting at zero and counting up (seconds).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond."
/>
<item
	name				= "Time_Series_Sample_Times"
	dataType			= "Float"
	fixed_value			= "R4GEN(Noffset,1,Nsamples,1,1,Sample_Period_Seconds,Toffset)"
	dateCreated			= "1.2.2007"
	description			= "Sample times for the LRS burst time series w/r/t the SCET - negative and counting up to about zero (seconds).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond."
/>
<item
	name				= "Time_Series_Sample_Times_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Series_Sample_Times*Seconds2UR8"
	dateCreated			= "1.2.2007"
	description			= "Actual time values for the LRS burst time series (UR8).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond but some numerical accuracy may be lost.
						Absolute timing is only accurate to 4ms."
/>
<item
	name				= "Time_Series_SCET_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Series_Sample_Times*Seconds2UR8"
	dateCreated			= "7.3.2007"
	description			= "Actual time values for the LRS burst time series (UR8).
						This is an array of length Nsamples.
						Relative timing is accurate to one microsecond but some numerical accuracy may be lost.
						Absolute timing is only accurate to 4ms."
/>

<item
	name				= "Time_Start"
	dataType			= "Float"
	fixed_value			= "Noffset*Sample_Period_Seconds + Toffset"
	hidden				= "true"
	dateCreated			= "5.6.2008"
	description			= "Time in the past of the first sample of the LRSburst time series (seconds)."
/>
<item
	name				= "Time_Center"
	dataType			= "Float"
	fixed_value			= "Noffset*Sample_Period_Seconds/2 + Toffset"
	hidden				= "true"
	dateCreated			= "5.6.2008"
	description			= "Time in the past of the exact center (not usually an actual sample time) of the LRSburst time series (seconds)."
/>
<item
	name				= "Time_End"
	dataType			= "Float"
	fixed_value			= "Toffset"
	hidden				= "true"
	dateCreated			= "5.6.2008"
	description			= "Time in the past of the last sample of the LRSburst time series (seconds)."
/>

<item
	name				= "SCET_Start_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Start*Seconds2UR8"
	dateCreated			= "5.6.2008"
	description			= "Correct time for the first sample of the LRSburst time series (UR8).
						Absolute timing is accurate to 4ms."
/>
<item
	name				= "SCET_Center_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_Center*Seconds2UR8"
	dateCreated			= "5.6.2008"
	description			= "Correct time for the exact center (not usually an actual sample time) of the LRSburst time series (UR8).
						Absolute timing is accurate to 4ms."
/>
<item
	name				= "SCET_End_UR8"
	dataType			= "double"
	fixed_value			= "SCET_UR8 + Time_End*Seconds2UR8"
	dateCreated			= "5.6.2008"
	description			= "Correct time for the last sample of the LRSburst time series (UR8).
						Absolute timing is accurate to 4ms."
/>
