<!--  include file of common items for both HFR1 and HFR2 -->

<item
	name				= "RX_Samples_per_Second"
	dataType			= "Integer"
	fixed_value			= "464286"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Time series sampling speed (464,286 samples/second).
						Not for everyday use."
/>

<item
	name				= "RX_Samples_per_Block"
	dataType			= "Integer"
	fixed_value			= "191"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Time series block size (191 samples/block).
						Not for everyday use."
/>

<item
	name				= "Blocks_per_Element"
	dataType			= "Integer"
	fixed_value			= "29"
	validity			= "Integration_Time .EQ. 0"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Number of blocks per measurement cycle or element (blocks/element).
						Not for everyday use."
/>
<item
	name				= "Blocks_per_Element"
	dataType			= "Integer"
	fixed_value			= "58"
	validity			= "Integration_Time .EQ. 1"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Number of blocks per measurement cycle or element (blocks/element).
						Not for everyday use."
/>
<item
	name				= "Blocks_per_Element"
	dataType			= "Integer"
	fixed_value			= "116"
	validity			= "Integration_Time .EQ. 2"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Number of blocks per measurement cycle or element (blocks/element).
						Not for everyday use."
/>
<item
	name				= "Blocks_per_Element"
	dataType			= "Integer"
	fixed_value			= "232"
	validity			= "Integration_Time .EQ. 3"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "Number of blocks per measurement cycle or element (blocks/element).
						Not for everyday use."
/>

<item
	name				= "Time_per_Element_ms"
	dataType			= "Float"
	fixed_value			= "36."
	validity			= "Integration_Time .EQ. 0"
	hidden				= "true"
	family				= "HFR info"
	dateCreated			= "25.7.2006"
	description			= "Time for each element in a spectrum/sweep (ms/element)"
/>
<item
	name				= "Time_per_Element_ms"
	dataType			= "Float"
	fixed_value			= "63."
	validity			= "Integration_Time .EQ. 1"
	hidden				= "true"
	family				= "HFR info"
	dateCreated			= "25.7.2006"
	description			= "Time for each element in a spectrum/sweep (ms/element)"
/>
<item
	name				= "Time_per_Element_ms"
	dataType			= "Float"
	fixed_value			= "117."
	validity			= "Integration_Time .EQ. 2"
	hidden				= "true"
	family				= "HFR info"
	dateCreated			= "25.7.2006"
	description			= "Time for each element in a spectrum/sweep (ms/element)"
/>
<item
	name				= "Time_per_Element_ms"
	dataType			= "Float"
	fixed_value			= "224."
	validity			= "Integration_Time .EQ. 3"
	hidden				= "true"
	family				= "HFR info"
	dateCreated			= "25.7.2006"
	description			= "Time for each element in a spectrum/sweep (ms/element)"
/>

<item
	name				= "Time_per_Element"
	dataType			= "Float"
	fixed_value			= "Time_per_Element_ms / 1000."
	family				= "HFR info"
	dateCreated			= "19.3.2007"
	description			= "Time for each element in a spectrum/sweep (s/element)"
/>

<item
	name				= "RX_Frequency_Base_Hz"
	dataType			= "Integer"
	fixed_value			= "125000"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "The frequency corresponding to channel zero (always 125,000Hz)"
/>

<item
	name				= "RX_Frequency_Step_Hz"
	dataType			= "Integer"
	fixed_value			= "50000"
	family				= "HFR info"
	dateCreated			= "26.3.2005"
	description			= "The frequency increment - one channel to the next (always 50,000Hz)"
/>

<item
	name				= "HFR_State"
	dataType			= "Integer"
	fixed_value			= "H1_State + H2_State"
	hidden				= "true"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "How many HF receivers are on in this event - should be 1"
/>

<item
	name				= "Setup_Offset"
	dataType			= "Integer"
	fixed_value			= "23*8"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(Band_A_State .EQ. 0)		.AND.
						(Band_B_State .EQ. 0)		.AND.
						(Band_C_State .EQ. 0)"
	hidden				= "true"
	dateCreated			= "9.9.2004"
	description			= "Offset of setup word from start of event"
/>

<item
	name				= "HFR_Setup"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 8"
	lengthInBits			= "12"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "Entire HFR setup word as integer"
/>

<item
	name				= "CAL_Mode"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 2"
	lengthInBits			= "1"
	family				= "HFR state"
	dateCreated			= "2.11.2004"
	description			= "HFR CAL mode" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "CAL_Step_Number"
	dataType			= "Integer"
	fixed_value			= "Sequence_Number"
	validity			= "(CAL_Mode .EQ. 1)"
	family				= "HFR state"
	dateCreated			= "20.5.2008"
	description			= "HFR CAL step number counting from 1 to 10 when in internal calibration mode" >
</item>
<item
	name				= "CAL_Step_Number"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "(CAL_Mode .NE. 1)"
	family				= "HFR state"
	dateCreated			= "20.5.2008"
	description			= "HFR CAL step number counting from 1 to 10 when in internal calibration mode" >
</item>

<item
	name				= "DF_Mode"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 0"
	lengthInBits			= "2"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR Direction Finding mode" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="DF1" />
	<xlate value="2" string="DF2" />
	<xlate value="3" string="NAN" />
</item>

<item
	name				= "Auto_Mode"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 14"
	lengthInBits			= "1"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR Auto Correlation" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>


<item
	name				= "Cross_Mode"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 15"
	lengthInBits			= "1"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR Cross Correlation" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Integration_time"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 12"
	lengthInBits			= "2"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR integration time" >
	<xlate value="0" string="2.5ms" />
	<xlate value="1" string="5ms" />
	<xlate value="2" string="10ms" />
	<xlate value="3" string="20ms" />
</item>

<!-- Antenna Selections -->

<item
	name				= "Antenna_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 8"
	lengthInBits			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR Channel 1 Antenna selection" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>
<item
	name				= "Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "4"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "HFR state"
	dateCreated			= "24.3.2005"
	description			= "HFR Channel 1 Antenna selection" >
	<xlate value="4" string="DF1" />
</item>
<item
	name				= "Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "5"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "HFR state"
	dateCreated			= "24.3.2005"
	description			= "HFR Channel 1 Antenna selection" >
	<xlate value="5" string="DF2" />
</item>
<item
	name				= "Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "6"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 1)"
	family				= "HFR state"
	dateCreated			= "3.1.2008"
	description			= "HFR Channel 1 Antenna selection" >
	<xlate value="6" string="NG" />
</item>

<item
	name				= "Spectrum1_Antenna_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 8"
	lengthInBits			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "3"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "6"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "3.1.2008"
	description			= "HFR Channel 1 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="6" string="NG" />
</item>

<item
	name				= "Spectrum2_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the second spectrum/sweep in an event (only present in DF modes)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>
<item
	name				= "Spectrum2_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the second spectrum/sweep in an event (only present in DF modes)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>

<item
	name				= "Spectrum3_Antenna_Ch1"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 1 Antenna for the third spectrum/sweep in an event (only present in DF mode 2)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ex" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ex-Ey" />
</item>


<item
	name				= "Antenna_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 10"
	lengthInBits			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR Channel 2 Antenna selection" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>
<item
	name				= "Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "4"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "HFR state"
	dateCreated			= "24.3.2005"
	description			= "HFR Channel 2 Antenna selection" >
	<xlate value="4" string="DF1" />
</item>
<item
	name				= "Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "5"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "HFR state"
	dateCreated			= "24.3.2005"
	description			= "HFR Channel 2 Antenna selection" >
	<xlate value="5" string="DF2" />
</item>
<item
	name				= "Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "6"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 1)"
	family				= "HFR state"
	dateCreated			= "3.1.2008"
	description			= "HFR Channel 2 Antenna selection" >
	<xlate value="6" string="NG" />
</item>

<item
	name				= "Spectrum1_Antenna_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 10"
	lengthInBits			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>
<item
	name				= "Spectrum1_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "6"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(CAL_Mode  .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "3.1.2008"
	description			= "HFR Channel 2 Antenna for the first spectrum/sweep in an event (always present)" >
	<xlate value="6" string="NG" />
</item>

<item
	name				= "Spectrum2_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "3"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 1)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the second spectrum/sweep in an event (only present in DF modes)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>
<item
	name				= "Spectrum2_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the second spectrum/sweep in an event (only present in DF modes)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>

<item
	name				= "Spectrum3_Antenna_Ch2"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "	(HFR_State .EQ. 1)		.AND.
						(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "2.8.2006"
	description			= "HFR Channel 2 Antenna for the third spectrum/sweep in an event (only present in DF mode 2)" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="+Ez" />
	<xlate value="2" string="-Ey" />
	<xlate value="3" string="Ez-Ey" />
</item>

<!-- HFR Configuration -->

<item
	name				= "RX_Channel_Numbers"
	dataType			= "Integer"
	fixed_value			= "I4GEN(0,1,319,1,1)"
	family				= "HFR info"
	dateCreated			= "2.3.2006"
	description			= "All HFR 1 and 2 channel numbers [0-318]"
/>
<item
	name				= "RX_Frequencies_Hz"
	dataType			= "Integer"
	fixed_value			= "125000 + RX_Channel_Numbers * 50000"
	family				= "HFR info"
	dateCreated			= "2.3.2006"
	description			= "All 319 HFR 1 and 2 frequency values from 125kHz to 16.025MHz (in Hz)"
/>

<item
	name				= "Starting_Frequency_N"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 24"
	lengthInBits			= "12"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR sweep - starting frequency number [0-318]"
/>
<item
	name				= "Starting_Frequency_Hz"
	dataType			= "Integer"
	fixed_value			= "RX_Frequency_Base_Hz + Starting_Frequency_N * RX_Frequency_Step_Hz"
	family				= "HFR state"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep - starting frequency (Hz)"
/>

<item
	name				= "Stepping_Frequency_N"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 40"
	lengthInBits			= "12"
	signed				= "1"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR sweep - stepping frequency number (often 1) [0-255]"
/>
<item
	name				= "Stepping_Frequency_Hz"
	dataType			= "Integer"
	fixed_value			= "Stepping_Frequency_N * RX_Frequency_Step_Hz"
	family				= "HFR state"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep - stepping frequency number (often 50,000Hz)"
/>

<item
	name				= "Number_of_Steps"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Setup_Offset + 56"
	lengthInBits			= "12"
	family				= "HFR state"
	dateCreated			= "9.9.2004"
	description			= "HFR sweep - number of steps or elements in sweep [1-511]"
/>

<item
	name				= "Sweep_Mode"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "Stepping_Frequency_N .EQ. 0"
	family				= "HFR state"
	dateCreated			= "29.8.2006"
	description			= "Sweeping mode (sweeping or fixed-tune)">
	<xlate value="1" string="Fixed" />
	<xlate value="2" string="Sweeping" />
</item>
<item
	name				= "Sweep_Mode"
	dataType			= "Integer"
	fixed_value			= "2"
	validity			= "Stepping_Frequency_N .NE. 0"
	family				= "HFR state"
	dateCreated			= "29.8.2006"
	description			= "Sweeping mode (sweeping or fixed-tune)">
	<xlate value="1" string="Fixed" />
	<xlate value="2" string="Sweeping" />
</item>

<item
	name				= "Spectrum_Channel_Numbers"
	dataType			= "Integer"
	fixed_value			= "I4GEN(Starting_Frequency_N,Stepping_Frequency_N,Number_of_Steps,1,1)"
	family				= "HFR state"
	dateCreated			= "2.3.2006"
	description			= "HFR spectrum/sweep channel numbers.
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same channel numbers.
						Always exists."
/>

<item
	name				= "Spectrum1_Channel_Numbers"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Channel_Numbers"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR spectrum/sweep channel numbers for the first spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same channel numbers.
						Same as Spectrum_Channel_Numbers.  Provided for symmetry.
						Always exists."
/>
<item
	name				= "Spectrum2_Channel_Numbers"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Channel_Numbers"
	validity			= "	(DF_Mode .NE. 0)"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR spectrum/sweep channel numbers for the second spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same channel numbers.
						Same as Spectrum_Channel_Numbers.  Provided for symmetry.
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum3_Channel_Numbers"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Channel_Numbers"
	validity			= "	(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR spectrum/sweep channel numbers for the third spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same channel numbers.
						Same as Spectrum_Channel_Numbers.  Provided for symmetry.
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum_Frequencies_Hz"
	dataType			= "Integer"
	fixed_value			= "RX_Frequency_Base_Hz + Spectrum_Channel_Numbers * RX_Frequency_Step_Hz"
	family				= "HFR state"
	dateCreated			= "8.3.2006"
	description			= "HFR sweep frequency values (Hz).
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same frequencies.
						Always exists."
/>

<item
	name				= "Spectrum1_Frequencies_Hz"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Frequencies_Hz"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR sweep frequency values for the first spectrum/sweep of the event (Hz).
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same frequencies.
						Same as Spectrum_Frequencies_Hz.  Provided for symmetry.
						Always exists."
/>
<item
	name				= "Spectrum2_Frequencies_Hz"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Frequencies_Hz"
	validity			= "	(DF_Mode .NE. 0)"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR sweep frequency values for the second spectrum/sweep of the event (Hz).
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same frequencies.
						Same as Spectrum_Frequencies_Hz.  Provided for symmetry.
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum3_Frequencies_Hz"
	dataType			= "Integer"
	fixed_value			= "Spectrum_Frequencies_Hz"
	validity			= "	(DF_Mode .EQ. 2)"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "HFR sweep frequency values for the third spectrum/sweep of the event (Hz).
						Returns an array of Spectrum_Size elements.
						All spectra (in DF modes) have the same frequencies.
						Same as Spectrum_Frequencies_Hz.  Provided for symmetry.
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "SCET_UR8"
	dataType			= "double"
	fixed_value			= "CCSDS_SCET_UR8"
	dateCreated			= "1.3.2005"
	description			= "SpaceCraft Event Time (UR8).  This value and other UR8 timing is accurate to about 4ms."
/>

<item
	name				= "Spectrum1_Sample_Numbers"
	dataType			= "Integer"
	fixed_value			= "I4GEN(0,Spectrum_Count,Number_of_Steps,1,1)"
	hidden				= "true"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample numbers (counting from 0) for the first spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements."
/>
<item
	name				= "Spectrum1_Sample_Times"
	dataType			= "Float"
	fixed_value			= ".000330 + Spectrum1_Sample_Numbers*Time_per_Element"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample times (seconds from event time (from 0)) for the first spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Always exists."
/>
<item
	name				= "Spectrum1_Sample_Times_UR8"
	dataType			= "Double"
	fixed_value			= "SCET_UR8 + Spectrum1_Sample_Times*Seconds2UR8"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR spectrum/sweep sample event times for the first spectrum/sweep of the event (UR8).
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Absolute timing is only accurate to 4ms.
						Always exists."
/>

<item
	name				= "Spectrum2_Sample_Numbers"
	dataType			= "Integer"
	fixed_value			= "I4GEN(1,Spectrum_Count,Number_of_Steps,1,1)"
	validity			= "	(DF_Mode .NE. 0)"
	hidden				= "true"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample numbers for the second spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum2_Sample_Times"
	dataType			= "Float"
	fixed_value			= ".000330 + Spectrum2_Sample_Numbers*Time_per_Element"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample times (seconds from event time) for the second spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum2_Sample_Times_UR8"
	dataType			= "Double"
	fixed_value			= "SCET_UR8 + Spectrum2_Sample_Times*Seconds2UR8"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR spectrum/sweep sample event times for the second spectrum/sweep of the event (UR8).
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Absolute timing is only accurate to 4ms.
						Exists only with direction finding enabled."
/>

<item
	name				= "Spectrum3_Sample_Numbers"
	dataType			= "Integer"
	fixed_value			= "I4GEN(2,Spectrum_Count,Number_of_Steps,1,1)"
	validity			= "	(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample numbers for the third spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						Exists only with direction finding mode 2 enabled."
/>
<item
	name				= "Spectrum3_Sample_Times"
	dataType			= "Float"
	fixed_value			= ".000330 + Spectrum3_Sample_Numbers*Time_per_Element"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR sweep sample times (seconds from event time) for the third spectrum/sweep of the event.
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Exists only with direction finding mode 2 enabled."
/>
<item
	name				= "Spectrum3_Sample_Times_UR8"
	dataType			= "Double"
	fixed_value			= "SCET_UR8 + Spectrum3_Sample_Times*Seconds2UR8"
	family				= "Spectral info"
	dateCreated			= "25.7.2006"
	description			= "HFR spectrum/sweep sample event times for the third spectrum/sweep of the event (UR8).
						Returns an array of Spectrum_Size elements.
						Relative timing is accurate to one ms.
						Absolute timing is only accurate to 4ms.
						Exists only with direction finding mode 2 enabled."
/>

<!-- Calibration items for HFR auto correlations -->

<item
	name				= "Cal_A_Ch1_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_A_Ch1_V02.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "Name of the HFR AGC calibration file for Channel 1"
/>
<item
	name				= "Cal_A_Ch2_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_A_Ch2_V02.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "Name of the HFR AGC calibration file for Channel 2"
/>

<item
	name				= "Cal_dBs_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_dB_V02.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "Name of the HFR dB calibration file"
/>

<item
	name				= "Rx_Cal_A1_Ch1"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch1_File,7,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The full receiver A1 calibration vector (319) - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A1_Ch1"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Cal_A1_Ch1)"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A1 calibration vector - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_A2_Ch1"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch1_File,6,0,1,1,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The A2 calibration scalar - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A2_Ch1"
	dataType			= "Float"
	fixed_value			= "Rx_Cal_A2_Ch1"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A2 calibration scalar - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_A3_Ch1"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch1_File,6,1,1,1,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The A3 calibration scalar - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A3_Ch1"
	dataType			= "Float"
	fixed_value			= "Rx_Cal_A3_Ch1"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A3 calibration scalar - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_A1_Ch2"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch2_File,7,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The full receiver A1 calibration vector (319) - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A1_Ch2"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Cal_A1_Ch2)"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A1 calibration vector - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_A2_Ch2"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch2_File,6,0,1,1,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The A2 calibration scalar - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A2_Ch2"
	dataType			= "Float"
	fixed_value			= "Rx_Cal_A2_Ch2"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A2 calibration scalar - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_A3_Ch2"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_A_Ch2_File,6,1,1,1,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The A3 calibration scalar - used to convert the AGC value to physical units"
/>
<item
	name				= "Cal_A3_Ch2"
	dataType			= "Float"
	fixed_value			= "Rx_Cal_A3_Ch2"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The A3 calibration scalar - used to convert the AGC value to physical units"
/>

<item
	name				= "Rx_Cal_dBcal"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_dBs_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "8.5.2007"
	description			= "The full receiver dBcal calibration array (319) of dB offsets used to produce the power spectrum"
/>
<item
	name				= "Cal_dBcal"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Cal_dBcal)"
	family				= "Calibrations"
	dateCreated			= "30.1.2008"
	description			= "The dBcal calibration array of dB offsets used to produce the power spectrum"
/>

<!-- Calibration items for HFR cross products -->

<item
	name				= "Cal_Phase_Offsets_Ex_Ey_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Y_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the +Ex and -Ey antenna configuration"
/>
<item
	name				= "Cal_Phase_Offsets_Ex_Ez_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Z_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the +Ex and +Ez antenna configuration"
/>
<item
	name				= "Cal_Phase_Offsets_Ey_Ez_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_Y_Z_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the -Ey and +Ez antenna configuration"
/>
<item
	name				= "Cal_Phase_Offsets_Ex_EzEy_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_ZY_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the +Ex and +Ez-Ey antenna configuration"
/>
<item
	name				= "Cal_Phase_Offsets_ExEy_Ez_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_XY_Z_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the +Ex-Ey and +Ez antenna configuration"
/>
<item
	name				= "Cal_Phase_Offsets_NG_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_NG_V01.txt"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for the internal cal (NG) configuration"
/>

<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)		.AND.
						(Antenna_Ch1 .EQ. 1)		.AND.
						(Antenna_Ch2 .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Y_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)		.AND.
						(Antenna_Ch1 .EQ. 1)		.AND.
						(Antenna_Ch2 .EQ. 2)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_ZY_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)		.AND.
						(Antenna_Ch1 .EQ. 1)		.AND.
						(Antenna_Ch2 .EQ. 3)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_Y_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)		.AND.
						(Antenna_Ch1 .EQ. 2)		.AND.
						(Antenna_Ch2 .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_XY_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 0)		.AND.
						(Antenna_Ch1 .EQ. 3)		.AND.
						(Antenna_Ch2 .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>

<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_XY_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum2_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_ZY_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 2"
/>

<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Y_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>
<item
	name				= "Spectrum2_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_Y_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 2"
/>
<item
	name				= "Spectrum3_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_X_Z_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 0)		.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 3"
/>

<item
	name				= "Spectrum1_Cal_Phase_File"
	dataType			= "char"
	string				= "../calibration/HFR_cal_phase_NG_V01.txt"
	validity			= "	(CAL_Mode  .EQ. 1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "Name of the cross phase offset calibration file for Spectrum 1"
/>

<item
	name				= "Rx_Cal_Phase_Offsets_Ex_Ey_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_Ex_Ey_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the +Ex and -Ey antenna configuration (radians)"
/>
<item
	name				= "Rx_Cal_Phase_Offsets_Ex_Ez_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_Ex_Ez_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the +Ex and +Ez antenna configuration (radians)"
/>
<item
	name				= "Rx_Cal_Phase_Offsets_Ey_Ez_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_Ey_Ez_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the -Ey and +Ez antenna configuration (radians)"
/>
<item
	name				= "Rx_Cal_Phase_Offsets_Ex_EzEy_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_Ex_EzEy_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the +Ex and +Ez-Ey antenna configuration (radians)"
/>
<item
	name				= "Rx_Cal_Phase_Offsets_ExEy_Ez_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_ExEy_Ez_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the +Ex-Ey and +Ez antenna configuration (radians)"
/>
<item
	name				= "Rx_Cal_Phase_Offsets_NG_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Cal_Phase_Offsets_NG_File,6,0,1,319,1,1)"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array for the internal cal (NG) configuration (radians)"
/>

<item
	name				= "Rx_Spectrum1_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Spectrum1_Cal_Phase_File,6,0,1,319,1,1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array - offsets used to correct cross products (radians)"
/>
<item
	name				= "Rx_Spectrum2_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Spectrum2_Cal_Phase_File,6,0,1,319,1,1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array - offsets used to correct cross products (radians)"
/>
<item
	name				= "Rx_Spectrum3_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "ASCII_File2R4(Spectrum3_Cal_Phase_File,6,0,1,319,1,1)"
	hidden				= "true"
	family				= "Calibrations"
	dateCreated			= "15.1.2008"
	description			= "The receiver phase offset calibration 319 element array - offsets used to correct cross products (radians)"
/>

<item
	name				= "Spectrum1_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Spectrum1_Cal_Phase_Offsets_Radians)"
	family				= "Calibrations"
	dateCreated			= "25.1.2008"
	description			= "The phase offset calibration array for the first spectrum (radians)"
/>
<item
	name				= "Spectrum2_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Spectrum2_Cal_Phase_Offsets_Radians)"
	family				= "Calibrations"
	dateCreated			= "25.1.2008"
	description			= "The phase offset calibration array for the second spectrum (radians)"
/>
<item
	name				= "Spectrum3_Cal_Phase_Offsets_Radians"
	dataType			= "Float"
	fixed_value			= "Map_Indirect_V1(Spectrum_Channel_Numbers, Rx_Spectrum3_Cal_Phase_Offsets_Radians)"
	family				= "Calibrations"
	dateCreated			= "25.1.2008"
	description			= "The phase offset calibration array for the third spectrum (radians)"
/>

<!-- Spectrum sizes and such -->

<item
	name				= "Rx_Spectrum_Size"
	dataType			= "Integer"
	fixed_value			= "319"
	family				= "HFR info"
	dateCreated			= "1.2.2008"
	description			= "Number of channels or frequencies in the receiver spectrum (319.)"
/>

<item
	name				= "Spectrum_Size"
	dataType			= "Integer"
	fixed_value			= "Number_of_Steps"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "Number of elements in a spectrum/sweep
						All spectra (in DF modes) have the same size.
						Same as Number_of_Steps."
/>

<item
	name				= "Spectrum_AGCs_Size"
	dataType			= "Integer"
	fixed_value			= "Number_of_Steps"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "Number of AGC values in a spectrum/sweep.
						Same as Number_of_Steps."
/>

<item
	name				= "Spectrum_Auto_Size"
	dataType			= "Integer"
	fixed_value			= "Number_of_Steps * Auto_Mode"
	family				= "Auto Spectra"
	dateCreated			= "9.9.2004"
	description			= "Number of auto correlation or power elements in a spectrum/sweep"
/>

<item
	name				= "Spectrum_Cross_Size"
	dataType			= "Integer"
	fixed_value			= "Number_of_Steps * Cross_Mode"
	family				= "Cross Spectra"
	dateCreated			= "9.9.2004"
	description			= "Number of cross correlation elements in a spectrum/sweep"
/>

<item
	name				= "Spectrum_Count"
	dataType			= "Integer"
	fixed_value			= "(DF_Mode + 1)"
	family				= "Spectral info"
	dateCreated			= "23.8.2006"
	description			= "The number of spectra/sweeps in this event (1, 2 or 3 depending on direction finding mode)"
/>

<item
	name				= "Spectrum1_Exists"
	dataType			= "Integer"
	fixed_value			= "1"
	family				= "Spectral info"
	dateCreated			= "1.2.2008"
	description			= "Indicates that the first spectrum of the event exists (always 1/True)" >
	<xlate value="0" string="False" />
	<xlate value="1" string="True"  />
</item>

<item
	name				= "Spectrum2_Exists"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "DF_Mode .EQ. 0"
	family				= "Spectral info"
	dateCreated			= "1.2.2008"
	description			= "Indicates that the second spectrum of the event exists (if 1/True)" >
	<xlate value="0" string="False" />
	<xlate value="1" string="True"  />
</item>
<item
	name				= "Spectrum2_Exists"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "DF_Mode .NE. 0"
	family				= "Spectral info"
	dateCreated			= "1.2.2008"
	description			= "Indicates that the second spectrum of the event exists (if 1/True)" >
	<xlate value="0" string="False" />
	<xlate value="1" string="True"  />
</item>

<item
	name				= "Spectrum3_Exists"
	dataType			= "Integer"
	fixed_value			= "0"
	validity			= "DF_Mode .NE. 2"
	family				= "Spectral info"
	dateCreated			= "1.2.2008"
	description			= "Indicates that the third spectrum of the event exists (if 1/True)" >
	<xlate value="0" string="False" />
	<xlate value="1" string="True"  />
</item>
<item
	name				= "Spectrum3_Exists"
	dataType			= "Integer"
	fixed_value			= "1"
	validity			= "DF_Mode .EQ. 2"
	family				= "Spectral info"
	dateCreated			= "1.2.2008"
	description			= "Indicates that the third spectrum of the event exists (if 1/True)" >
	<xlate value="0" string="False" />
	<xlate value="1" string="True"  />
</item>

<item
	name				= "Spectrum_AGCs_Count"
	dataType			= "Integer"
	fixed_value			= "(DF_Mode + 1)"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "Number of spectra/sweeps in this event (1, 2 or 3).
						Same as Spectrum_Count."
/>

<item
	name				= "Spectrum_Auto_Count"
	dataType			= "Integer"
	fixed_value			= "Auto_Mode * (DF_Mode + 1)"
	family				= "Auto Spectra"
	dateCreated			= "9.9.2004"
	description			= "Number of auto spectra/sweeps in this event (0, 1, 2 or 3)"
/>

<item
	name				= "Spectrum_Cross_Count"
	dataType			= "Integer"
	fixed_value			= "Cross_Mode * (DF_Mode + 1)"
	family				= "Cross Spectra"
	dateCreated			= "9.9.2004"
	description			= "Number of cross spectra/sweeps in this event (0, 1, 2 or 3)"
/>


<item
	name				= "HFR_Gap"
	dataType			= "Integer"
	fixed_value			= "8 * 2 * (DF_Mode + 1)"
	hidden				= "true"
	dateCreated			= "5.12.2005"
	description			= "Gap between one frequency and the next"
/>

<!-- AGC ITEMS FOR HFR -->

<item
	name				= "AGC_Offset"
	dataType			= "Integer"
	fixed_value			= "Setup_Offset + 64 + 8"
	hidden				= "true"
	dateCreated			= "9.9.2004"
	description			= "Offset to AGC data"
/>

<item
	name				= "Spectrum1_AGCs_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Always exists.
						Not for general use."
/>
<item
	name				= "Spectrum1_AGCs_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum1_AGCs_Ch1)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Always exists.
						Not for everyday use."
/>

<item
	name				= "Spectrum2_AGCs_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset + 8 * 4"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(DF_Mode .NE. 0)"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_AGCs_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum2_AGCs_Ch1)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Exists only with direction finding enabled.
						Not for everyday use."
/>

<item
	name				= "Spectrum3_AGCs_Ch1"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset + 8 * 8"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(DF_Mode .EQ. 2)"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_AGCs_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum3_AGCs_Ch1)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Exists only with direction finding mode 2 enabled.
						Not for everyday use."
/>

<item
	name				= "Spectrum1_AGCs_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset + 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Always exists.
						Not for general use."
/>
<item
	name				= "Spectrum1_AGCs_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum1_AGCs_Ch2)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Always exists.
						Not for everyday use."
/>

<item
	name				= "Spectrum2_AGCs_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset + 16 + 8 * 4"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(DF_Mode .NE. 0)"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_AGCs_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum2_AGCs_Ch2)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Exists only with direction finding enabled.
						Not for everyday use."
/>

<item
	name				= "Spectrum3_AGCs_Ch2"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "AGC_Offset + 16 + 8 * 8"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(DF_Mode .EQ. 2)"
	family				= "AGCs"
	dateCreated			= "9.9.2004"
	description			= "AGC values for the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns integer automatic gain control values (TM units).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_AGCs_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_AGC_2dBs_V1(Spectrum3_AGCs_Ch2)"
	family				= "AGCs"
	dateCreated			= "29.8.2006"
	description			= "AGC values for the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns floating point automatic gain control values (dBs).
						Exists only with direction finding mode 2 enabled.
						Not for everyday use."
/>

<!-- DATA ITEMS FOR AUTO -	 -->

<item
	name				= "Auto_Offset"
	dataType			= "Integer"
	fixed_value			= "AGC_Offset + ( Number_of_Steps * ( DF_Mode + 1 ) * 2 * 16)"
	hidden				= "true"
	dateCreated			= "9.9.2004"
	description			= "Offset to HFR AUTO data"
/>

<item
	name				= "Spectrum1_Auto_Ch1_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch1_Raw_Mantissa"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset"
	lengthInBits			= "7"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 7"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns mantissa values for raw DSP floating point data.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch1_Raw_Exponent"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 7"
	lengthInBits			= "5"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 5"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns exponent values for raw DSP floating point data.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch1_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum1_Auto_Ch1_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum1_Auto_Ch1_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						No AGC information is included.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for everyday use."
/>
<item
	name				= "Spectrum1_Power_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum1_Auto_Ch1_Raw,Spectrum1_AGCs_Ch1)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Power_Ch1_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum1_AGCs_Ch1,
								Cal_A1_Ch1,
								Cal_A2_Ch1,
								Cal_A3_Ch1,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the first Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum2_Auto_Ch1_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 2 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)	.AND.
						(DF_Mode .NE. 0)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Auto_Ch1_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum2_Auto_Ch1_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Auto_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum2_Auto_Ch1_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						No AGC information is included.
						Exists only with direction finding enabled.
						Not for everyday use."
/>
<item
	name				= "Spectrum2_Power_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum2_Auto_Ch1_Raw,Spectrum2_AGCs_Ch1)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with direction finding enabled."
/>

<item
	name				= "Spectrum2_Power_Ch1_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum2_AGCs_Ch1,
								Cal_A1_Ch1,
								Cal_A2_Ch1,
								Cal_A3_Ch1,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the second Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum3_Auto_Ch1_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 4 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)	.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Auto_Ch1_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum3_Auto_Ch1_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Auto_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum3_Auto_Ch1_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						No AGC information is included.
						Exists only with direction finding mode 2 enabled.
						Not for everyday use."
/>
<item
	name				= "Spectrum3_Power_Ch1_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum3_Auto_Ch1_Raw,Spectrum3_AGCs_Ch1)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum3_Power_Ch1_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum3_AGCs_Ch1,
								Cal_A1_Ch1,
								Cal_A2_Ch1,
								Cal_A3_Ch1,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the third Channel 1 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Auto_Ch2_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch2_Raw_Mantissa"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 16"
	lengthInBits			= "7"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 7"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns mantissa values for raw DSP floating point data.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch2_Raw_Exponent"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 16 + 7"
	lengthInBits			= "5"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 5"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns exponent values for raw DSP floating point data.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch2_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum1_Auto_Ch2_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Auto_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum1_Auto_Ch2_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						No AGC information is included.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for everyday use."
/>
<item
	name				= "Spectrum1_Power_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum1_Auto_Ch2_Raw,Spectrum1_AGCs_Ch2)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with auto correlation mode enabled.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Power_Ch2_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum1_AGCs_Ch2,
								Cal_A1_Ch2,
								Cal_A2_Ch2,
								Cal_A3_Ch2,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the first Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum2_Auto_Ch2_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 3 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)	.AND.
						(DF_Mode .NE. 0)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Auto_Ch2_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum2_Auto_Ch2_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Auto_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum2_Auto_Ch2_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						No AGC information is included.
						Exists only with direction finding enabled.
						Not for everyday use."
/>
<item
	name				= "Spectrum2_Power_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum2_Auto_Ch2_Raw,Spectrum2_AGCs_Ch2)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with direction finding enabled."
/>

<item
	name				= "Spectrum2_Power_Ch2_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum2_AGCs_Ch2,
								Cal_A1_Ch2,
								Cal_A2_Ch2,
								Cal_A3_Ch2,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the second Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum3_Auto_Ch2_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Auto_Offset + 5 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Auto_Mode .EQ. 1)	.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "10.9.2004"
	description			= "Auto correlation data from the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Auto_Ch2_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Auto_V1(Spectrum3_Auto_Ch2_Raw)"
	hidden				= "true"
	family				= "Auto Spectra"
	dateCreated			= "1.11.2004"
	description			= "Auto correlation data from the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns full-sized integers (unpacked from raw floating point).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Auto_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Auto_2dBs_V1(Spectrum3_Auto_Ch2_Raw)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto spectra values in dBs.
						Exists only with direction finding mode 2 enabled.
						No AGC information is included.
						Not for everyday use."
/>
<item
	name				= "Spectrum3_Power_Ch2_dBs"
	dataType			= "float"
	fixed_value			= "SWHFR_UnFloat_Auto_2dBs_V1(Spectrum3_Auto_Ch2_Raw,Spectrum3_AGCs_Ch2)"
	family				= "Auto Spectra"
	dateCreated			= "1.8.2006"
	description			= "Auto correlation data from the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_Auto_Size.
						Returns auto power spectra values in dBs.
						AGC values are folded in.
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum3_Power_Ch2_dBs_V2perHz"
	dataType			= "float"
	fixed_value			= "SWHFR_Cal_dBs_V2(	Spectrum3_AGCs_Ch2,
								Cal_A1_Ch2,
								Cal_A2_Ch2,
								Cal_A3_Ch2,
								Cal_dBcal
								)"
	family				= "Auto Spectra"
	dateCreated			= "5.5.2007"
	description			= "Auto correlation data from the third Channel 2 spectrum/sweep of the event.
						Return is an array of length Spectrum_AGCs_Size.
						Returns calibrated power spectra values at preamp input in dBs (Volts^2/Hz).
						Results range from about -180dB to -100dB.
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<!-- Cross ITEMS -->

<item
	name				= "Cross_Offset"
	dataType			= "Integer"
	fixed_value			= "Auto_Offset + Auto_Mode * (Number_of_Steps * ( DF_Mode + 1 ) * 2 * 16)"
	hidden				= "true"
	dateCreated			= "10.9.2004"
	description			= "Offset to cross spectra"
/>

<item
	name				= "Spectrum1_Cross_Real_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Raw_Mantissa"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset"
	lengthInBits			= "6"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 6"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns mantissa values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Raw_Exponent"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 6"
	lengthInBits			= "5"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 5"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns exponent values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Raw_Sign"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset - 8 + 3"
	lengthInBits			= "1"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 1"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns sign values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum1_Cross_Real_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum1_Cross_Real_Raw,
										Spectrum1_Auto_Ch1_Raw,
										Spectrum1_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with auto and cross correlation modes enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Real_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Real_V1(		Spectrum1_Cross_Phases_Radians,
										Spectrum1_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Real part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with auto and cross correlation modes enabled.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum2_Cross_Real_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 2 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)	.AND.
						(DF_Mode .NE. 0)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Real part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Real_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum2_Cross_Real_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Real part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Real_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum2_Cross_Real_Raw,
										Spectrum2_Auto_Ch1_Raw,
										Spectrum2_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Real part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Real_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Real_V1(		Spectrum2_Cross_Phases_Radians,
										Spectrum2_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Real part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum3_Cross_Real_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 4 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	hidden				= "true"
	validity			= "	(Cross_Mode .EQ. 1)	.AND.
						(DF_Mode .EQ. 2)"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Real part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Real_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum3_Cross_Real_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Real part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Real_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum3_Cross_Real_Raw,
										Spectrum3_Auto_Ch1_Raw,
										Spectrum3_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Real part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Real_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Real_V1(		Spectrum3_Cross_Phases_Radians,
										Spectrum3_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Real part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Cross_Imag_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Raw_Mantissa"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 16"
	lengthInBits			= "6"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 6"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns mantissa values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Raw_Exponent"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 16 + 6"
	lengthInBits			= "5"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 5"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns exponent values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Raw_Sign"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset +16 - 8 + 3"
	lengthInBits			= "1"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 1"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.8.2006"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns sign values for raw DSP floating point data.
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum1_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with cross correlation mode enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum1_Cross_Imag_Raw,
										Spectrum1_Auto_Ch1_Raw,
										Spectrum1_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with auto and cross correlation modes enabled.
						Exists without respect to direction finding mode.
						Not for general use."
/>
<item
	name				= "Spectrum1_Cross_Imag_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Imag_V1(		Spectrum1_Cross_Phases_Radians,
										Spectrum1_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Imaginary part of the cross correlation data from the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with auto and cross correlation modes enabled.
						Exists without respect to direction finding mode.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum2_Cross_Imag_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 3 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)	.AND.
						(DF_Mode .NE. 0)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Imaginary part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Imag_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum2_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Imaginary part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Imag_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum2_Cross_Imag_Raw,
										Spectrum2_Auto_Ch1_Raw,
										Spectrum2_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Imaginary part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding enabled.
						Not for general use."
/>
<item
	name				= "Spectrum2_Cross_Imag_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Imag_V1(		Spectrum2_Cross_Phases_Radians,
										Spectrum2_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Imaginary part of the cross correlation data from the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum3_Cross_Imag_Raw"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Cross_Offset + 5 * 16"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "2 * HFR_Gap - 12"
	repetitionsInSingleDataBlock	= "Number_of_Steps"
	validity			= "	(Cross_Mode .EQ. 1)	.AND.
						(DF_Mode .EQ. 2)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "10.9.2004"
	description			= "Imaginary part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns raw DSP internal floating point values (as I4).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Imag_Integer"
	dataType			= "Integer"
	fixed_value			= "SWDSP_UnFloat_Cross_V1(Spectrum3_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "1.11.2004"
	description			= "Imaginary part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns full-sized integers (unpacked from raw DSP floating point).
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Imag_Normal_Raw"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Normal_V1(	Spectrum3_Cross_Imag_Raw,
										Spectrum3_Auto_Ch1_Raw,
										Spectrum3_Auto_Ch2_Raw	)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Imaginary part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is not corrected for phase shift.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding mode 2 enabled.
						Not for general use."
/>
<item
	name				= "Spectrum3_Cross_Imag_Normal"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_Cross_Imag_V1(		Spectrum3_Cross_Phases_Radians,
										Spectrum3_Cross_Coherences	)"
	family				= "Cross Spectra"
	dateCreated			= "1.24.2008"
	description			= "Imaginary part of the cross correlation data from the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point values normalized by the auto correlation values.
						Return is corrected for phase shift calibration.
						Returned values vary between about -1 and about +1.
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Cross_Phases_Raw_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum1_Cross_Phases_Raw_Radians * Radians2Degrees"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in degrees [-180 to +180].
						Exists without respect to direction finding mode.
						Exists only with cross correlation mode enabled."
/>
<item
	name				= "Spectrum2_Cross_Phases_Raw_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum2_Cross_Phases_Raw_Radians * Radians2Degrees"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in degrees [-180 to +180].
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum3_Cross_Phases_Raw_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum3_Cross_Phases_Raw_Radians * Radians2Degrees"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in degrees [-180 to +180].
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum1_Cross_Phases_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum1_Cross_Phases_Radians * Radians2Degrees"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in degrees [-180 to +180].
						Exists without respect to direction finding mode.
						Exists only with cross correlation mode enabled.
						A very popular and useful item!"
/>
<item
	name				= "Spectrum2_Cross_Phases_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum2_Cross_Phases_Radians * Radians2Degrees"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in degrees [-180 to +180].
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>
<item
	name				= "Spectrum3_Cross_Phases_Degrees"
	dataType			= "float"
	fixed_value			= "Spectrum3_Cross_Phases_Radians * Radians2Degrees"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in degrees [-180 to +180].
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Cross_Phases_Raw_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2radians_V1(Spectrum1_Cross_Real_Raw,Spectrum1_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in radians [-pi to +pi].
						Exists without respect to direction finding mode.
						Exists only with cross correlation mode enabled."
/>
<item
	name				= "Spectrum2_Cross_Phases_Raw_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2radians_V1(Spectrum2_Cross_Real_Raw,Spectrum2_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in radians [-pi to +pi].
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum3_Cross_Phases_Raw_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2radians_V1(Spectrum3_Cross_Real_Raw,Spectrum3_Cross_Imag_Raw)"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns uncorrected cross angle values in radians [-pi to +pi].
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum1_Cross_Phases_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_phase_V1(	Spectrum1_Cross_Phases_Raw_Radians,
								Spectrum1_Cal_Phase_Offsets_Radians
								)"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in radians [-pi to +pi].
						Exists without respect to direction finding mode.
						Exists only with cross correlation mode enabled."
/>
<item
	name				= "Spectrum2_Cross_Phases_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_phase_V1(	Spectrum2_Cross_Phases_Raw_Radians,
								Spectrum2_Cal_Phase_Offsets_Radians
								)"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in radians [-pi to +pi].
						Exists only with direction finding enabled."
/>
<item
	name				= "Spectrum3_Cross_Phases_Radians"
	dataType			= "float"
	fixed_value			= "SWDSP_Cal_phase_V1(	Spectrum3_Cross_Phases_Raw_Radians,
								Spectrum3_Cal_Phase_Offsets_Radians
								)"
	family				= "Cross Spectra"
	dateCreated			= "14.1.2008"
	description			= "Cross spectra/sweep phase angles for the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns calibrated/corrected cross angle values in radians [-pi to +pi].
						Exists only with direction finding mode 2 enabled."
/>

<item
	name				= "Spectrum1_Cross_Coherences"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Magnitude_Normal_V1(	Spectrum1_Cross_Real_Raw,
											Spectrum1_Cross_Imag_Raw,
											Spectrum1_Auto_Ch1_Raw,
											Spectrum1_Auto_Ch2_Raw	)"
	family				= "Cross Spectra"
	dateCreated			= "24.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the first spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists without respect to direction finding mode.
						Exists only with auto and cross correlation modes enabled.
						A very popular and useful item!"
/>
<item
	name				= "Spectrum2_Cross_Coherences"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Magnitude_Normal_V1(	Spectrum2_Cross_Real_Raw,
											Spectrum2_Cross_Imag_Raw,
											Spectrum2_Auto_Ch1_Raw,
											Spectrum2_Auto_Ch2_Raw	)"
	family				= "Cross Spectra"
	dateCreated			= "24.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the second spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists only with direction finding enabled.
						A very popular and useful item!"
/>
<item
	name				= "Spectrum3_Cross_Coherences"
	dataType			= "float"
	fixed_value			= "SWDSP_UnFloat_Cross_2Magnitude_Normal_V1(	Spectrum3_Cross_Real_Raw,
											Spectrum3_Cross_Imag_Raw,
											Spectrum3_Auto_Ch1_Raw,
											Spectrum3_Auto_Ch2_Raw	)"
	family				= "Cross Spectra"
	dateCreated			= "24.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the third spectrum/sweep of the event.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists only with direction finding mode 2 enabled.
						A very popular and useful item!"
/>

<item
	name				= "Spectrum1_Cross_Magnitudes_Normal"
	dataType			= "float"
	fixed_value			= "Spectrum1_Cross_Coherence"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the first spectrum/sweep of the event.
						Same as the Spectrum1_Cross_Coherences item.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists without respect to direction finding mode.
						Exists only with auto and cross correlation modes enabled."
/>
<item
	name				= "Spectrum2_Cross_Magnitudes_Normal"
	dataType			= "float"
	fixed_value			= "Spectrum2_Cross_Coherence"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the second spectrum/sweep of the event.
						Same as the Spectrum2_Cross_Coherences item.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists only with direction finding enabled."
/>

<item
	name				= "Spectrum3_Cross_Magnitudes_Normal"
	dataType			= "float"
	fixed_value			= "Spectrum3_Cross_Coherence"
	hidden				= "true"
	family				= "Cross Spectra"
	dateCreated			= "22.5.2007"
	description			= "Cross spectra/sweep magnitudes/coherence for the third spectrum/sweep of the event.
						Same as the Spectrum3_Cross_Coherences item.
						Return is an array of length Spectrum_Cross_Size.
						Returns floating point cross correlation magnitudes normalized by the auto correlation values.
						Returned values vary between 0 and about 1.
						Exists only with direction finding mode 2 enabled."
/>

<!-- Almost the end of the chunk -->

<item
	name				= "Trailer_Offset"
	dataType			= "Integer"
	fixed_value			= "Cross_Offset + Cross_Mode * (DF_Mode + 1) * Number_of_Steps * 2 * 16"
	hidden				= "true"
	dateCreated			= "10.9.2004"
	description			= "Offset to trailer data"
/>

<item
	name				= "Trailer"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "Trailer_Offset"
	lengthInBits			= "12"
	bitsOffsetToNextElementInBlock	= "0"
	repetitionsInSingleDataBlock	= "1"
	bitsOffsetToNextDataBlock	= "0"
	totalNumberOfDataBlocks		= "1"
	dateCreated			= "23.7.2004"
	description			= "DSP trailer value (should be 0xA95, 2709.)"
/>
