<item
	name				= "Sequence_Number"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "0"
	lengthInBits			= "8"
	family				= "DSP Status"
	dateCreated			= "24.3.2005"
	description			= "Sequence number and CAL step indicator"
/>

<item
	name				= "Chunk_Size_MSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "2*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "MSB of chunk size counter"
/>

<item
	name				= "Chunk_Size_LSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "4*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "LSB of chunk size counter"
/>

<item
	name				= "Chunk_Size"
	dataType			= "integer"
	fixed_value			= "(Chunk_Size_MSB &lt;&lt; 8) +
							Chunk_Size_LSB"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "DSP chunk size"
/>

<item
	name				= "DSP_FirmWare_Major_Version"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "6*8"
	lengthInBits			= "8"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Major version of DSP firmware installed"
/>

<item
	name				= "DSP_FirmWare_Minor_Version"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "8*8"
	lengthInBits			= "8"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Minor version of DSP firmware installed"
/>

<item
	name				= "DSP_FirmWare_Version_MSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "10*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "MSB of installed firmware version build number"
/>

<item
	name				= "DSP_FirmWare_Version_LSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "12*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "LSB of installed firmware version build number"
/>

<item
	name				= "DSP_FirmWare_Version"
	dataType			= "integer"
	fixed_value			= "(DSP_FirmWare_Version_MSB &lt;&lt; 8) +
							DSP_FirmWare_Version_LSB"
	family				= "DSP Status"
	dateCreated			= "2.8.2004"
	description			= "Installed firmware version build number"
/>

<item
	name				= "DSP_FirmWare_Day"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "14*8"
	lengthInBits			= "8"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Calendar day of firmware build"
/>


<item
	name				= "DSP_FirmWare_Month"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "16*8"
	lengthInBits			= "8"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Calendar month of firmware build"
/>


<item
	name				= "DSP_FirmWare_Year_MSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "18*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "MSB of the firmware year of origin"
/>

<item
	name				= "DSP_FirmWare_Year_LSB"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "20*8"
	lengthInBits			= "8"
	hidden				= "true"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "LSB of the firmware year of origin"
/>

<item
	name				= "DSP_FirmWare_Year"
	dataType			= "integer"
	fixed_value			= "(DSP_FirmWare_Year_MSB &lt;&lt; 8) +
							DSP_FirmWare_Year_LSB"
	family				= "DSP Status"
	description			= "Firmware year of origin"
	dateCreated			= "13.7.2004"
/>


<item
	name				= "DSP_Analysis_Command"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8"
	lengthInBits			= "12"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "DPU to DSP command word for this measurment"
/>

<item
	name				= "Repeat_Count"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 6"
	lengthInBits			= "6"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Measurement repeat count - should be 1 except during an internal cal"
/>

<item
	name				= "FFR_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 5"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "FFR state - should be off at all times" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "H2_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 4"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "HFR2 state" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "H1_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 3"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "HFR1 state" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Band_A_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 0"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Band A State" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Band_B_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 1"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Band B State" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>

<item
	name				= "Band_C_State"
	dataType			= "Integer"
	extractArea			= "AREA_EVENT_DATA_START"
	bitsOffsetFromStartOfArea	= "22*8 + 2"
	lengthInBits			= "1"
	family				= "DSP Status"
	dateCreated			= "13.7.2004"
	description			= "Band C State" >
	<xlate value="0" string="Off" />
	<xlate value="1" string="On" />
</item>
