#!/bin/bash

function fkill {
    kill -9 `ps auxww | grep -i $1 | grep -v 'grep' | awk '{print $2}'` > /dev/null 2>&1
}

Server_Home=
Server_Mode=
if [ "X$TMlib_GSE_Home" != "X" ]; then
    Server_Mode="realtime"
    Server_Home=$TMlib_GSE_Home
fi
if [ "X$TMlib_Server_Home" != "X" ]; then
    Server_Mode="playback"
    Server_Home=$TMlib_Server_Home
fi
if [ "X$Server_Home" = "X" ]; then
    echo "Server environment variable not set. Exiting..."
    exit 1
fi

WEB_ON_CMD="$Server_Home/../TMlib_WebApps/start.sh"
WEB_OFF_CMD="$Server_Home/../TMlib_WebApps/stop.sh"

ArgsForAllServers=" "
TurnOn="false"
TurnOff="false"
DoRecCmd="false"
HelpDisplay="true"
StatDisplay="false"

TConly="false"
TCCmd="on"
WebOnly="false"
WebCmd="on"

DAQonly="false"
DaqCmd="on"
AGENTonly="false"
AgentCmd="on"

DebugServerAgent="false"
DebugParams=
DebugFlag=
ProfileServerAgent="false"
ProfileParams=

Log="false"

DBSyntaxCheck="false"
FileSyntaxCheck="false"

PacketFlinger="false"

while [ $# -gt 0 ]; do 
    case "$1" in 
        -fl)
            PacketFlinger="true"
            HelpDisplay="false"
            ;;
        -db)
            DBSyntaxCheck="true"
            HelpDisplay="false"
            ;;
        -dbfile)
            FileSyntaxCheck="true"
            HelpDisplay="false"
            XMLfileSyntax=$2 
            shift 
            ;; 
        -stat)
            StatDisplay="true"
            HelpDisplay="false"
            ;;
        -sta)
            StatDisplay="true"
            HelpDisplay="false"
            ;;
        -st)
            StatDisplay="true"
            HelpDisplay="false"
            ;;
        -s)
            StatDisplay="true"
            HelpDisplay="false"
            ;;
        -on)
            TurnOn="true"
            HelpDisplay="false"
            ;;
        -off)
            TurnOff="true" 
            HelpDisplay="false" 
            ;;  
        -moc)
            MocCmd=$2 
            HelpDisplay="false"
            shift 
            ;; 
        -rec)
            DoRecCmd="true"
            HelpDisplay="false"
            RecCmd=$2 
            shift 
            ;; 
        -tc)
            TConly="true"
            HelpDisplay="false"
            if [ $# -gt 1 ]; then 
                TCCmd=$2 
                shift 
            fi
            ;; 
        -web)
            WebOnly="true"
            HelpDisplay="false"
            if [ $# -gt 1 ]; then 
                WebCmd=$2 
                shift 
            fi
            ;; 
        -agent)
            AGENTonly="true"
            HelpDisplay="false"
            if [ $# -gt 1 ]; then 
                AgentCmd=$2 
                shift 
            fi
            ;;
        -daq)
            DAQonly="true"
            HelpDisplay="false"
            if [ $# -gt 1 ]; then 
                DaqCmd=$2 
                shift 
            fi
            ;;
        -debug)
            DebugParams="-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005"
            DebugFlag="debug"
            HelpDisplay="false"
            ;;
        -profile)
            export DYLD_LIBRARY_PATH="/Applications/jprofiler5/bin/macos"
            HelpDisplay="false"
            ProfileParams="-Xint -agentlib:jprofilerti=port=8849  -Xbootclasspath/a:/Applications/jprofiler5/bin/agent.jar"
            ;;
        -help)
            HelpDisplay="true" 
            ;; 
        -h)
            HelpDisplay="true"
            ;;      
        -log) 
            Log="true"
            HelpDisplay="false"
            if [ $# -gt 1 ]; then 
                LogValue=$2 
                shift 
            fi
            ;; 
        *)
            ;;
    esac
    shift
done 

if [ -z "$MocCmd" -a $Server_Mode = "realtime" ]; then 
    MocCmd="default_moc_taken_from_config_files"
fi

if [ $Log = "true" ]; then
    cd $Server_Home/build/lib/java
    java -jar ConfigureLogger.jar $LogValue
fi

if [ $PacketFlinger = "true" -a $Server_Mode = "realtime" ]; then
    fkill PacketFlinger
    cd $Server_Home/build/lib/java  
    nice -n 8 java -jar PacketFlinger.jar   & 
    sleep 1
fi

if [ $DBSyntaxCheck = "true" ]; then
    $Server_Home/bin/TMlib_DB_Verifier.pl
fi

if [ $FileSyntaxCheck = "true" ]; then
    $Server_Home/bin/TMlib_DB_Verifier.pl -f $XMLfileSyntax
fi

if [ $TConly = "true" -a $Server_Mode = "realtime" ]; then
    if [ $TCCmd = "on" ]; then
        fkill TC_Handler
        cd $Server_Home/build/lib/java  
        nice -n 8 java -jar TC_Handler.jar  -moc  $MocCmd  & 
    elif [ $TCCmd = "off" ]; then
        fkill TC_Handler
    else 
        echo  "$TCCmd not a valid option for -tc"
        echo  "Use on or off" 
        exit
    fi   
    sleep 1
fi

if [ $WebOnly = "true" ]; then
    if [ $WebCmd = "on" ]; then
        if [ -e $WEB_ON_CMD ]; then
            $WEB_ON_CMD 
        else
            echo "******************************"
            echo "Startup for web apps not found"
            echo "******************************"
         fi
    elif [ $WebCmd = "off" ]; then
        $WEB_OFF_CMD
    else 
        echo  "$WebCmd not a valid option for -web"
        echo  "Use on or off" 
        exit
    fi   
    sleep 1
fi

if [ $DAQonly = "true" -a $Server_Mode = "realtime" ]; then
    if [ $DaqCmd = "on" ]; then
        fkill TmDaq
        cd $Server_Home/build/lib/java
        nice -n 15  java -jar TmDaq.jar -moc $MocCmd &
    elif [ $DaqCmd = "off" ]; then
        fkill TmDaq
    else 
        echo  "$DaqCmd not a valid option for -daq"
        echo  "Use on or off" 
        exit
    fi   
    sleep 1
fi

if [ $AGENTonly = "true" ]; then
    if [ $AgentCmd = "on" ]; then
        fkill ServerAgent
        cd $Server_Home/build/lib/java
        nice -n 15 java -jar ServerAgent.jar  &
    elif [ $AgentCmd = "off" ]; then
        fkill ServerAgent
    else 
        echo  "$AgentCmd not a valid option for -daq"
        echo  "Use on or off" 
        exit
    fi   
    sleep 1
fi

if [ $HelpDisplay = "true" ]; then
    echo "-on               Launch server agents"
    echo "-off              Kill server agents"
    if [ $Server_Mode = "realtime" ]; then
        echo ""
        echo "-tc [on|off]      Turns the TC_Handler on or off"
        echo ""
        echo "-daq [on|off]     Turns the TmDaq on or off"
        echo ""
        echo "-rec [on|off]     Open file and record realtime stream"
        echo ""
        echo "-moc mocname      Use a moc other than the default (used with -on)"
        echo "-moc help         Display name and description of available mocs"
        echo " "
        echo "-fl               Run the PacketFlinger MOC emulation program"
    fi
    echo ""
    echo "-db               Recursively searches the entire xml database and checks"
    echo "                      for xml syntax errors"
    echo "-dbfile file      Displays specific syntax errors in a given xml file."
    echo ""
    echo "-web [on|off]     Turns on or off the TMlib web services"
    echo ""
    echo "-stat             Displays pids and cpu usage of gse servers and client processes"
    echo "-help             Display help"
    echo ""
    echo "-log              Gives the logging level for future TMlib Sessions"
    echo "-log [less|more]  Lowers/Raises the log level for the next client"
    exit
fi

if [ $StatDisplay = "true" ]; then
    cd $Server_Home/bin/
    $Server_Home/bin/TMlibStat.pl -${Server_Mode}
    exit
fi   

if [ $Server_Mode = "realtime" ]; then
    if [ $MocCmd = "help" -o $MocCmd = "verbose" ]; then
        $java -jar TmDaq.jar -moc  $MocCmd
        exit
    fi
fi

if [ $TurnOn = "true" ]; then
    echo "Launching Server Agents..."
    
    fkill TmDaq 
    fkill ServerAgent
    fkill TC_Handler
    fkill CentralLogger
    
    cd $Server_Home/build/lib/java
    nice -n 15 java -jar CentralLogger.jar -moc $MocCmd &
    sleep 10
    if [ $Server_Mode = "realtime" ]; then
        nice -n 12 java -jar TC_Handler.jar -moc $MocCmd &
    fi
    nice -n 15 java ${ProfileParams} ${DebugParams} -jar ServerAgent.jar ${DebugFlag} &
    if [ $Server_Mode = "realtime" ]; then
        nice -n 15 java -jar TmDaq.jar -moc $MocCmd &
    fi

    if [ -e $WEB_ON_CMD ]; then
        $WEB_ON_CMD 
    else
        echo "******************************"
        echo "Startup for web apps not found"
        echo "******************************"
    fi
    sleep 4
    exit
fi   

if [ $TurnOff = "true" ]; then
    echo -n "Do you want to turn off the client agents? [y/N]: "
    read REPLY
    ymatch=`echo "$REPLY" | egrep -i '^y(es)?$' | wc -l`
    if [ $ymatch == "1" ]; then
        echo "Shutting down the client agents"
        fkill tcpPidSess
    fi
    echo -n "Do you want to turn off the server agents? [y/N]: "
    read REPLY
    ymatch=`echo "$REPLY" | egrep -i '^y(es)?$' | wc -l`
    if [ $ymatch == "1" ]; then
        echo "Shutting down the server agents."
        fkill TmDaq 
        fkill ServerAgent
        fkill TMlibRecord
        fkill TC_Handler
        fkill CentralLogger
        fkill PacketFlinger
        if [ -e $WEB_OFF_CMD ]; then
            $WEB_OFF_CMD 
        fi
    fi 
    exit
fi   

if [ $DoRecCmd = "true" ]; then
    if [ -f  $Server_Home/config/CurrentMocProperties.xml ]; then
        MocCmd=`strings $Server_Home/config/CurrentMocProperties.xml | grep NAME | perl -p -i -e 's/.*"(.*)".*/\1/g'`
    fi
    recpid=`ps auxww | grep "[T]MlibRecord" | awk '{print $2}'`

    if [ $RecCmd = "on" ]; then
        if [ "X$recpid" != "X" ]; then
            echo "Packet recording is currently active."
        else
            cd $Server_Home/build/lib/java  
            java -jar TMlibRecord.jar -moc $MocCmd &
        fi
        exit
    elif [ $RecCmd = "off" ]; then
        if [ "X$recpid" != "X" ]; then
            kill -HUP $recpid
        else
            echo "Packet recording is not currently active."
        fi
        exit;
    fi
fi
