#!/usr/bin/perl 
#
# Title: TM_Lib_DB_Verifier
# Purpose: Will check the xml files in the TMLib for 
#    well formedness, using xmllint.
#
#  The default behavior is the check the all the files in the DB 
#   and produce a report with the name of the file and the number of 
#  errors.
#  If the user enters 
#  TM_Lib_DB_Verifier  -f SingleFileName
#
# Then xmllint will be run on that file and the result will be displayed.
#
#********************************************************

use File::Find;


$SERVER_HOME = $ENV{'TMlib_Server_Home'};
if (length($SERVER_HOME) == 0){
    $SERVER_HOME = $ENV{'TMlib_GSE_Home'};
}
if (length($SERVER_HOME) == 0){
   print "Neither env variable is set: \n" ;
   print "TMlib_Server_Home \n" ;
   print "TMlib_GSE_Home \n" ;
   exit();
}


print "Home " . $SERVER_HOME . "\n";

$DB_TOP_DIR = $SERVER_HOME . "/config/MissionConfigFiles/";
#
# files containg this pattern will be excluded from the 
# the list of files to be checked.
$EXCLUDE = "(GGS|DS_Store|svn)";

if ($#ARGV == -1 ) {  
   CheckEntireDB() ; # no arguments
} 
else {
   $SingleFile = $ARGV[1]; # used if the user opts to examine only one file.
   CheckSingleFile($SingleFile) ;
}




sub CheckEntireDB() {
#
# Find the longest filename so that we can have pretty output.
$MAX_FILENAME_LENGTH = 0;
find sub {
       next unless -f;
       $fileToCheck = $File::Find::name;
       next if ($fileToCheck =~ /$EXCLUDE/);
       next if !($fileToCheck =~ /^(.*)\.xml/);
       $fileToCheck =~ s/\s+/\\ / ;

       $fileToCheck =~ s/$DB_TOP_DIR//;
       $LEN = length $fileToCheck;
       if ($LEN > $MAX_FILENAME_LENGTH) {
            $MAX_FILENAME_LENGTH = $LEN;
        }
}, "$DB_TOP_DIR"; # find recursively finds all the file in this dir

$BLANK = " " x ($MAX_FILENAME_LENGTH + 3); 

$HEADER = "Database file";
$PRINT_HEADER = $BLANK;
$LEN = length $HEADER;
substr ($PRINT_HEADER,0,$LEN,$HEADER);
print "$PRINT_HEADER" . "Errors\n";
#
# Run xmllint on all the files and print the number of errors.
find sub {
       next unless -f;
       $fileToCheck = $File::Find::name;
       next if ($fileToCheck =~ /$EXCLUDE/);
       next if !($fileToCheck =~ /^(.*)\.xml/);
       $fileToCheck =~ s/\s+/\\ / ;
       $numfails = `xmllint $fileToCheck --noout 2>&1 | wc -l`;
       $numfails = $numfails *1; # get rid of a \n hanging on the end of $numfails
       $OutputMessage = "OK";
       if ($numfails != 0) {
         $OutputMessage = "SYNTAX ERROR";
       }
       $fileToCheck =~ s/$DB_TOP_DIR//;
       $PRINT_FILE = $BLANK;
       $LEN = length $fileToCheck;
       substr ($PRINT_FILE,0,$LEN,$fileToCheck);
       print "$PRINT_FILE" . "$OutputMessage \n";
     }, "$DB_TOP_DIR";  # find recursively finds all the file in thei dir
}


sub CheckSingleFile() {
#
# Find the longest filename so that we can have a pretty output.
$NameOfSingleFile = $_[0] ;
#
# Run xmllint on all the files and print the number of errors.
find sub {
       next unless -f;
       $fileToCheck = $File::Find::name;
       next if ($fileToCheck =~ /$EXCLUDE/);
       next unless ($fileToCheck =~ /$NameOfSingleFile/);
       next if !($fileToCheck =~ /^(.*)\.xml/);
       $fileToCheck =~ s/\s+/\\ / ;
       `xmllint --noout $fileToCheck `;
       $numfails = `xmllint $fileToCheck --noout 2>&1 | wc -l`;
       $fileToCheck =~ s/$DB_TOP_DIR//;
       print "$fileToCheck" . "$numfails";
   }, "$DB_TOP_DIR";  # find recursively finds all the file in thei dir
}