#!/usr/bin/perl

use POSIX qw(ceil floor);
use Time::Local;
use Sys::Hostname;

my $numClients = 0;
my $ServerUpTime = 0;
my $totNumberOfClients = 0;
my $numArgs = $#ARGV + 1;
my $gse_flag = 0; $gse_flag = 1 if ($ARGV[0] =~ /-realtime/ ); 
my $updateTime = 1;
my $clear = `clear`;
my $hostname = hostname();
my $ip = `ipconfig getifaddr en0`; chomp($ip);
my $ServerHeader = sprintf "\n\e[1m%-20s%5s%7s\e[0m\n", "Server", "PID", "%CPU";
my $svrformat = "%-20s%5s%7s\n"; 
my $ClientHeader = sprintf "\e[1m%-6s%-14s%5s%7s%12s  %-s\e[0m\n", "  #",
    "Process", "PID", "%CPU", "Time", "Remote Address";
my $clntformat = "%-14s%5s%7s%12s  %-s\n";
my $cache_counter = 6;
my $cached_meta = "";
my $cached_serv = "";

while(1) {
    my $ServerStatus =
        ($gse_flag ? "GSEserver" : "TMserver")." hosted at $hostname ($ip)\n";
    my $AgentStatus = server_ps("ServerAgent.jar", "TMServerAgent", $svrformat);
    $totNumberOfClients = 0  if ($AgentStatus =~ /\-\s+\-/); 

    if ($cache_counter % 6 == 0) {
        $cached_meta = "";
        if ($gse_flag) {
            $cached_meta .= "MOC: ".moc_description("TmDaq.jar");
        }
        $cached_meta .= "Server Version: ".ConfigFileParameter("ServerVersion");
        $cached_meta .= "Logging level: ".ConfigFileParameter("TM_log_level");
    }
    $ServerStatus .= $cached_meta;

    $ServerStatus .= localtime();
    my $Server_Uptime = get_uptime("ServerAgent.jar");
    $Server_Uptime =~ s/\s*(.*)\s*/$1/;
    $ServerStatus .= ", Server Uptime: $Server_Uptime";

    $ServerStatus .= "\n$ServerHeader";

    if ($cache_counter % 2 == 0) {
        $cached_serv = "";
        if ($gse_flag) {
            $cached_serv .= server_ps("TmDaq.jar", "TmDaq", $svrformat);
            $cached_serv .= server_ps("TC_Handler.jar", "TC_Handler", $svrformat);
            $cached_serv .= server_ps("Record.jar", "Recorder", $svrformat);
        }
        $cached_serv .= $AgentStatus;
        $cached_serv .= server_ps("CentralLogger.jar", "CentralLogger", $svrformat);
        $cached_serv .= server_ps("tmwebserver", "WebApps", $svrformat);
    }
    $ServerStatus .= $cached_serv;

    $ClientStatus = client_ps($clntformat, $numClients, $totNumberOfClients);

    print $clear;
    print "$ServerStatus\nNumber of clients: $numClients current, ".
        "$totNumberOfClients total\n\n$ClientHeader$ClientStatus";
    sleep $updateTime;
    
    $cache_counter = 0 if ($cache_counter == 6);
    ++$cache_counter;
}

sub client_ps {
    my $Format = $_[0];     # format for the output
    my $num = $_[1];
    $totNumberOfClients = $_[2];
    my $ClientNum = 1;
    
    $numClients = 0;

    $totalPrint  = sprintf ("\e[1m%-6s%-14s%5s%7s%12s  %-s\e[0m\n","  -","-",
        "-","-","-","-");
    open CPS, "ps -axww -o pid,%cpu,command | grep \"[t]cpPidSess\" |";
    my @ClientList;
    while(<CPS>) {
        $numClients++;
        $ps_output_scalar = $_;
        $ps_output_scalar =~ s/^\s*(.*?)\s*$/$1/;
        @ps_output = split(/\s+/,$ps_output_scalar );
        $Agent_id =  $ps_output[6];
        $totNumberOfClients = $Agent_id if ($Agent_id > $totNumberOfClients);
        $Agent_length = length($Agent_id);
        while ($Agent_length < 4) {
            $Agent_id = "0" . $Agent_id;
            $Agent_length = length($Agent_id); 
        }
        $OutName = "Client_" .  $Agent_id;
        $ClientPID = $ps_output[0];
        $pid_length = length(ClientPID);
        while ($pid_length < 5) {
            $ClientPID = " " . $ClientPID;
            $pid_length = length($ClientPID); 
        }  
        $cpu = $ps_output[1];
        $ClientHostName = $ps_output[7];

        $SearchForTimeStamp = "$ClientName.*$ps_output[5]";
        $uptime = get_uptime("$SearchForTimeStamp");

        $uptime =~ s/\s*(.*)\s*/$1/;
        $OneClient = sprintf ("%%-6s$Format", $OutName, $ClientPID, $cpu,
            $uptime, $ClientHostName);
        @ClientList = (@ClientList,$OneClient);
        $totalPrint  = "";
    }

    foreach (sort { $a cmp $b } @ClientList) {
        $totalPrint = $totalPrint . (sprintf($_, (sprintf("%03d", $ClientNum))));
        $ClientNum++;
        $ClientNum = 0 if $ClientNum == 999;
    }
    close CPS;
    return $totalPrint;
}

sub server_ps {
    $ServerName = $_[0]; # the actual process name as seen by PS
    $PrintName = $_[1]; # name that will be displayed by this program
    $Format = $_[2];    # format for the output

    $out = sprintf $Format, $PrintName, "-", "-";
    $ServerName =~ s/^(.)(.*)$/\[$1\]$2/i; # format for grep
    open SPS, "ps -axww -o pid,%cpu,command | grep $ServerName |";
    while(<SPS>){
        s/^\s*(.*?)\s*$/$1/;
        split /\s+/;
        $out = sprintf $Format, $PrintName, $_[0], $_[1];
    }
    close SPS;
    return $out;
}

sub get_uptime {
    $ServerName =$_[0];
    %months = ( Jan => 0, Feb => 1, Mar => 2, Apr => 3, May => 4, Jun => 5, 
        Jul => 6, Aug => 7, Sep => 8, Oct => 9, Nov => 10, Dec => 11); 

    open UPS, "ps -axww -o lstart,command | grep $ServerName | grep -v 'grep' |";
    $uptime = "0 00:00"; # server not turned on
    while(<UPS>){
        $ps_output_scalar = $_;
        @ps_output = split(/\s+/,$ps_output_scalar );
        $StrMon = @ps_output[1];
        $clock_time = @ps_output[3];
        # Separate hours minutes and seconds
        @parts_of_clock_time = split(/:/,$clock_time );

        $year  = @ps_output[4] ;
        $mon   = $months{$StrMon};
        $mday  = @ps_output[2];
        $hours = @parts_of_clock_time[0];
        $min   = @parts_of_clock_time[1];
        $sec   = @parts_of_clock_time[2];

        $Time_Server_Sarted = timelocal($sec, $min, $hours, $mday, $mon, $year);
        $CurrentTime = time();

        $Delta_T = $CurrentTime - $Time_Server_Sarted;
        $daysup = floor(( $Delta_T/(24. * 60. * 60.))); 
        $factDay = $Delta_T/(24. * 60. * 60.) - $daysup ;

        $hrs = floor($factDay *24);
        $fracthr = ($factDay *24) - $hrs;
        $min = sprintf "%02d", floor($fracthr *60);
        
        $daysup = "" if ($daysup == 0);

        $uptime = "$daysup ".(sprintf "%2s", $hrs).":$min";
    }
    close UPS;
    return $uptime;
}

sub ConfigFileParameter {
    my $ParameterName =$_[0];
    my $VersionNum = 0;
    open(inFile, "../config/Info.plist");
    while( $line = <inFile> ) {
        if ($line =~ /(.*)$ParameterName(.*)/) {
            $line = <inFile>;
            $line =~ s/(.*>)(\w+)(<.*)/\2/;
            $ParameterValue = $line;
            break;
        }
    }
    close inFile;
    return $ParameterValue;
}

sub moc_description {
    $ServerName = $_[0];
    $MOC_DESCRIPTION = "-\n";
    open MPS, "ps -axww -o pid,%cpu,command | grep $ServerName | grep -v 'grep' |";

    while(<MPS>) {
        open(inFile, "../config/CurrentMocProperties.xml");
        while( $line = <inFile> ) {
            if ($line =~ /^(.*)DESCRIPTION(.*)\n$/) {
                $line =~ s/.*\"(.*)\".*/\1/;
                $MOC_DESCRIPTION=$line;
                break;
            }
        }
        close inFile;
    }
    close MPS;
    return $MOC_DESCRIPTION;
}