/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class SearchXMl_TreeBasedOnAttrValues {
    private String AttributeToRetrun;
    private String LowCaseNodeName;
    private String NodeType;
    private String LowCaseRequestedName;
    private XPath xPath;
    private Document document;
    private File ConfigFile;

    public SearchXMl_TreeBasedOnAttrValues(File inConfigFile) {
        try {
            this.ConfigFile = inConfigFile;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            this.document = builder.parse(this.ConfigFile);
            XPathFactory xFactory = XPathFactory.newInstance();
            this.xPath = xFactory.newXPath();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void setAttrTypeUsedToNameNode(String inAttrTypeUsedToNameNode) {
        String ValueOfNameAttr = "string(@" + inAttrTypeUsedToNameNode + ")";
        this.LowCaseNodeName = this.XpathStringToLowerCase(ValueOfNameAttr);
    }

    public void setNodeType(String inNodeType) {
        this.NodeType = inNodeType;
    }

    public void setRequestedNodeName(String RequestedNodeName) {
        this.LowCaseRequestedName = "'" + RequestedNodeName.toLowerCase() + "'] ";
    }

    public void setAttributeToRetrun(String inAttributeToRetrun) {
        this.AttributeToRetrun = inAttributeToRetrun;
    }

    private String XpathStringToLowerCase(String MixedCaseString) {
        return "translate(" + MixedCaseString + ", 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')";
    }

    public String getCanonicalPath() {
        String OutputPath = null;
        try {
            OutputPath = this.ConfigFile.getCanonicalPath();
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return OutputPath;
    }

    public String evaluate() {
        String PathToNode = "*/" + this.NodeType + "[";
        String XPathStr = PathToNode + this.LowCaseNodeName + " = " + this.LowCaseRequestedName + "/@" + this.AttributeToRetrun;
        String OutputAttrValue = null;
        try {
            OutputAttrValue = this.xPath.evaluate(XPathStr, this.document);
        }
        catch (XPathExpressionException excep) {
            OutputAttrValue = null;
        }
        if (OutputAttrValue.equals("")) {
            OutputAttrValue = null;
        }
        return OutputAttrValue;
    }
}

