/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.Conversions;

import edu.umn.space.swaves.util.strings.stringTools;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeConversions
extends GregorianCalendar {
    String YYYY;
    String DOY;
    String MON;
    String DayMon;
    String HH;
    String MM;
    String SS;
    String MMM;
    private static final int NumberMillsecInDay = 86400000;
    public static final int kUSE_LOCALTIME = 0;
    private static final DateTimeConversions Jan1982 = new DateTimeConversions(1982, 1, 0, 0, 0, 0);

    public DateTimeConversions(int year, int dayOfYear, int hour, int min, int sec, int msec) {
        super.set(1, year);
        super.set(6, dayOfYear);
        super.set(11, hour);
        super.set(12, min);
        super.set(13, sec);
        super.set(14, msec);
    }

    public DateTimeConversions(int year, int month, int dayOfMonth, int hour, int min, int sec, int msec) {
        super.set(1, year);
        super.set(2, month);
        super.set(5, dayOfMonth);
        super.set(11, hour);
        super.set(12, min);
        super.set(13, sec);
        super.set(14, msec);
        this.useGMT();
    }

    public DateTimeConversions(Date javaDateObjectToConvert) {
        super.setTime(javaDateObjectToConvert);
        this.useGMT();
    }

    public DateTimeConversions() {
        super.setTime(new Date());
        this.useGMT();
    }

    public DateTimeConversions(int flag) {
        super.setTime(new Date());
    }

    public void setYear(int year) {
        super.set(1, year);
    }

    public int getYear() {
        return super.get(1);
    }

    public void setDOY(int dayOfYear) {
        super.set(6, dayOfYear);
    }

    public int getDOY() {
        return super.get(6);
    }

    public double getUR8Time() {
        double UR8Time = (double)(super.getTimeInMillis() - Jan1982.getTimeInMillis()) / 1000.0 / 86400.0;
        return UR8Time;
    }

    public int getUR8TimeDayComponent() {
        return (int)Math.floor(this.getUR8Time());
    }

    public int getUR8TimeMillSecInDayComponent() {
        double CurrentUR8 = this.getUR8Time();
        double Days = Math.floor(CurrentUR8);
        double FractDays = CurrentUR8 - Days;
        int MillsecInDay = (int)Math.floor(FractDays * 8.64E7);
        return MillsecInDay;
    }

    public void setUR8Time(double inputUR8) {
        long millsesSinceJan1982 = (long)(inputUR8 * 1000.0 * 3600.0 * 24.0);
        long MilleSecSince1970 = millsesSinceJan1982 + Jan1982.getTimeInMillis();
        super.setTimeInMillis(MilleSecSince1970);
    }

    public static long secSinceEpoch2MilliSecInDay(long epochSec) {
        double DayFraction = (double)epochSec / 86400.0;
        return (long)((DayFraction - Math.floor(DayFraction)) * 86400.0 * 1000.0);
    }

    public void dump() {
        System.out.println("ERA: " + super.get(0));
        System.out.println("YEAR: " + super.get(1));
        System.out.println("MONTH: " + super.get(2));
        System.out.println("WEEK_OF_YEAR: " + super.get(3));
        System.out.println("WEEK_OF_MONTH: " + super.get(4));
        System.out.println("DATE: " + super.get(5));
        System.out.println("DAY_OF_MONTH: " + super.get(5));
        System.out.println("DAY_OF_YEAR: " + super.get(6));
        System.out.println("DAY_OF_WEEK: " + super.get(7));
        System.out.println("DAY_OF_WEEK_IN_MONTH: " + super.get(8));
        System.out.println("AM_PM: " + super.get(9));
        System.out.println("HOUR: " + super.get(10));
        System.out.println("HOUR_OF_DAY: " + super.get(11));
        System.out.println("MINUTE: " + super.get(12));
        System.out.println("SECOND: " + super.get(13));
        System.out.println("MILLISECOND: " + super.get(14));
        System.out.println("ZONE_OFFSET: " + super.get(15) / 3600000);
        System.out.println("DST_OFFSET: " + super.get(16) / 3600000);
    }

    public String getPtpDaqTimeStamp() {
        double tenthsSec = (double)super.get(14) / 100.0;
        long LongTenthsSec = Math.round(tenthsSec);
        if (LongTenthsSec == 10L) {
            LongTenthsSec = 0L;
            long UnRoundedTimeMilli = super.getTimeInMillis();
            long RoundUpOneSecond = UnRoundedTimeMilli / 1000L * 1000L + 1L;
            super.setTimeInMillis(RoundUpOneSecond);
        }
        this.YYYY = Integer.toString(super.get(1));
        this.DOY = Integer.toString(super.get(6));
        this.DOY = stringTools.zeroInsertToFixedLength(this.DOY, 3);
        this.HH = Integer.toString(super.get(11));
        this.HH = stringTools.zeroInsertToFixedLength(this.HH, 2);
        this.MM = Integer.toString(super.get(12));
        this.MM = stringTools.zeroInsertToFixedLength(this.MM, 2);
        this.SS = Integer.toString(super.get(13));
        this.SS = stringTools.zeroInsertToFixedLength(this.SS, 2);
        String StrTenths = Long.toString(LongTenthsSec, 10);
        return this.YYYY + "_" + this.DOY + "_" + this.HH + this.MM + this.SS;
    }

    public String getDOY_3CharString() {
        String DOYstr = Integer.toString(super.get(6));
        DOYstr = stringTools.zeroInsertToFixedLength(DOYstr, 3);
        return DOYstr;
    }

    public void setMilliSecEpoc1958(long inputMilliSec1958) {
        long mjdepoch1958 = 36204L;
        long mjdepoch1970 = 40587L;
        long delta_msec = (mjdepoch1970 - mjdepoch1958) * 1000L * 86400L;
        super.setTimeInMillis(inputMilliSec1958 - delta_msec);
    }

    public void setMilliSecEpoc1958(long inputSecSince1958, int fractSec) {
        long MilliSecs = inputSecSince1958 * 1000L;
        double FractSec = (double)fractSec / 256.0;
        this.setMilliSecEpoc1958(MilliSecs += Math.round(FractSec *= 1000.0));
    }

    public void setMilliSecEpoc1958(long inputSecSince1958, long fractSec) {
        long MilliSecs = inputSecSince1958 * 1000L;
        double FractSec = (double)fractSec / Math.pow(2.0, 32.0) * 1000.0;
        this.setMilliSecEpoc1958(MilliSecs += Math.round(FractSec));
    }

    private void useGMT() {
        super.setTimeZone(TimeZone.getTimeZone("GMT + 0"));
        Jan1982.setTimeZone(TimeZone.getTimeZone("GMT + 0"));
    }

    public static void main(String[] args) {
        DateTimeConversions UR8Finder = new DateTimeConversions(1982, 0, 0, 0, 0, 0, 0);
        int Year = 2008;
        for (int DOY = 1; DOY < 367; ++DOY) {
            UR8Finder.setYear(Year);
            UR8Finder.setDOY(DOY);
            System.out.println(Year + " " + DOY + " " + UR8Finder.getUR8Time());
        }
    }
}

