/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser.util;

public class FFT {
    private float[] real;
    private float[] imag;

    public FFT(float[] the_real, float[] the_imag) {
        this.real = the_real;
        this.imag = the_imag;
    }

    public FFT() {
        this.real = new float[2];
        this.imag = new float[2];
    }

    public float[] getReal() {
        return this.real;
    }

    public void setReal(float[] the_real) {
        this.real = the_real;
    }

    public float[] getImag() {
        return this.imag;
    }

    public void setImag(float[] the_imag) {
        this.imag = the_imag;
    }

    public void forward() {
        this.fft(1.0f / (float)this.real.length);
    }

    public void inverse() {
        this.fft(1.0f);
    }

    public void fft(float scale) {
        int m;
        float tempi;
        float tempr;
        int i;
        int n = this.real.length;
        int j = 0;
        for (i = 0; i < n; ++i) {
            if (j >= i) {
                tempr = this.real[j] * scale;
                tempi = this.imag[j] * scale;
                this.real[j] = this.real[i] * scale;
                this.imag[j] = this.imag[i] * scale;
                this.real[i] = tempr;
                this.imag[i] = tempi;
            }
            for (m = n / 2; m >= 1 && j >= m; j -= m, m /= 2) {
            }
            j += m;
        }
        int mmax = 1;
        int istep = 2 * mmax;
        while (mmax < n) {
            float delta = (float)Math.PI / (float)mmax;
            for (m = 0; m < mmax; ++m) {
                float w = (float)m * delta;
                float wr = (float)Math.cos(w);
                float wi = (float)Math.sin(w);
                for (i = m; i < n; i += istep) {
                    j = i + mmax;
                    tempr = wr * this.real[j] - wi * this.imag[j];
                    tempi = wr * this.imag[j] + wi * this.real[j];
                    this.real[j] = this.real[i] - tempr;
                    this.imag[j] = this.imag[i] - tempi;
                    int n2 = i;
                    this.real[n2] = this.real[n2] + tempr;
                    int n3 = i;
                    this.imag[n3] = this.imag[n3] + tempi;
                }
            }
            mmax = istep;
            istep = 2 * mmax;
        }
    }
}

