/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.logServer.ServerSide;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.logServer.ServerSide.CentralLoggerThread;
import edu.umn.space.swaves.logServer.ServerSide.TMLibConsoleFormatter;
import edu.umn.space.swaves.logServer.ServerSide.TMLibXmlLogFormatter;
import edu.umn.space.swaves.util.Conversions.DateTimeConversions;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import edu.umn.space.swaves.util.xml.SearchConfigFileList;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public final class CentralLogger {
    private ServerSocketChannel ServerToAcceptLoggerClients;
    private Logger MainLogger;

    public CentralLogger() throws Exception {
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        String Log_Perfix = propData.getStr("Logs#*Log_prefix");
        int LOG_PORT = propData.getInt("Logs#*LOG_PORT");
        DateTimeConversions TodaysDate = new DateTimeConversions(new Date());
        String LoggerName = Log_Perfix + "_" + TodaysDate.getPtpDaqTimeStamp();
        this.MainLogger = Logger.getLogger(LoggerName);
        this.MainLogger.setUseParentHandlers(false);
        try {
            SearchConfigFileList ConfigFiles = new SearchConfigFileList();
            String Log_dir = ConfigFiles.getLoggerPath();
            String FileName = Log_dir + "/" + LoggerName + ".xml";
            File PossibleDir = new File(Log_dir);
            FileHandler DumpLogTofile = new FileHandler(FileName);
            TMLibXmlLogFormatter XMLformat = new TMLibXmlLogFormatter();
            DumpLogTofile.setFormatter(XMLformat);
            this.MainLogger.addHandler(DumpLogTofile);
        }
        catch (GSEException excep) {
            System.out.print("\n \n \n" + excep.getMessage());
            System.out.println("\n*************************************");
            System.out.println("The user must create the directory above to store log messages");
            System.out.println("in files.  Otherwise log messages only go to the console.\n\n");
        }
        ConsoleHandler ToScreen = new ConsoleHandler();
        ToScreen.setLevel(TMlibLogLevel.Item_Low);
        ToScreen.setFormatter(new TMLibConsoleFormatter());
        this.MainLogger.addHandler(ToScreen);
        this.MainLogger.setLevel(TMlibLogLevel.Item_Low);
        this.ServerToAcceptLoggerClients = ServerSocketChannel.open();
        this.ServerToAcceptLoggerClients.socket().bind(new InetSocketAddress(LOG_PORT));
        this.ServerToAcceptLoggerClients.configureBlocking(true);
    }

    private void waitForLoggerClients() {
        int FailLimit = 10;
        int NumFailures = 0;
        while (true) {
            try {
                while (true) {
                    SocketChannel FromLogClient = this.ServerToAcceptLoggerClients.accept();
                    FromLogClient.configureBlocking(true);
                    CentralLoggerThread NewLogger = new CentralLoggerThread(FromLogClient);
                    NewLogger.setMainLogger(this.MainLogger);
                    NewLogger.start();
                    NumFailures = 0;
                }
            }
            catch (Exception excep) {
                if (++NumFailures <= 10) continue;
                System.out.println("*************************************");
                System.out.println("Logger Server has died after " + FailLimit);
                System.out.println("To create a new connection to a logger client");
                return;
            }
            break;
        }
    }

    public static void main(String[] args) {
        CentralLogger TmLogger = null;
        try {
            TmLogger = new CentralLogger();
        }
        catch (Exception LogExcep) {
            System.out.println("\n\nLogger Server could not be created\n\n");
            LogExcep.printStackTrace();
        }
        TmLogger.waitForLoggerClients();
    }
}

