/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.logServer.ClientSide;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SocketChannelLogHandler
extends Handler {
    private static final int LOGGER_MODE_LOG_MESSAGE = 1;
    private static final int LOGGER_MODE_COMMAND_CODE = 2;
    private ByteBuffer LogBuffer;
    private Charset charset = Charset.forName("US-ASCII");
    private static String host = "localhost";
    private SocketChannel TcpConnectionToLogger;
    private static final String ErrPath = "Universe.edu.umn.space.swaves..Logger";
    String ExcepName;
    String ErrComment;

    public SocketChannelLogHandler(int LOGGER_PORT) throws GSEException {
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        int BufferSz = propData.getInt("Logs#*LOGGER_BUFFER_SIZE");
        this.LogBuffer = ByteBuffer.allocateDirect(BufferSz);
        boolean Keeptrying = true;
        int NumFails = 0;
        while (Keeptrying) {
            try {
                InetSocketAddress MocInternetAddress = new InetSocketAddress(InetAddress.getByName(host), LOGGER_PORT);
                this.TcpConnectionToLogger = SocketChannel.open();
                this.TcpConnectionToLogger.connect(MocInternetAddress);
                this.TcpConnectionToLogger.configureBlocking(true);
                Keeptrying = false;
            }
            catch (IOException excep) {
                if (++NumFails > 10) break;
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        SocketChannelLogHandler socketChannelLogHandler = this;
        synchronized (socketChannelLogHandler) {
            this.LogBuffer.clear();
            this.LogBuffer.putInt(1);
            this.LogBuffer.putInt(record.getLevel().intValue());
            this.LogBuffer.putLong(record.getMillis());
            String LoggerName = record.getLoggerName();
            this.LogBuffer.putInt(LoggerName.length());
            this.LogBuffer.put(this.charset.encode(LoggerName));
            String SourceClassName = record.getSourceClassName();
            this.LogBuffer.putInt(SourceClassName.length());
            this.LogBuffer.put(this.charset.encode(SourceClassName));
            String SourceMethodName = record.getSourceMethodName();
            this.LogBuffer.putInt(SourceMethodName.length());
            this.LogBuffer.put(this.charset.encode(SourceMethodName));
            String Message = record.getMessage();
            this.LogBuffer.putInt(Message.length());
            this.LogBuffer.put(this.charset.encode(Message));
            this.transmitBuffer(this.LogBuffer);
        }
    }

    private void transmitBuffer(ByteBuffer LogToSend) {
        int NumFails = 0;
        LogToSend.flip();
        try {
            while (LogToSend.hasRemaining()) {
                this.TcpConnectionToLogger.write(LogToSend);
                if (!LogToSend.hasRemaining()) continue;
                Thread.sleep(40L);
                if (++NumFails <= 10) continue;
                this.ExcepName = "Universe.edu.umn.space.swaves..LoggerERROR_WRITING_TO_LOGGER";
                this.ErrComment = "Client could not write to the logger";
                break;
            }
        }
        catch (Exception e) {
            this.ExcepName = "Universe.edu.umn.space.swaves..LoggerERROR_WRITING_TO_LOGGER";
            this.ErrComment = "Client could not write to the logger";
        }
    }

    public void flush() {
    }

    public void close() {
        this.LogBuffer.clear();
        this.LogBuffer.putInt(2);
        this.LogBuffer.putInt(57005);
        this.transmitBuffer(this.LogBuffer);
    }
}

