/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlTransform {
    private DocumentBuilder builder;
    private DOMSource DOMTreeSource;
    private Transformer XMLTransForm;
    private StreamResult TransformResult;
    private StringWriter StrBufferResult;
    private EntityResolver HandleEntities;

    public XmlTransform() throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
        this.XMLTransForm = TransformerFactory.newInstance().newTransformer();
        this.XMLTransForm.setOutputProperty("indent", "yes");
        this.XMLTransForm.setOutputProperty("method", "xml");
        this.XMLTransForm.setOutputProperty("media-type", "text/xml");
        this.StrBufferResult = new StringWriter();
        this.StrBufferResult.write(" ");
        this.TransformResult = new StreamResult(this.StrBufferResult);
        this.DOMTreeSource = new DOMSource();
    }

    public void setFile(File inputFile) throws SAXException, IOException {
        this.DOMTreeSource.setNode(this.builder.parse(inputFile));
    }

    public void setTopNode(Node inNode) throws SAXException, IOException {
        this.DOMTreeSource.setNode(inNode);
    }

    public void setOutputProperty(String name, String value) {
        this.XMLTransForm.setOutputProperty(name, value);
    }

    public void setEntityResolver(EntityResolver inputEntityResolver) {
        this.builder.setEntityResolver(inputEntityResolver);
    }

    public StringBuffer XmlToStringBuffer() throws TransformerException {
        int StrLen = this.StrBufferResult.getBuffer().length();
        this.StrBufferResult.getBuffer().delete(0, StrLen);
        this.XMLTransForm.transform(this.DOMTreeSource, this.TransformResult);
        return this.StrBufferResult.getBuffer();
    }

    public void reset() {
        this.builder.reset();
        this.XMLTransForm.reset();
        this.DOMTreeSource.setNode(null);
    }
}

