/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.xml;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import edu.umn.space.swaves.util.xml.SearchXMl_TreeBasedOnAttrValues;
import java.io.File;
import java.util.Vector;

public class SearchConfigFileList {
    private static final String ErrPath = "Universe.edu.umn.space.swaves..util.xml.";
    private static String TMlibRoot;
    private static Vector<SearchXMl_TreeBasedOnAttrValues> ConfigFilesAsXPath;

    public SearchConfigFileList() throws GSEException {
        if (ConfigFilesAsXPath == null) {
            ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
            TMlibRoot = propData.findGseTopDir();
            String ConfigFiles = propData.getStr("FileSystem#*CONFIG_FILES_IN_ORDER");
            String[] PosssibleConfigFiles = ConfigFiles.split(",");
            ConfigFilesAsXPath = new Vector();
            for (int i = 0; i < PosssibleConfigFiles.length; ++i) {
                File TestFile = new File(PosssibleConfigFiles[i].trim());
                if (!TestFile.exists()) continue;
                SearchXMl_TreeBasedOnAttrValues XPathSearch = new SearchXMl_TreeBasedOnAttrValues(TestFile);
                XPathSearch.setAttrTypeUsedToNameNode("name");
                ConfigFilesAsXPath.add(XPathSearch);
            }
            ConfigFilesAsXPath.trimToSize();
        }
    }

    public String getMOC_ForCurrentSession() throws GSEException {
        return this.getGeneralValue("TMlib_MOC", "TMlib_MOC_default", "MOC_selection");
    }

    public String getLoggerPath() throws GSEException {
        return this.getGeneralValue("TMlib_path", "TMlib_Logger", "path");
    }

    public String getPath(String PathName) throws GSEException {
        return this.getGeneralValue("TMlib_path", PathName, "path");
    }

    public String getWILDCARD_ROOT(String MissionName) throws GSEException {
        return this.getGeneralValue("mission_paths", MissionName, "wildcard_root");
    }

    public String getCHOOSER_ROOT(String MissionName) throws GSEException {
        return this.getGeneralValue("mission_paths", MissionName, "file_chooser_root");
    }

    public String getANCILLARY_ROOT(String MissionName) throws GSEException {
        return this.getGeneralValue("mission_paths", MissionName, "ancillary_root");
    }

    public String getLZ_ROOT(String MissionName) throws GSEException {
        return this.getGeneralValue("mission_paths", MissionName, "LZ_range_root");
    }

    private String getGeneralValue(String NodeType, String RequestedNodeName, String AttributeToRetrun) throws GSEException {
        String OutString = null;
        for (int i = 0; i < ConfigFilesAsXPath.size(); ++i) {
            SearchXMl_TreeBasedOnAttrValues ConfigFileToSearch = ConfigFilesAsXPath.get(i);
            ConfigFileToSearch.setNodeType(NodeType);
            ConfigFileToSearch.setRequestedNodeName(RequestedNodeName);
            ConfigFileToSearch.setAttributeToRetrun(AttributeToRetrun);
            OutString = ConfigFileToSearch.evaluate();
            if (OutString != null) break;
        }
        if ((OutString = OutString.replaceAll("TMLIB_ENGINE_ROOT", TMlibRoot)) == null) {
            String ListOfFiles = "";
            for (int i = 0; i < ConfigFilesAsXPath.size(); ++i) {
                SearchXMl_TreeBasedOnAttrValues ConfigFileToSearch = ConfigFilesAsXPath.get(i);
                ListOfFiles = ListOfFiles + ConfigFileToSearch.getCanonicalPath() + "\n";
            }
            String ExcepName = "Universe.edu.umn.space.swaves..util.xml.ERROR_GETTING_PARAMETER_FROM_CONFIG_FILE";
            String ErrComment = "The parameter " + AttributeToRetrun + "\n" + " was not found in a node of type  " + NodeType + "\n" + "The requested node had the name: " + RequestedNodeName + "\n" + "The following files were searched: \n" + ListOfFiles;
            throw new GSEException(ErrComment, ExcepName);
        }
        return OutString;
    }

    static {
        ConfigFilesAsXPath = null;
    }
}

