/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.io;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.io.FileData;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASCII_Reader {
    int offset = 0;
    private FileData FileInfo = new FileData();
    private static final String ErrPath = "Universe.edu.umn.space.swaves..util.io.";
    private String SelectedFile;
    private static final Pattern CommentAtEndOfLine = Pattern.compile("(.*)\\!(.*)");

    public void readFile(String CommonDir, String Specific_SpaceCraft, String Common_Branch) throws GSEException {
        try {
            FileInputStream FileStream2 = null;
            String SpecificPath = CommonDir.replaceAll(Common_Branch, Specific_SpaceCraft);
            File SpecificFile = new File(SpecificPath);
            this.SelectedFile = SpecificFile.exists() ? SpecificPath : CommonDir;
            FileStream2 = new FileInputStream(this.SelectedFile);
            BufferedInputStream BufferedInput = new BufferedInputStream(FileStream2);
            BufferedReader ReaderObj = new BufferedReader(new InputStreamReader(BufferedInput));
            String line = ReaderObj.readLine();
            int TotalLength = 0;
            this.FileInfo.addLineLength(TotalLength);
            while (line != null) {
                if (!(line = line.trim()).startsWith("!")) {
                    Matcher CommentMatcher = CommentAtEndOfLine.matcher(line);
                    if (CommentMatcher.find()) {
                        line = CommentMatcher.group(1);
                    }
                    String[] ElementsInALine = line.split("\\s+");
                    for (int i = 0; i < ElementsInALine.length; ++i) {
                        this.FileInfo.addFileString(ElementsInALine[i]);
                    }
                    this.FileInfo.addLineLength(TotalLength += ElementsInALine.length);
                }
                line = ReaderObj.readLine();
            }
        }
        catch (Exception e) {
            String ExcepName = "Universe.edu.umn.space.swaves..util.io.ERROR_READING_ASCII_FILE";
            String ErrComment = "The file named " + this.SelectedFile + " could not be read on either the specific or the common branch";
            throw new GSEException(ErrComment, ExcepName);
        }
    }

    public void skipLines(int NumLines) {
        this.offset = this.FileInfo.getLineLength(NumLines);
    }

    public String getString(int UserIndex) {
        return this.FileInfo.getFileString(UserIndex + this.offset);
    }

    public int getInt(int UserIndex) throws GSEException {
        String StrEntry = this.FileInfo.getFileString(UserIndex + this.offset);
        int Value = 0;
        try {
            Value = Integer.parseInt(StrEntry);
        }
        catch (NumberFormatException excep) {
            String ExcepName = "Universe.edu.umn.space.swaves..util.io.STRING_FROM_ASCII_NOT_INTEGER";
            String ErrComment = "The string " + StrEntry + " from the file " + this.SelectedFile + " is not an integer";
            throw new GSEException(ErrComment, ExcepName);
        }
        return Value;
    }

    public float getFloat(int UserIndex) throws GSEException {
        String StrEntry = this.FileInfo.getFileString(UserIndex + this.offset);
        float Value = 0.0f;
        try {
            Value = new Float(StrEntry).floatValue();
        }
        catch (NumberFormatException excep) {
            String ExcepName = "Universe.edu.umn.space.swaves..util.io.STRING_FROM_ASCII_NOT_FLOAT";
            String ErrComment = "The string " + StrEntry + " from the file " + this.SelectedFile + " is not an float";
            throw new GSEException(ErrComment, ExcepName);
        }
        return Value;
    }

    public double getDouble(int UserIndex) throws GSEException {
        String StrEntry = this.FileInfo.getFileString(UserIndex + this.offset);
        double Value = 0.0;
        try {
            Value = new Double(StrEntry).floatValue();
        }
        catch (NumberFormatException excep) {
            String ExcepName = "Universe.edu.umn.space.swaves..util.io.STRING_FROM_ASCII_NOT_DOUBLE";
            String ErrComment = "The string " + StrEntry + " from the file " + this.SelectedFile + " is not an double";
            throw new GSEException(ErrComment, ExcepName);
        }
        return Value;
    }
}

