/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.tcpServer;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.tcpServer.TCP_TMlibThread;
import edu.umn.space.swaves.util.threads.threadWatchDog;
import edu.umn.space.swaves.util.threads.watchDogInterface;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class tcpPidSess
implements watchDogInterface {
    private boolean continueWaitingForClients = true;
    private threadWatchDog ClientConnectWatchDog;
    private ServerSocketChannel ServerForTmClients;
    private int TimeOut_sec;
    private int idNumOfClient;

    public tcpPidSess(int inputIdNumOfClient) throws GSEException {
        this.idNumOfClient = inputIdNumOfClient;
        String ClientStringID = "_" + this.idNumOfClient;
        LogClient.getLogger(1, ClientStringID);
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        this.TimeOut_sec = propData.getInt("TMlibSession#*TMlibSessionTimeOut_sec");
        this.ClientConnectWatchDog = new threadWatchDog(this, this.TimeOut_sec * 1000);
        this.ClientConnectWatchDog.setName("Client Connect WatchDog " + ClientStringID);
        this.ClientConnectWatchDog.beginTimer();
    }

    public void waitForClientsToConnect(int portOfWaitingServer) {
        try {
            this.ServerForTmClients = ServerSocketChannel.open();
            this.ServerForTmClients.socket().bind(new InetSocketAddress(portOfWaitingServer));
            LogClient.log(TMlibLogLevel.Domain_High, "TMlibSession bound to port: " + portOfWaitingServer);
            this.ServerForTmClients.configureBlocking(true);
            while (this.continueWaitingForClients) {
                SocketChannel SocketToClient = this.ServerForTmClients.accept();
                TestIncomingRequest checkClient = new TestIncomingRequest(SocketToClient, this.idNumOfClient);
                checkClient.setName("TestIncomingRequest[" + this.idNumOfClient + "]");
                checkClient.start();
            }
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public void shutdownFromWatchDog() {
        this.continueWaitingForClients = false;
        try {
            this.ServerForTmClients.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LogClient.log(TMlibLogLevel.Domain_High, "Watchdog fired before client connection complete");
        System.exit(1);
    }

    public static void main(String[] args) {
        int port = Integer.parseInt(args[0]);
        int idNum = Integer.parseInt(args[1]);
        try {
            tcpPidSess LauncherForTmThreads = new tcpPidSess(idNum);
            LauncherForTmThreads.waitForClientsToConnect(port);
        }
        catch (GSEException Excep) {
            System.out.println("GSEException Exception while launching session:");
            System.out.println("Name:        " + Excep.getErrorName());
            System.out.println("Code:        " + Excep.getErrorCode());
            System.out.println("Description: " + Excep.getErrorDescription());
            System.out.println("Message:     " + Excep.getMessage());
            System.exit(0);
        }
    }

    private class TestIncomingRequest
    extends Thread {
        SocketChannel SocketToClient;
        int ClientIdNum;

        public TestIncomingRequest(SocketChannel inSocketToClient, int inClientIdNum) {
            this.SocketToClient = inSocketToClient;
            this.ClientIdNum = inClientIdNum;
        }

        public void run() {
            try {
                ByteBuffer ClientBuff = ByteBuffer.allocate(12);
                TCP_TMlibThread.readBufferVariableLen(this.SocketToClient, ClientBuff);
                ClientBuff.flip();
                ClientBuff.position(5);
                int InputID_Num = ClientBuff.getInt();
                if (InputID_Num != this.ClientIdNum) {
                    TCP_TMlibThread.sendErrorMessage(this.SocketToClient, ClientBuff, 1502);
                } else {
                    TCP_TMlibThread.sendErrorMessage(this.SocketToClient, ClientBuff, 0);
                    tcpPidSess.this.ClientConnectWatchDog.eliminateTimer();
                    TCP_TMlibThread TheNewTmLibSession = new TCP_TMlibThread();
                    TheNewTmLibSession.conversationWithClient(this.SocketToClient, tcpPidSess.this.TimeOut_sec);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

