/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.tcpServer;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.ServerShutdownException;
import edu.umn.space.swaves.stereoLib.TMLibWireProtServer;
import edu.umn.space.swaves.util.threads.threadWatchDog;
import edu.umn.space.swaves.util.threads.watchDogInterface;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public final class TCP_TMlibThread
implements watchDogInterface {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.tcpServer.";
    private static final int ReadFailsLimit = 10;
    private String RemoteClient;
    private TMLibWireProtServer TmLib = new TMLibWireProtServer();
    private SocketChannel ClientSock;

    public void conversationWithClient(SocketChannel inClientSock, int InactiveTimeLimit) {
        this.ClientSock = inClientSock;
        threadWatchDog TcpReadWatchDog = new threadWatchDog(this, InactiveTimeLimit * 1000);
        InetSocketAddress RemoteAddress = (InetSocketAddress)this.ClientSock.socket().getRemoteSocketAddress();
        String RemoteIP = RemoteAddress.getAddress().getHostAddress();
        String RemoteAdd = RemoteAddress.getHostName();
        this.RemoteClient = "Remote IP  : " + RemoteIP + "\n" + "Remote Name: " + RemoteAdd;
        LogClient.log(TMlibLogLevel.Domain_High, "Launching new server process \n" + this.RemoteClient);
        ByteBuffer ToClientByteBuff = ByteBuffer.allocate(500000);
        ByteBuffer FromClientByteBuff = ByteBuffer.allocate(700);
        try {
            while (true) {
                TcpReadWatchDog.beginTimer();
                ToClientByteBuff.clear();
                TCP_TMlibThread.readBufferVariableLen(this.ClientSock, FromClientByteBuff);
                TcpReadWatchDog.halt();
                FromClientByteBuff.flip();
                this.TmLib.CommandToTmLib(FromClientByteBuff, ToClientByteBuff);
                ToClientByteBuff.flip();
                TCP_TMlibThread.writeSocketCH(this.ClientSock, ToClientByteBuff);
            }
        }
        catch (ServerShutdownException excep) {
            String ErrorMessage = "Shut down requested by client";
            String ErrorCode = "Universe.edu.umn.space.swaves.tcpServer.CLIENT_REQUESTED_SHUTDOWN";
            GSEException CloseExcep = new GSEException(ErrorMessage, ErrorCode);
            this.shutdown(CloseExcep);
        }
        catch (ClosedChannelException e) {
            String ErrorMessage = "Tried to read/write to/from a closed socket. \n Client: \n" + this.RemoteClient;
            String ErrorCode = "Universe.edu.umn.space.swaves.tcpServer.FATAL_TCP_IP_ERROR";
            GSEException CloseExcep = new GSEException(ErrorMessage, ErrorCode);
            this.shutdown(CloseExcep);
        }
        catch (IOException e) {
            String ErrorMessage = "IOException while talking to client";
            String ErrorCode = "Universe.edu.umn.space.swaves.tcpServer.FATAL_TCP_IP_ERROR";
            GSEException CloseExcep = new GSEException(ErrorMessage, ErrorCode);
            this.shutdown(CloseExcep);
        }
        catch (Exception FatalException) {
            String ErrorCode = "Universe.edu.umn.space.swaves.tcpServer.FATAL_UNHANDLED_ERROR";
            String ErrorMessage = "Fatal Unhandled Error \n " + FatalException.toString() + "\n";
            for (int i = 0; i < FatalException.getStackTrace().length; ++i) {
                ErrorMessage = ErrorMessage + FatalException.getStackTrace()[i].toString().trim() + "\n";
            }
            GSEException CloseExcep = new GSEException(ErrorMessage, ErrorCode);
            this.shutdown(CloseExcep);
        }
    }

    public void shutdownFromWatchDog() {
        String ErrorMessage = "While waiting for a command from the client the watch dog timed out";
        String ErrorCode = "Universe.edu.umn.space.swaves.tcpServer.WATCH_DOG_FIRED_WAITING_FOR_CLIENT";
        GSEException CloseExcep = new GSEException(ErrorMessage, ErrorCode);
        this.shutdown(CloseExcep);
    }

    public static void readSocketCH(ReadableByteChannel InChannel, ByteBuffer InBuffer) throws IOException {
        block1: {
            int num = 0;
            do {
                InChannel.read(InBuffer);
                if (!InBuffer.hasRemaining()) break block1;
                TCP_TMlibThread.sleeper(50L);
            } while (++num <= 10);
            throw new IOException("Read failed from TMlib Client");
        }
    }

    public static void writeSocketCH(WritableByteChannel OutChannel, ByteBuffer OutBuffer) throws IOException {
        block1: {
            int num = 0;
            do {
                OutChannel.write(OutBuffer);
                if (!OutBuffer.hasRemaining()) break block1;
                TCP_TMlibThread.sleeper(50L);
            } while (++num <= 10);
            throw new IOException("Write failed to TMlib Client");
        }
    }

    public static void readBufferVariableLen(ReadableByteChannel InChannel, ByteBuffer InBuffer) throws IOException {
        InBuffer.clear();
        InBuffer.limit(4);
        TCP_TMlibThread.readSocketCH(InChannel, InBuffer);
        int NumBytesFromClient = InBuffer.getInt(0);
        InBuffer.limit(NumBytesFromClient + 4);
        TCP_TMlibThread.readSocketCH(InChannel, InBuffer);
    }

    public static void sendErrorMessage(WritableByteChannel OutChannel, ByteBuffer OutBuffer, int ErrorCode) throws IOException {
        TMLibWireProtServer.setNoDataJustError(ErrorCode, OutBuffer);
        OutBuffer.flip();
        TCP_TMlibThread.writeSocketCH(OutChannel, OutBuffer);
    }

    public static void sleeper(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void shutdown(GSEException CloseExcep) {
        ByteBuffer FinalMessage = ByteBuffer.allocate(12);
        LogClient.log(TMlibLogLevel.Domain_High, "Server Process Will Exit\nFor Client: \n" + this.RemoteClient + "\n" + "Cause: " + CloseExcep.getMessage());
        try {
            if (CloseExcep.getErrorName().equals("CLIENT_REQUESTED_SHUTDOWN")) {
                TMLibWireProtServer.setNoDataJustError(CloseExcep.getErrorCode(), FinalMessage);
                FinalMessage.flip();
                TCP_TMlibThread.writeSocketCH(this.ClientSock, FinalMessage);
                this.ClientSock.close();
            }
        }
        catch (Exception excep) {
            // empty catch block
        }
        try {
            LogClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }
}

