/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.Extract;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.item.TMlibAreaDataBuffers;
import java.nio.ByteBuffer;

public class Exhaustive_Extract {
    private ByteBuffer BufferToExtractBytesFrom;
    private static final String ErrPath = "Universe.edu.umn.space.swaves.";

    public void extract(int AreaNumber, int BitsFromStartOfArea, int LengthInBits, int BitsOffsetToNextElementInDataBlock, int RepetitionsInSingleDataBlock, int BitsOffsetToNextDataBlock, int TotalNumberOfDataBlocks, int SignedPull, String ItemName, TMlibAreaDataBuffers Areas) throws GSEException {
        block9: {
            int ReadTestAreaNumber = AreaNumber;
            if (AreaNumber > 0) {
                ReadTestAreaNumber = 0;
            }
            if (!Areas.isReadable(ReadTestAreaNumber)) {
                String ExcepName = "Universe.edu.umn.space.swaves..extract.AREA_NOT_READABLE";
                String ErrComment = "Area " + ReadTestAreaNumber + " is not readable \n";
                throw new GSEException(ErrComment, ExcepName);
            }
            try {
                this.BufferToExtractBytesFrom = Areas.getAreaBuffer(AreaNumber);
                if (AreaNumber < 0) {
                    AreaNumber = 0;
                    this.BufferToExtractBytesFrom.limit(this.BufferToExtractBytesFrom.capacity());
                }
                int StartBit = AreaNumber * 8 + BitsFromStartOfArea;
                Areas.OutBuf.clear();
                if (LengthInBits % 8 == 0 && StartBit % 8 == 0) {
                    this.IntegerNumberBytePull(StartBit, LengthInBits, BitsOffsetToNextElementInDataBlock, RepetitionsInSingleDataBlock, BitsOffsetToNextDataBlock, TotalNumberOfDataBlocks, SignedPull, Areas.OutBuf);
                } else {
                    for (int NumBlocksPulled = 0; NumBlocksPulled != TotalNumberOfDataBlocks; ++NumBlocksPulled) {
                        int BitPos = StartBit + BitsOffsetToNextDataBlock * NumBlocksPulled;
                        for (int NumSubBlocksPulled = 0; NumSubBlocksPulled != RepetitionsInSingleDataBlock; ++NumSubBlocksPulled) {
                            int outval = this.nonEightpull(BitPos, LengthInBits);
                            Areas.OutBuf.putInt(outval);
                            BitPos += BitsOffsetToNextElementInDataBlock + LengthInBits;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException excep) {
                if (TotalNumberOfDataBlocks <= 0 || RepetitionsInSingleDataBlock <= 0) break block9;
                String ExcepName = "Universe.edu.umn.space.swaves..extract.EVENT_INDEX_OUT_OF_BOUNDS";
                String ErrComment = "IndexOutOfBoundsException while trying to extract item: " + ItemName + "\n" + "AreaNumber                = " + AreaNumber + "\n" + "BitsFromStartOfArea                = " + BitsFromStartOfArea + "\n" + "LengthInBits                       = " + LengthInBits + "\n" + "BitsOffsetToNextElementInDataBlock = " + BitsOffsetToNextElementInDataBlock + "\n" + "RepetitionsInSingleDataBlock       = " + RepetitionsInSingleDataBlock + "\n" + "BitsOffsetToNextDataBlock          = " + BitsOffsetToNextDataBlock + "\n" + "TotalNumberOfDataBlocks            = " + TotalNumberOfDataBlocks + "\n" + "Event Buffer Limit                 = " + this.BufferToExtractBytesFrom.limit() + "\n" + "SignedPull                         = " + SignedPull + "\n";
                throw new GSEException(ErrComment, ExcepName);
            }
        }
    }

    private void IntegerNumberBytePull(int StartBit, int LengthInBits, int BitsOffsetToNextElementInDataBlock, int RepetitionsInSingleDataBlock, int BitsOffsetToNextDataBlock, int TotalNumberOfDataBlocks, int SignedPull, ByteBuffer OutBuf) throws IndexOutOfBoundsException {
        int numBytes = LengthInBits / 8;
        for (int NumBlocksPulled = 0; NumBlocksPulled != TotalNumberOfDataBlocks; ++NumBlocksPulled) {
            int BitPos = StartBit + BitsOffsetToNextDataBlock * NumBlocksPulled;
            for (int NumSubBlocksPulled = 0; NumSubBlocksPulled != RepetitionsInSingleDataBlock; ++NumSubBlocksPulled) {
                int byteVal = this.BufferToExtractBytesFrom.get(BitPos / 8);
                if (SignedPull == 0) {
                    byteVal &= 0xFF;
                }
                int outval = byteVal << 8 * (numBytes - 1);
                for (int i = 1; i < numBytes; ++i) {
                    byteVal = this.BufferToExtractBytesFrom.get(BitPos / 8 + i);
                    outval += (byteVal &= 0xFF) << 8 * (numBytes - 1 - i);
                }
                OutBuf.putInt(outval);
                BitPos += BitsOffsetToNextElementInDataBlock + LengthInBits;
            }
        }
    }

    private int nonEightpull(int firstBitInString, int length) {
        int output = 0;
        int lengthInByte = 0;
        int shift = 0;
        while (length > 0) {
            lengthInByte = 8 - firstBitInString % 8;
            if (lengthInByte > length) {
                lengthInByte = length;
            }
            output |= this.bitsFromInAByte(firstBitInString, lengthInByte) << shift;
            length -= lengthInByte;
            shift += lengthInByte;
            firstBitInString = firstBitInString / 8 * 8 - 8;
        }
        return output;
    }

    private int bitsFromInAByte(int firstBitInString, int length) {
        int mask = 0;
        int firstBitToPull = 8 - firstBitInString % 8 - length;
        int lastBitToPull = 8 - firstBitInString % 8;
        for (int bitSpot = firstBitToPull; bitSpot < lastBitToPull; ++bitSpot) {
            mask |= 128 >> bitSpot;
        }
        int outputValue = this.BufferToExtractBytesFrom.get(firstBitInString / 8);
        outputValue &= mask;
        int shifter = 8 - lastBitToPull;
        return outputValue >>= shifter;
    }
}

