/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser;

import java.util.Hashtable;

public class Token {
    static final int OP_ADD = 1;
    static final int OP_SUB = 2;
    static final int OP_MUL = 3;
    static final int OP_DIV = 4;
    static final int OP_EXP = 5;
    static final int OP_AND = 6;
    static final int OP_IOR = 7;
    static final int OP_XOR = 8;
    static final int OP_NOT = 9;
    static final int OP_EQ = 10;
    static final int OP_NE = 11;
    static final int OP_LT = 12;
    static final int OP_LE = 13;
    static final int OP_GT = 14;
    static final int OP_GE = 15;
    static final int OP_BAND = 16;
    static final int OP_BIOR = 17;
    static final int OP_BXOR = 18;
    static final int OP_BNOT = 19;
    static final int OP_NEG = 20;
    static final int OP_LEFTSHIFT = 21;
    static final int OP_RIGHTSHIFTZERO = 22;
    static final int OP_RIGHTSHIFTSIGN = 23;
    public static final String[] boolOps = new String[]{".and.", ".or.", ".xor.", ".not.", ".eq.", ".ge.", ".gt.", ".le.", ".lt.", ".ne."};
    public static final int[] boolTokens = new int[]{16, 17, 18, 19, 10, 15, 14, 13, 12, 11};
    public static final int SIN = 0;
    public static final int COS = 1;
    public static final int TAN = 2;
    public static final int ATAN = 3;
    public static final int SQRT = 4;
    public static final int MAX = 5;
    public static final int MIN = 6;
    public static final int ABS = 7;
    public static final int LOG = 8;
    public static final int SGN = 9;
    public static final int MOD = 10;
    public static final int SWDSP_AUTO = 11;
    public static final int SWDSP_CROSS = 12;
    public static final int UR8FROMDAQTIME = 13;
    public static final int UR8FROMCCSDSTIME = 14;
    public static final int SWDSP_UNFLOAT_AUTO_2DBS_V1 = 15;
    public static final int SIGNED_INT_2DBS_V1 = 16;
    public static final int POLY = 17;
    public static final int I4GEN = 18;
    public static final int R4GEN = 19;
    public static final int R8GEN = 20;
    public static final int I4VECTOR = 21;
    public static final int R4VECTOR = 22;
    public static final int R8VECTOR = 23;
    public static final int SWHFR_UNFLOAT_AUTO_2DBS_V1 = 24;
    public static final int SWDSP_UNFLOAT_CROSS_2MAGNITUDE_V1 = 25;
    public static final int SWLFR_UNFLOAT_AUTO_2DBS_V1 = 26;
    public static final int SWDSP_UNFLOAT_CROSS_2DEGREES_V1 = 27;
    public static final int CHECKSUM = 28;
    public static final int UR8FROMPTPTIME = 29;
    public static final int SWDSP_UNFLOAT_CROSS_2MAGNITUDE_DBS_V1 = 30;
    public static final int SWDSP_AGC_2DBS_V1 = 31;
    public static final int ASCII_FILE2I4 = 32;
    public static final int ASCII_FILE2R4 = 33;
    public static final int ASCII_FILE2R8 = 34;
    public static final int ASCII_FIND_DEPENDENT_VALUE_R4 = 35;
    public static final int ASCII_FIND_DEPENDENT_VALUE_R8 = 36;
    public static final int SWLFR_CAL_DBS_V1 = 37;
    public static final int SWHFR_CAL_DBS_V1 = 38;
    public static final int SWDSP_UNFLOAT_CROSS_2NORMAL_V1 = 39;
    public static final int SWDSP_UNFLOAT_AUTO_2MAGNITUDE_V1 = 40;
    public static final int SWDSP_UNFLOAT_CROSS_2MAGNITUDE_NORMAL_V1 = 41;
    public static final int SWDSP_UNFLOAT_AUTO_2NORMAL_V1 = 42;
    public static final int SWDSP_UNFLOAT_CROSS_2RADIANS_V1 = 43;
    public static final int SWDSP_CAL_CROSS_IMAG_V1 = 44;
    public static final int SWDSP_CAL_CROSS_REAL_V1 = 45;
    public static final int SWLFR_CAL_PHASE_V1 = 46;
    public static final int SWHFR_CAL_PHASE_V1 = 47;
    public static final int MAP_INDIRECT_V1 = 48;
    public static final int SWDSP_CAL_PHASE_V1 = 49;
    public static final int SWHFR_CAL_DBS_V2 = 50;
    public static final int TIME_SERIES2SPECTRUM_V1 = 51;
    public static final int TIME_SERIES2SPECTRUM_DBS_V1 = 52;
    public static final int UR8FROMSWDPUHKTIME = 53;
    public static final Hashtable<String, Integer> functions = new Hashtable();
    protected int type;
    public static final int SYMBOL = 0;
    public static final int CONSTANT = 1;
    public static final int FUNCTION = 2;
    public static final int OPERATOR = 4;
    public static final int ITEM = 5;
    public static final int ARGS = 6;
    protected double[] nValue;
    protected String sValue;
    protected String[] StringArrayValue;

    public Token(int t, double nv) {
        this.type = t;
        this.nValue = new double[1];
        this.nValue[0] = nv;
    }

    public Token(int t, String sv) {
        this.type = t;
        this.sValue = sv;
    }

    public Token(int t, int v) {
        this.type = t;
        this.nValue = new double[]{v};
    }

    public Token(int t, String sv, int iv) {
        this.type = t;
        this.sValue = sv;
        this.nValue = new double[]{iv};
    }

    public Token(int t, int[] v) {
        this.type = t;
        this.nValue = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.nValue[i] = v[i];
        }
    }

    public Token(int t, String[] inStringArrayValue) {
        this.type = t;
        this.StringArrayValue = inStringArrayValue;
    }

    public int[] numValue() {
        int[] returnval = new int[this.nValue.length];
        for (int i = 0; i < this.nValue.length; ++i) {
            returnval[i] = (int)this.nValue[i];
        }
        return returnval;
    }

    public float[] R4NumValue() {
        float[] returnval = new float[this.nValue.length];
        for (int i = 0; i < this.nValue.length; ++i) {
            returnval[i] = (float)this.nValue[i];
        }
        return returnval;
    }

    public double[] R8NumValue() {
        return this.nValue;
    }

    public String stringValue() {
        return this.sValue;
    }

    public String stringArrayValue(int index) {
        return this.StringArrayValue[index];
    }

    public String[] getStringArray() {
        return this.StringArrayValue;
    }

    public int typeNum() {
        return this.type;
    }

    public final boolean isSymbol(char s) {
        return this.typeNum() == 0 && this.numValue()[0] == s;
    }

    public final boolean isOp(int op) {
        return this.type == 4 && (int)this.nValue[0] == op;
    }

    public int getFunctionCodeInt() {
        return (int)this.nValue[0];
    }

    static {
        functions.put("sin", 0);
        functions.put("cos", 1);
        functions.put("tan", 2);
        functions.put("atan", 3);
        functions.put("sqrt", 4);
        functions.put("max", 5);
        functions.put("min", 6);
        functions.put("abs", 7);
        functions.put("log", 8);
        functions.put("sgn", 9);
        functions.put("mod", 10);
        functions.put("swdsp_unfloat_auto_v1", 11);
        functions.put("swdsp_unfloat_cross_v1", 12);
        functions.put("ur8fromdaqtime", 13);
        functions.put("ur8fromccsdstime", 14);
        functions.put("swdsp_unfloat_auto_2dbs_v1", 15);
        functions.put("signed_int_2dbs_v1", 16);
        functions.put("poly", 17);
        functions.put("i4gen", 18);
        functions.put("r4gen", 19);
        functions.put("r8gen", 20);
        functions.put("i4vector", 21);
        functions.put("r4vector", 22);
        functions.put("r8vector", 23);
        functions.put("swhfr_unfloat_auto_2dbs_v1", 24);
        functions.put("swdsp_unfloat_cross_2magnitude_v1", 25);
        functions.put("swlfr_unfloat_auto_2dbs_v1", 26);
        functions.put("swdsp_unfloat_cross_2degrees_v1", 27);
        functions.put("checksum", 28);
        functions.put("ur8fromptptime", 29);
        functions.put("swdsp_unfloat_cross_2magnitude_dbs_v1", 30);
        functions.put("swdsp_agc_2dbs_v1", 31);
        functions.put("ascii_file2i4", 32);
        functions.put("ascii_file2r4", 33);
        functions.put("ascii_file2r8", 34);
        functions.put("ascii_find_dependent_value_r4", 35);
        functions.put("ascii_find_dependent_value_r8", 36);
        functions.put("swlfr_cal_dbs_v1", 37);
        functions.put("swhfr_cal_dbs_v1", 38);
        functions.put("swdsp_unfloat_cross_2normal_v1", 39);
        functions.put("swdsp_unfloat_auto_2magnitude_v1", 40);
        functions.put("swdsp_unfloat_cross_2magnitude_normal_v1", 41);
        functions.put("swdsp_unfloat_cross_2magnitude_normal_v1", 41);
        functions.put("swdsp_unfloat_auto_2normal_v1", 42);
        functions.put("swdsp_unfloat_cross_2radians_v1", 43);
        functions.put("swdsp_cal_cross_imag_v1", 44);
        functions.put("swdsp_cal_cross_real_v1", 45);
        functions.put("swlfr_cal_phase_v1", 46);
        functions.put("swhfr_cal_phase_v1", 47);
        functions.put("map_indirect_v1", 48);
        functions.put("swdsp_cal_phase_v1", 49);
        functions.put("swhfr_cal_dbs_v2", 50);
        functions.put("time_series2spectrum_v1", 51);
        functions.put("time_series2spectrum_dbs_v1", 52);
        functions.put("ur8fromswdpuhktime", 53);
    }
}

