/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.StreamReposition;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionR8;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8generalExecutableExpression;
import edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.ColumnConversionRules.ColumnPullPlugin;
import edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.ReturnMode.ReturnModePlugin;
import java.nio.ByteBuffer;

public class R8executableExpression_ASCII_PULL
implements R8generalExecutableExpression {
    String ErrDBPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    private TMlibStream StreamObj = null;
    private StreamReposition JumpInStream = null;
    private ColumnPullPlugin DepColumn = null;
    private ReturnModePlugin ReturnMode = null;
    private String Indep_item_to_match = null;
    private ParseExpressionR8 R8Parse = null;
    protected ByteBuffer OnePacket = null;
    private Double Requested_Indep_Value;
    private Double Low_Indep_Var;
    protected Double Low_Dep_Var;
    private Double Hi_Indep_Var;
    protected Double Hi_Dep_Var;
    private boolean HitNaN;
    private int SearchDepth;

    public void setDepColPlugin(ColumnPullPlugin inDepColumn) {
        this.DepColumn = inDepColumn;
    }

    public void setStreamReposition(StreamReposition inJumpInStream) {
        this.JumpInStream = inJumpInStream;
    }

    public void setReturnMode(ReturnModePlugin inReturnMode) {
        this.ReturnMode = inReturnMode;
    }

    public void setIndep_item_to_match(String inIndep_item_to_match) {
        this.Indep_item_to_match = inIndep_item_to_match;
    }

    public void setR8Parse(ParseExpressionR8 inR8Parse) {
        this.R8Parse = inR8Parse;
    }

    public void setOnePacket(ByteBuffer inOnePacket) {
        this.OnePacket = inOnePacket;
    }

    public void setStreamObj(TMlibStream inStreamObj) {
        this.StreamObj = inStreamObj;
    }

    public void setSearchDepth(int inSearchDepth) {
        this.SearchDepth = inSearchDepth;
    }

    public double[] resolve() throws GSEException {
        this.getLowerBound();
        this.getHiBound();
        return this.findValueUsingReturnMode();
    }

    protected void getLowerBound() throws GSEException {
        this.Requested_Indep_Value = this.R8Parse.getItemDouble(this.Indep_item_to_match);
        this.JumpInStream.TM_Set_Position(this.Requested_Indep_Value);
        this.Low_Dep_Var = this.DepColumn.getColumnValue();
        this.HitNaN = false;
        if (Double.isNaN(this.Low_Dep_Var)) {
            this.HitNaN = true;
        }
        if (this.HitNaN) {
            this.JumpInStream.mark();
        }
        int numSteps = 1;
        while (Double.isNaN(this.Low_Dep_Var)) {
            this.OnePacket.clear();
            this.StreamObj.getLastRecord(this.OnePacket);
            this.Low_Dep_Var = this.DepColumn.getColumnValue();
            if (++numSteps <= this.SearchDepth) continue;
            String ExcepName = this.ErrDBPath + "COULD_NOT_FIND_DEPENDENT_VARIABLE_WITHIN_SEARCH_LIMIT";
            int ReportColumn = this.DepColumn.getColumnNumber() + 1;
            String ErrComment = "\nWhile looking for a match to the independent variable: " + this.Requested_Indep_Value + "\n" + " and after " + this.SearchDepth + " lines. " + "\n" + " No data could be found in column " + ReportColumn + "\n" + " of the file: " + "\n" + this.StreamObj.getStreamName();
            throw new GSEException(ErrComment, ExcepName);
        }
        this.Low_Indep_Var = this.JumpInStream.getStreamPosition();
    }

    protected void getHiBound() throws GSEException {
        if (this.HitNaN) {
            this.JumpInStream.reset();
        }
        this.Hi_Dep_Var = this.DepColumn.getColumnValue();
        this.StreamObj.getNextRecord(this.OnePacket);
        this.Hi_Dep_Var = this.DepColumn.getColumnValue();
        int numSteps = 1;
        while (Double.isNaN(this.Hi_Dep_Var)) {
            this.StreamObj.getNextRecord(this.OnePacket);
            this.Hi_Dep_Var = this.DepColumn.getColumnValue();
            if (++numSteps <= this.SearchDepth) continue;
            String ExcepName = this.ErrDBPath + "COULD_NOT_FIND_DEPENDENT_VARIABLE_WITHIN_SEARCH_LIMIT";
            int ReportColumn = this.DepColumn.getColumnNumber() + 1;
            String ErrComment = "\nWhile looking for a match to the independent variable: " + this.Requested_Indep_Value + "\n" + " and after " + this.SearchDepth + " lines. " + "\n" + " No data could be found in column " + ReportColumn + "\n" + " of the file: " + "\n" + this.StreamObj.getStreamName();
            throw new GSEException(ErrComment, ExcepName);
        }
        this.Hi_Indep_Var = this.JumpInStream.getStreamPosition();
    }

    protected double[] findValueUsingReturnMode() throws GSEException {
        double ans = this.ReturnMode.extractValue(this.Requested_Indep_Value, this.Hi_Indep_Var, this.Low_Indep_Var, this.Hi_Dep_Var, this.Low_Dep_Var);
        LogClient.log(TMlibLogLevel.Stream_Low, "In ASCII_PULL  \nLow_Indep_Var:  " + this.Low_Indep_Var + "\n" + "Low_Dep_Var:    " + this.Low_Dep_Var + "\n" + "Hi_Indep_Var:   " + this.Hi_Indep_Var + "\n" + "Hi_Dep_Var:     " + this.Hi_Dep_Var + "\n" + "ans:            " + ans);
        double[] returnval = new double[]{ans};
        return returnval;
    }
}

