/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.FilesSpec;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionChar;
import edu.umn.space.swaves.util.xml.SearchConfigFileList;
import java.io.File;

public class FileTypeSelector {
    private static final String[] PossibleFileSpecs = new String[]{"SAPL_Ancillary_Filename_HGA", "SAPL_Ancillary_Filename_SC_HK"};
    private static final String[] PossibleSubDirNames = new String[]{"HGA", "spacecraft_HK"};
    private static final String ErrDBPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    private static final String Sep = File.separator;
    private static final String StreamFamilyFackage = "edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins";

    public static StreamProperties pickFileType(String RequestFileSpec, ParseExpressionChar CharParser) throws GSEException {
        int MatchedIndex = -1;
        StreamProperties OutputFileType = null;
        for (int i = 0; i < PossibleFileSpecs.length; ++i) {
            if (!RequestFileSpec.equalsIgnoreCase(PossibleFileSpecs[i])) continue;
            MatchedIndex = i;
            break;
        }
        if (MatchedIndex == -1) {
            String ErrorMessage = "The user selected an invalid filespec \n";
            ErrorMessage = ErrorMessage + "The string: \"" + RequestFileSpec + "\" is not allowed\n";
            ErrorMessage = ErrorMessage + "Possible valid filespecs are: \n";
            for (int i = 0; i < PossibleFileSpecs.length; ++i) {
                int count = i + 1;
                ErrorMessage = ErrorMessage + " " + count + ")  " + PossibleFileSpecs[i] + "\n";
            }
            throw new GSEException(ErrorMessage, "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.INVALID_FILESPEC");
        }
        String ClassName = PossibleFileSpecs[MatchedIndex] + "_StreamProperties";
        try {
            Class<?> FileTypeAsClass = Class.forName("edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins." + ClassName);
            OutputFileType = (StreamProperties)FileTypeAsClass.newInstance();
            String PATH = FileTypeSelector.makePathToFiles(CharParser) + Sep + PossibleSubDirNames[MatchedIndex];
            OutputFileType.setFileDirectory(PATH);
        }
        catch (Exception ee) {
            String ErrorMessage = "Plugin could not be created. \n";
            ErrorMessage = ErrorMessage + "For the class: \"" + ClassName + "\" \n";
            ErrorMessage = ErrorMessage + "In the package: \"edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins\" \n";
            throw new GSEException(ErrorMessage, "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.PLUGIN_CREATION_FAILED");
        }
        return OutputFileType;
    }

    private static String makePathToFiles(ParseExpressionChar CharParser) throws GSEException {
        String Domain_Mission = CharParser.ParseDBAsString("Domain_Mission");
        SearchConfigFileList ConfigFiles = new SearchConfigFileList();
        String ROOT_DIR = ConfigFiles.getANCILLARY_ROOT(Domain_Mission);
        String Domain_Spacecraft = FileTypeSelector.getAheadOrBehind(CharParser);
        return ROOT_DIR + Sep + Domain_Mission + Sep + Domain_Spacecraft;
    }

    private static String getAheadOrBehind(ParseExpressionChar CharParser) throws GSEException {
        String Domain_Spacecraft = CharParser.ParseDBAsString("Domain_Spacecraft");
        if (Domain_Spacecraft.equalsIgnoreCase("stereo_a")) {
            Domain_Spacecraft = "ahead";
        } else if (Domain_Spacecraft.equalsIgnoreCase("stereo_b")) {
            Domain_Spacecraft = "behind";
        }
        return Domain_Spacecraft;
    }
}

