/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.ColumnConversionRules;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.ColumnConversionRules.ColumnPullPlugin;
import edu.umn.space.swaves.util.Conversions.DateTimeConversions;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SAPL_TIMESTAMP2UR8_ColumnPullPlugin
implements ColumnPullPlugin {
    String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    private String FieldDelimiter;
    private ByteBuffer OnePacket;
    private int ColumnNumber;
    private static final CharsetDecoder AsciiDecoder = Charset.forName("US-ASCII").newDecoder();
    DateTimeConversions DateConvert = new DateTimeConversions(1982, 0, 0, 0, 0, 0, 0);
    private static final Pattern HGA_Time_Regex = Pattern.compile("(\\d{4}):([0-2]\\d{2}|3[0-5]\\d|36[0-5]):([0-1]\\d|2[0-3]):([0-5]\\d):([0-5]\\d)\\.(\\d{3})");

    public void setColumnNumber(int inColumnNumber) {
        this.ColumnNumber = inColumnNumber - 1;
    }

    public int getColumnNumber() {
        return this.ColumnNumber;
    }

    public void setOnePacket(ByteBuffer inOnePacket) {
        this.OnePacket = inOnePacket;
    }

    public double getColumnValue() throws GSEException {
        Double UR8FromFile = 0.0;
        String LineOfFile = null;
        try {
            this.OnePacket.position(0);
            LineOfFile = AsciiDecoder.decode(this.OnePacket).toString();
            String[] ElementsInALine = LineOfFile.split(this.FieldDelimiter);
            String DateAsString = ElementsInALine[this.ColumnNumber];
            Matcher HGAmatcher = HGA_Time_Regex.matcher(DateAsString);
            if (!HGAmatcher.find()) {
                String ExcepName = this.ErrPath + "SUB_STRING_NOT_DATEFORMAT";
                String ErrComment = "In the line   : " + LineOfFile + "\n" + "The substring : " + DateAsString + "\n" + "is not a proper date";
                throw new GSEException(ErrComment, ExcepName);
            }
            int YYYY = Integer.valueOf(HGAmatcher.group(1), 10);
            int DOY = Integer.valueOf(HGAmatcher.group(2), 10);
            int HH = Integer.valueOf(HGAmatcher.group(3), 10);
            int MM = Integer.valueOf(HGAmatcher.group(4), 10);
            int SS = Integer.valueOf(HGAmatcher.group(5), 10);
            int TTT = Integer.valueOf(HGAmatcher.group(6), 10);
            this.DateConvert.set(1, YYYY);
            this.DateConvert.set(6, DOY);
            this.DateConvert.set(11, HH);
            this.DateConvert.set(12, MM);
            this.DateConvert.set(13, SS);
            this.DateConvert.set(14, TTT);
            UR8FromFile = this.DateConvert.getUR8Time();
        }
        catch (CharacterCodingException ee) {
            String ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_FILE";
            String ErrComment = "In the line   : " + LineOfFile + "\n" + "Contains a non -ASCII character";
            throw new GSEException(ErrComment, ExcepName);
        }
        return UR8FromFile;
    }

    public boolean isValidColumn(String CanidateTimeStamp) {
        boolean GoodTimeStamp = true;
        try {
            String[] ElementsInALine = CanidateTimeStamp.split(this.FieldDelimiter);
            String DateAsString = ElementsInALine[this.ColumnNumber];
            Matcher HGAmatcher = HGA_Time_Regex.matcher(DateAsString);
            if (!HGAmatcher.find()) {
                GoodTimeStamp = false;
            }
        }
        catch (Exception ee) {
            GoodTimeStamp = false;
        }
        return GoodTimeStamp;
    }

    public void setFieldDelimiter(String inFieldDelimiter) {
        this.FieldDelimiter = inFieldDelimiter;
    }
}

