/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.ItemDefinitionObject;
import edu.umn.space.swaves.stereoLib.item.itemparser.I4args;
import edu.umn.space.swaves.stereoLib.item.itemparser.LexicalTokenizer;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpression;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionChar;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionR4;
import edu.umn.space.swaves.stereoLib.item.itemparser.R4executableExpression.R4generalExecutableExpression;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionABS;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionADD;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionASCII_File2R8;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionATAN;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionBAND;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionBIOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionBXOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionCOS;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionConstant;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionDIV;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionEQ;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionEXP;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionGE;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionGT;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionLE;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionLOG;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionLT;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionMAX;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionMUL;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionNE;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionNEG;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionPoly;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionR8Gen;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionR8Vector;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionSIN;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionSQRT;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionSUB;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionTAN;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionUR8fromCCSDStime;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionUR8fromDAQtime;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionUR8fromPTPtime;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8executableExpressionUR8fromSWDPUHKtime;
import edu.umn.space.swaves.stereoLib.item.itemparser.R8executableExpression.R8generalExecutableExpression;
import edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.ASCII_Reader_Factory;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionChecksum;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.generalExecutableExpression;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;

public class ParseExpressionR8 {
    String ErrDBPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    ItemDB ItemDataBase;
    ParseExpressionR4 R4Parse;
    ParseExpression I4Parse;
    private LinkedList ArgsList = new LinkedList();
    private ParseExpressionChar CharParser;

    public void setItemDB(ItemDB inItemDataBase) {
        this.ItemDataBase = inItemDataBase;
    }

    public void setI4Parser(ParseExpression inI4Parse) {
        this.I4Parse = inI4Parse;
    }

    public void setR4Parser(ParseExpressionR4 inR4Parse) {
        this.R4Parse = inR4Parse;
    }

    public void setCharParser(ParseExpressionChar inCharParser) {
        this.CharParser = inCharParser;
    }

    private void getArgs(LinkedList theArgs, LexicalTokenizer lt) throws GSEException {
        theArgs.clear();
        theArgs.add(this.expression(lt));
        while (lt.CurrentToken.isSymbol(',')) {
            theArgs.add(this.expression(lt));
        }
    }

    private R8generalExecutableExpression parseFunctionPluginArgs(LexicalTokenizer lt, HashMap PluginArgs) throws GSEException {
        R8generalExecutableExpression result = null;
        int ty = lt.CurrentToken.getFunctionCodeInt();
        String name = lt.CurrentToken.stringValue();
        lt.nextToken();
        switch (ty) {
            case 36: {
                ASCII_Reader_Factory FileSelector = ASCII_Reader_Factory.newASCII_Reader_Factory(this.I4Parse, this, this.CharParser);
                result = FileSelector.pickR8FileItem(PluginArgs);
                break;
            }
            default: {
                throw new GSEException(name + " is not a R8 function ", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
        }
        return result;
    }

    private R8generalExecutableExpression parseFunction(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = null;
        int ty = lt.CurrentToken.getFunctionCodeInt();
        String name = lt.CurrentToken.stringValue();
        lt.nextToken();
        switch (ty) {
            case 0: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionSIN(a);
                break;
            }
            case 1: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionCOS(a);
                break;
            }
            case 2: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionTAN(a);
                break;
            }
            case 3: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionATAN(a);
                break;
            }
            case 4: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionSQRT(a);
                break;
            }
            case 7: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionABS(a);
                break;
            }
            case 8: {
                R8generalExecutableExpression a = this.expression(lt);
                result = new R8executableExpressionLOG(a);
                break;
            }
            case 5: {
                R8generalExecutableExpression a = this.expression(lt);
                R8generalExecutableExpression b = this.expression(lt);
                result = new R8executableExpressionMAX(a, b);
                break;
            }
            case 6: {
                R8generalExecutableExpression a = this.expression(lt);
                R8generalExecutableExpression b = this.expression(lt);
                result = new R8executableExpressionMAX(a, b);
                break;
            }
            case 13: {
                R8generalExecutableExpression a = this.expression(lt);
                R8generalExecutableExpression b = this.expression(lt);
                result = new R8executableExpressionUR8fromDAQtime(a, b);
                break;
            }
            case 29: {
                R8generalExecutableExpression a = this.expression(lt);
                R8generalExecutableExpression b = this.expression(lt);
                R8generalExecutableExpression c = this.expression(lt);
                result = new R8executableExpressionUR8fromPTPtime(a, b, c);
                break;
            }
            case 14: {
                generalExecutableExpression SecSinc1958 = this.I4Parse.expression(lt);
                generalExecutableExpression FractSec = this.I4Parse.expression(lt);
                result = new R8executableExpressionUR8fromCCSDStime(SecSinc1958, FractSec);
                break;
            }
            case 53: {
                generalExecutableExpression SecSinc1958 = this.I4Parse.expression(lt);
                generalExecutableExpression FractSec = this.I4Parse.expression(lt);
                result = new R8executableExpressionUR8fromSWDPUHKtime(SecSinc1958, FractSec);
                break;
            }
            case 28: {
                executableExpressionChecksum CKsum = new executableExpressionChecksum();
                CKsum.ArgsList = I4args.createI4args(this.I4Parse, lt);
                int[] intArr = CKsum.resolve();
                double[] constArray = new double[intArr.length];
                for (int i = 0; i < intArr.length; ++i) {
                    constArray[i] = intArr[i];
                }
                result = new R8executableExpressionConstant(constArray);
                break;
            }
            case 17: {
                R8executableExpressionPoly Poly = new R8executableExpressionPoly();
                this.getArgs(Poly.ArgsList, lt);
                result = Poly;
                break;
            }
            case 23: {
                R8executableExpressionR8Vector R8Vect = new R8executableExpressionR8Vector();
                this.getArgs(R8Vect.ArgsList, lt);
                result = R8Vect;
                break;
            }
            case 20: {
                R8executableExpressionR8Gen R8gen = new R8executableExpressionR8Gen();
                this.getArgs(R8gen.ArgsList, lt);
                result = R8gen;
                break;
            }
            case 34: {
                lt.getArgs();
                String ItemName = lt.CurrentToken.stringArrayValue(0).trim();
                String Path2 = this.ItemDataBase.getValidItemDefObj(ItemName).getXMLFileCommonPath();
                Path2 = Path2 + File.separator + this.CharParser.ParseDBAsString(ItemName);
                generalExecutableExpression skip = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(1));
                generalExecutableExpression istart = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(2));
                generalExecutableExpression istep = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(3));
                generalExecutableExpression NumLoops = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(4));
                generalExecutableExpression NumInner = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(5));
                generalExecutableExpression NumOuter = this.I4Parse.ParseDB(lt.CurrentToken.stringArrayValue(6));
                result = new R8executableExpressionASCII_File2R8(Path2, this.CharParser, skip, istart, istep, NumLoops, NumInner, NumOuter);
                break;
            }
            default: {
                throw new GSEException(name + " is not a Double function ", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
        }
        return result;
    }

    private R8generalExecutableExpression element(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = null;
        if (lt.CurrentToken.isSymbol('(')) {
            result = this.expression(lt);
            if (!lt.CurrentToken.isSymbol(')') && !lt.hasMoreTokens()) {
                throw new GSEException(" mismatched parentheses in expression", this.ErrDBPath + "EXPRESSION_MISMATCHED_PARENTHESES");
            }
        } else if (lt.CurrentToken.typeNum() == 1) {
            result = new R8executableExpressionConstant(lt.CurrentToken.R8NumValue());
        } else if (lt.CurrentToken.typeNum() == 2) {
            result = this.parseFunction(lt);
        } else if (lt.CurrentToken.typeNum() == 5) {
            ItemDefinitionObject ItemDefObj = this.ItemDataBase.getValidItemDefObj(lt.CurrentToken.stringValue().trim());
            if (ItemDefObj.getDataType() == 1) {
                generalExecutableExpression IntExecutableExpression = this.I4Parse.ParseDB(ItemDefObj.getNameOfItem());
                int[] intArr = IntExecutableExpression.resolve();
                double[] constArray = new double[intArr.length];
                for (int i = 0; i < intArr.length; ++i) {
                    constArray[i] = intArr[i];
                }
                result = new R8executableExpressionConstant(constArray);
            } else if (ItemDefObj.getDataType() == 2) {
                R4generalExecutableExpression FltExecutableExpression = this.R4Parse.ParseDB(ItemDefObj.getNameOfItem());
                float[] fltArr = FltExecutableExpression.resolve();
                double[] constArray = new double[fltArr.length];
                for (int i = 0; i < fltArr.length; ++i) {
                    constArray[i] = fltArr[i];
                }
                result = new R8executableExpressionConstant(constArray);
            } else {
                if (ItemDefObj.getDataType() == 4) {
                    throw new GSEException("The item \"" + lt.CurrentToken.stringValue() + "\" is type char and cannot be converted to a double", this.ErrDBPath + "CHAR_CANNOT_BE_CONVERTED_TO_DOUBLE");
                }
                if (ItemDefObj.isPluginArgsPresent()) {
                    LexicalTokenizer newlt = new LexicalTokenizer(ItemDefObj.getStrNonExtractCase().trim());
                    newlt.nextToken();
                    result = this.parseFunctionPluginArgs(newlt, ItemDefObj.getPluginArgs());
                } else {
                    result = this.ParseDB(ItemDefObj.getStrNonExtractCase());
                }
            }
        } else {
            throw new GSEException(" unexpected symbol ", this.ErrDBPath + "EXPRESSION_UNEXPECTED_SYMBOL");
        }
        return result;
    }

    private R8generalExecutableExpression primary(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result;
        lt.nextToken();
        if (lt.CurrentToken.isOp(2)) {
            result = new R8executableExpressionNEG(this.primary(lt));
        } else {
            if (lt.CurrentToken.isOp(19)) {
                throw new GSEException("BNOT not allowed for float", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
            result = this.element(lt);
        }
        return result;
    }

    private R8generalExecutableExpression factor(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.primary(lt);
        if (lt.hasMoreTokens()) {
            lt.nextToken();
            if (lt.CurrentToken.isOp(5)) {
                result = new R8executableExpressionEXP(result, this.factor(lt));
            }
        }
        return result;
    }

    private R8generalExecutableExpression term(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.factor(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(3)) {
                result = new R8executableExpressionMUL(result, this.factor(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(4)) break;
            result = new R8executableExpressionDIV(result, this.factor(lt));
        }
        return result;
    }

    private R8generalExecutableExpression sum(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.term(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(1)) {
                result = new R8executableExpressionADD(result, this.term(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(2)) break;
            result = new R8executableExpressionSUB(result, this.term(lt));
        }
        return result;
    }

    private R8generalExecutableExpression shift(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.sum(lt);
        if (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(21)) {
                throw new GSEException(" LEFTSHIFT not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
            if (lt.CurrentToken.isOp(22)) {
                throw new GSEException(" RIGHTSHIFTZERO not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
            if (lt.CurrentToken.isOp(23)) {
                throw new GSEException(" RIGHTSHIFTSIGN not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
        }
        return result;
    }

    private R8generalExecutableExpression relation(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.shift(lt);
        if (lt.hasMoreTokens() && lt.CurrentToken.typeNum() == 4) {
            switch (lt.CurrentToken.getFunctionCodeInt()) {
                case 10: {
                    result = new R8executableExpressionEQ(result, this.shift(lt));
                    break;
                }
                case 11: {
                    result = new R8executableExpressionNE(result, this.shift(lt));
                    break;
                }
                case 12: {
                    result = new R8executableExpressionLT(result, this.shift(lt));
                    break;
                }
                case 13: {
                    result = new R8executableExpressionLE(result, this.shift(lt));
                    break;
                }
                case 14: {
                    result = new R8executableExpressionGT(result, this.shift(lt));
                    break;
                }
                case 15: {
                    result = new R8executableExpressionGE(result, this.shift(lt));
                }
            }
        }
        return result;
    }

    private R8generalExecutableExpression logic(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = this.relation(lt);
        if (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(6)) {
                throw new GSEException(" AND not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
            if (lt.CurrentToken.isOp(8)) {
                throw new GSEException(" XOR not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
            if (lt.CurrentToken.isOp(7)) {
                throw new GSEException(" IOR not allowed for R8", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_R8");
            }
        }
        return result;
    }

    public R8generalExecutableExpression expression(LexicalTokenizer lt) throws GSEException {
        R8generalExecutableExpression result = null;
        result = this.logic(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(16)) {
                result = new R8executableExpressionBAND(result, this.logic(lt));
                continue;
            }
            if (lt.CurrentToken.isOp(17)) {
                result = new R8executableExpressionBIOR(result, this.logic(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(18)) break;
            result = new R8executableExpressionBXOR(result, this.logic(lt));
        }
        return result;
    }

    public R8generalExecutableExpression ParseDB(String stringToParse) throws GSEException {
        LogClient.log(TMlibLogLevel.Item_Low, "Entering R8 parse.  Item name " + stringToParse);
        LexicalTokenizer lt = new LexicalTokenizer(stringToParse.trim());
        return this.expression(lt);
    }

    public void ParseDB(String stringToParse, ByteBuffer ByteBuffShipToClient) throws GSEException {
        R8generalExecutableExpression result = this.ParseDB(stringToParse);
        double[] output = result.resolve();
        ByteBuffShipToClient.putInt(8 * output.length + 4);
        ByteBuffShipToClient.putInt(0);
        for (int i = 0; i < output.length; ++i) {
            ByteBuffShipToClient.putDouble(output[i]);
        }
    }

    public double getItemDouble(String StrToParse) throws GSEException {
        R8generalExecutableExpression DblExecutable = this.ParseDB(StrToParse);
        return DblExecutable.resolve()[0];
    }
}

