/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.ItemDefinitionObject;
import edu.umn.space.swaves.stereoLib.item.TMlibAreaDataBuffers;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpression;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionR4;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionR8;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class ParseExpressionChar {
    private String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    private ItemDB ItemDataBase;
    private String ExcepName;
    private String ErrComment;
    private ParseExpression I4Parse;
    private ParseExpressionR4 R4Parse;
    private ParseExpressionR8 R8Parse;
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private CharsetEncoder AsciiEncoder = this.AsciiCharset.newEncoder();
    private CharsetDecoder AsciiDecoder = this.AsciiCharset.newDecoder();
    private TMlibAreaDataBuffers AreaBuffers;
    private ByteBuffer CharItem = ByteBuffer.allocate(120);

    public void setItemDB(ItemDB inItemDataBase) {
        this.ItemDataBase = inItemDataBase;
    }

    public void setI4Parser(ParseExpression inI4Parse) {
        this.I4Parse = inI4Parse;
    }

    public void setR4Parser(ParseExpressionR4 inR4Parse) {
        this.R4Parse = inR4Parse;
    }

    public void setR8Parser(ParseExpressionR8 inR8Parse) {
        this.R8Parse = inR8Parse;
    }

    public void setAreaBuffers(TMlibAreaDataBuffers inAreaBuffers) {
        this.AreaBuffers = inAreaBuffers;
    }

    public String ParseDBAsString(String ItemName) throws GSEException {
        String OutString = null;
        this.CharItem.position(0);
        this.CharItem.limit(0);
        this.ParseDB(ItemName, this.CharItem);
        this.CharItem.position(8);
        this.CharItem.limit(this.CharItem.getInt(0) + 4);
        try {
            OutString = this.AsciiDecoder.decode(this.CharItem).toString();
        }
        catch (CharacterCodingException e) {
            this.ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_FIXED_STRING";
            this.ErrComment = "";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return OutString;
    }

    public void ParseDB(String ItemName, ByteBuffer ByteBuffShipToClient) throws GSEException {
        ItemDefinitionObject CharItem = this.ItemDataBase.getValidItemDefObj(ItemName);
        boolean CompositeFound = this.processCompositeItem(CharItem, ByteBuffShipToClient);
        if (!CompositeFound) {
            if (CharItem.getDataType() == 4) {
                this.processAsPureChar(CharItem, ByteBuffShipToClient);
            } else if (CharItem.isXLATE_Present()) {
                this.processCharAsXlate(ItemName, ByteBuffShipToClient, CharItem);
            } else if (CharItem.isFormat_Present()) {
                this.processCharWithFormat(ItemName, ByteBuffShipToClient, CharItem);
            } else {
                this.processCharWithDefault(ItemName, ByteBuffShipToClient, CharItem);
            }
        }
    }

    private boolean processCompositeItem(ItemDefinitionObject CharItem, ByteBuffer ByteBuffShipToClient) throws GSEException {
        boolean ItemIsCompositeChar = false;
        if (CharItem.getItemType() == 2 && CharItem.getDataType() == 4 && CharItem.getStringValue() == null) {
            String CompositeItem = CharItem.getStrNonExtractCase();
            String[] BrokenString = CompositeItem.split("\\s+\\+\\s+");
            ByteBuffShipToClient.position(0);
            ByteBuffShipToClient.putInt(4);
            ByteBuffShipToClient.putInt(0);
            ItemIsCompositeChar = true;
            for (int i = 0; i < BrokenString.length; ++i) {
                this.insertOneItem(BrokenString[i], ByteBuffShipToClient);
            }
        }
        return ItemIsCompositeChar;
    }

    private void insertOneItem(String ItemName, ByteBuffer ByteBuffShipToClient) throws GSEException {
        ByteBuffer Buff1 = ByteBuffer.allocate(300);
        ParseExpressionChar FirstItemParse = new ParseExpressionChar();
        FirstItemParse.setItemDB(this.ItemDataBase);
        FirstItemParse.setI4Parser(this.I4Parse);
        FirstItemParse.setR4Parser(this.R4Parse);
        FirstItemParse.setR8Parser(this.R8Parse);
        FirstItemParse.setAreaBuffers(this.AreaBuffers);
        FirstItemParse.ParseDB(ItemName, Buff1);
        int BuffSz1 = Buff1.getInt(0);
        int oldBufferSize = ByteBuffShipToClient.getInt(0);
        int newBufferSize = BuffSz1 + oldBufferSize - 4;
        ByteBuffShipToClient.position(0);
        ByteBuffShipToClient.putInt(newBufferSize);
        ByteBuffShipToClient.position(oldBufferSize + 4);
        ByteBuffShipToClient.limit(ByteBuffShipToClient.capacity());
        Buff1.position(8);
        Buff1.limit(BuffSz1 + 4);
        ByteBuffShipToClient.put(Buff1);
    }

    private void processAsPureChar(ItemDefinitionObject CharItem, ByteBuffer ByteBuffShipToClient) throws GSEException {
        if (CharItem.getItemType() == 1) {
            int AreaStart = this.I4Parse.getItemInt(CharItem.getStrArea());
            int BytesOffsetAreaStart = this.I4Parse.getItemInt(CharItem.getStrBitsOffsetFromStartOfArea()) / 8;
            int LengthInBytes = this.I4Parse.getItemInt(CharItem.getStrLengthInBits()) / 8;
            ByteBuffer AreaToExtract = this.AreaBuffers.getAreaBuffer(AreaStart);
            if (AreaStart < 0) {
                AreaStart = 0;
            }
            int FirstSlice = AreaStart + BytesOffsetAreaStart;
            int SecondSlice = FirstSlice + LengthInBytes;
            AreaToExtract.limit(SecondSlice);
            AreaToExtract.position(FirstSlice);
            String ExtractString = null;
            try {
                ExtractString = this.AsciiDecoder.decode(AreaToExtract).toString();
                ExtractString = ExtractString.trim();
                ByteBuffer bbuf = this.AsciiEncoder.encode(CharBuffer.wrap(ExtractString));
                ByteBuffShipToClient.clear();
                ByteBuffShipToClient.putInt(bbuf.limit() + 4);
                ByteBuffShipToClient.putInt(0);
                ByteBuffShipToClient.put(bbuf);
            }
            catch (CharacterCodingException e) {
                this.ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_FIXED_STRING";
                this.ErrComment = "The XLATE string has a non-asscii char for the item " + ExtractString;
                throw new GSEException(this.ErrComment, this.ExcepName);
            }
        }
        if (CharItem.getStringValue() != null) {
            String StringValue = CharItem.getStringValue();
            try {
                ByteBuffer bbuf = this.AsciiEncoder.encode(CharBuffer.wrap(StringValue));
                ByteBuffShipToClient.clear();
                ByteBuffShipToClient.putInt(bbuf.limit() + 4);
                ByteBuffShipToClient.putInt(0);
                ByteBuffShipToClient.put(bbuf);
            }
            catch (CharacterCodingException e) {
                this.ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_FIXED_STRING";
                this.ErrComment = "The  string has a non-asscii char for the item " + StringValue;
                throw new GSEException(this.ErrComment, this.ExcepName);
            }
        }
        String FixedValue = CharItem.getStrNonExtractCase();
        try {
            ByteBuffer bbuf = this.AsciiEncoder.encode(CharBuffer.wrap(FixedValue));
            ByteBuffShipToClient.clear();
            ByteBuffShipToClient.putInt(bbuf.limit() + 4);
            ByteBuffShipToClient.putInt(0);
            ByteBuffShipToClient.put(bbuf);
        }
        catch (CharacterCodingException e) {
            this.ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_FIXED_STRING";
            this.ErrComment = "The XLATE string has a non-asscii char for the item " + FixedValue;
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
    }

    private void processCharAsXlate(String ItemName, ByteBuffer ByteBuffShipToClient, ItemDefinitionObject CharItem) throws GSEException {
        ByteBuffShipToClient.clear();
        this.I4Parse.ParseDB(ItemName, ByteBuffShipToClient);
        int XlateValue = ByteBuffShipToClient.getInt(8);
        ByteBuffer CharAsByteBuffer = CharItem.pullXlate(XlateValue);
        ByteBuffShipToClient.clear();
        CharAsByteBuffer.position(0);
        CharAsByteBuffer.limit(CharAsByteBuffer.capacity());
        ByteBuffShipToClient.putInt(CharAsByteBuffer.limit() + 4);
        ByteBuffShipToClient.putInt(0);
        ByteBuffShipToClient.put(CharAsByteBuffer);
    }

    private void processCharWithFormat(String ItemName, ByteBuffer ByteBuffShipToClient, ItemDefinitionObject CharItem) throws GSEException {
        String FormattedOut = null;
        String PrintfFormat = CharItem.getFormat();
        switch (CharItem.getDataType()) {
            case 1: {
                this.I4Parse.ParseDB(ItemName, ByteBuffShipToClient);
                int IntToFormat = ByteBuffShipToClient.getInt(8);
                FormattedOut = String.format(PrintfFormat, IntToFormat);
                break;
            }
            case 2: {
                this.R4Parse.ParseDB(ItemName, ByteBuffShipToClient);
                float floatToFormat = ByteBuffShipToClient.getFloat(8);
                FormattedOut = String.format(PrintfFormat, Float.valueOf(floatToFormat));
                break;
            }
            case 3: {
                this.R8Parse.ParseDB(ItemName, ByteBuffShipToClient);
                double doubleToFormat = ByteBuffShipToClient.getDouble(8);
                FormattedOut = String.format(PrintfFormat, doubleToFormat);
                break;
            }
        }
        try {
            ByteBuffShipToClient.clear();
            ByteBuffer FormatByteBuff = this.AsciiEncoder.encode(CharBuffer.wrap(FormattedOut));
            ByteBuffShipToClient.putInt(FormatByteBuff.limit() + 4);
            ByteBuffShipToClient.putInt(0);
            ByteBuffShipToClient.put(FormatByteBuff);
        }
        catch (CharacterCodingException e) {
            String ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_XLATE";
            String ErrComment = "The XLATE string has a non-asscii char for the item " + ItemName;
            throw new GSEException(ErrComment, ExcepName);
        }
    }

    private void processCharWithDefault(String ItemName, ByteBuffer ByteBuffShipToClient, ItemDefinitionObject CharItem) throws GSEException {
        String FormattedOut = null;
        String PrintfFormat = CharItem.getFormat();
        switch (CharItem.getDataType()) {
            case 1: {
                this.I4Parse.ParseDB(ItemName, ByteBuffShipToClient);
                int IntToFormat = ByteBuffShipToClient.getInt(8);
                FormattedOut = String.format("%d", IntToFormat);
                break;
            }
            case 2: {
                this.R4Parse.ParseDB(ItemName, ByteBuffShipToClient);
                float floatToFormat = ByteBuffShipToClient.getFloat(8);
                FormattedOut = String.format("%f", Float.valueOf(floatToFormat));
                break;
            }
            case 3: {
                this.R8Parse.ParseDB(ItemName, ByteBuffShipToClient);
                double doubleToFormat = ByteBuffShipToClient.getDouble(8);
                FormattedOut = String.format("%f", doubleToFormat);
                break;
            }
        }
        try {
            ByteBuffShipToClient.clear();
            ByteBuffer FormatByteBuff = this.AsciiEncoder.encode(CharBuffer.wrap(FormattedOut));
            ByteBuffShipToClient.putInt(FormatByteBuff.limit() + 4);
            ByteBuffShipToClient.putInt(0);
            ByteBuffShipToClient.put(FormatByteBuff);
        }
        catch (CharacterCodingException e) {
            String ExcepName = this.ErrPath + "NON_ASCII_CHAR_IN_XLATE";
            String ErrComment = "The XLATE string has a non-asscii char for the item " + ItemName;
            throw new GSEException(ErrComment, ExcepName);
        }
    }
}

