/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.ItemDefinitionObject;
import edu.umn.space.swaves.stereoLib.item.TMlibAreaDataBuffers;
import edu.umn.space.swaves.stereoLib.item.itemparser.I4args;
import edu.umn.space.swaves.stereoLib.item.itemparser.LexicalTokenizer;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpressionChar;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.SWDSP_UnFloat_Auto_V1_Executable;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.SWDSP_UnFloat_Cross_V1_Executable;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionADD;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionAND;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionASCII_File2I4;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionBAND;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionBIOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionBNOT;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionBXOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionChecksum;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionConstant;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionDIV;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionEQ;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionEXP;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionGE;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionGT;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionI4Vector;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionI4gen;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionIOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionItemExtract;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionLE;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionLEFTSHIFT;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionLT;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionMAX;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionMIN;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionMOD;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionMUL;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionNE;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionNEG;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionNOT;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionPoly;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionRIGHTSHIFTSIGN;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionRIGHTSHIFTZERO;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionSUB;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpressionXOR;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.executableExpression_SWDSP_UnFloat_Cross_2magnitude_V1;
import edu.umn.space.swaves.stereoLib.item.itemparser.executableExpression.generalExecutableExpression;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class ParseExpression {
    String ErrDBPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    ItemDB ItemDataBase;
    private TMlibAreaDataBuffers EventData;
    private HashMap I4_Cache = new HashMap();
    private ParseExpressionChar CharParser;
    private HashMap ItemSeenBefore = new HashMap();

    public void setItemDB(ItemDB inItemDataBase) {
        this.ItemDataBase = inItemDataBase;
    }

    public void setCharParser(ParseExpressionChar inCharParser) {
        this.CharParser = inCharParser;
    }

    public void setAreaBuffers(TMlibAreaDataBuffers inEventData) {
        this.EventData = inEventData;
    }

    public void clearCache() {
        this.I4_Cache.clear();
    }

    private generalExecutableExpression parseFunction(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = null;
        int ty = lt.CurrentToken.getFunctionCodeInt();
        String name = lt.CurrentToken.stringValue();
        lt.nextToken();
        switch (ty) {
            case 5: {
                generalExecutableExpression a = this.expression(lt);
                lt.nextToken();
                generalExecutableExpression b = this.expression(lt);
                result = new executableExpressionMAX(a, b);
                break;
            }
            case 6: {
                generalExecutableExpression a = this.expression(lt);
                generalExecutableExpression b = this.expression(lt);
                result = new executableExpressionMIN(a, b);
                break;
            }
            case 10: {
                generalExecutableExpression a = this.expression(lt);
                generalExecutableExpression b = this.expression(lt);
                result = new executableExpressionMOD(a, b);
                break;
            }
            case 11: {
                SWDSP_UnFloat_Auto_V1_Executable SWDSP_AUTO_plugin = new SWDSP_UnFloat_Auto_V1_Executable();
                SWDSP_AUTO_plugin.Args = I4args.createI4args(this, lt);
                result = SWDSP_AUTO_plugin;
                break;
            }
            case 12: {
                SWDSP_UnFloat_Cross_V1_Executable SWDSP_CROSS_plugin = new SWDSP_UnFloat_Cross_V1_Executable();
                SWDSP_CROSS_plugin.Args = I4args.createI4args(this, lt);
                result = SWDSP_CROSS_plugin;
                break;
            }
            case 17: {
                executableExpressionPoly Poly = new executableExpressionPoly();
                Poly.ArgsList = I4args.createI4args(this, lt);
                result = Poly;
                break;
            }
            case 18: {
                executableExpressionI4gen I4gen = new executableExpressionI4gen();
                I4gen.ArgsList = I4args.createI4args(this, lt);
                result = I4gen;
                break;
            }
            case 21: {
                executableExpressionI4Vector I4vect = new executableExpressionI4Vector();
                I4vect.ArgsList = I4args.createI4args(this, lt);
                result = I4vect;
                break;
            }
            case 28: {
                executableExpressionChecksum CKsum = new executableExpressionChecksum();
                CKsum.ArgsList = I4args.createI4args(this, lt);
                result = CKsum;
                break;
            }
            case 25: {
                generalExecutableExpression a = this.expression(lt);
                generalExecutableExpression b = this.expression(lt);
                result = new executableExpression_SWDSP_UnFloat_Cross_2magnitude_V1(a, b);
                break;
            }
            case 32: {
                lt.getArgs();
                String ItemName = lt.CurrentToken.stringArrayValue(0).trim();
                String Path2 = this.ItemDataBase.getValidItemDefObj(ItemName).getXMLFileCommonPath();
                Path2 = Path2 + File.separator + this.CharParser.ParseDBAsString(ItemName);
                generalExecutableExpression skip = this.ParseDB(lt.CurrentToken.stringArrayValue(1));
                generalExecutableExpression istart = this.ParseDB(lt.CurrentToken.stringArrayValue(2));
                generalExecutableExpression istep = this.ParseDB(lt.CurrentToken.stringArrayValue(3));
                generalExecutableExpression NumLoops = this.ParseDB(lt.CurrentToken.stringArrayValue(4));
                generalExecutableExpression NumInner = this.ParseDB(lt.CurrentToken.stringArrayValue(5));
                generalExecutableExpression NumOuter = this.ParseDB(lt.CurrentToken.stringArrayValue(6));
                result = new executableExpressionASCII_File2I4(Path2, this.CharParser, skip, istart, istep, NumLoops, NumInner, NumOuter);
                break;
            }
            default: {
                throw new GSEException(name + " is not an Integer function ", this.ErrDBPath + "FUNCTION_NOT_ALLOWED_FOR_I4");
            }
        }
        return result;
    }

    private generalExecutableExpression element(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = null;
        if (lt.CurrentToken.isSymbol('(')) {
            result = this.expression(lt);
            if (!lt.CurrentToken.isSymbol(')') && !lt.hasMoreTokens()) {
                throw new GSEException(" mismatched parentheses in expression.", this.ErrDBPath + "EXPRESSION_MISMATCHED_PARENTHESES");
            }
        } else if (lt.CurrentToken.typeNum() == 1) {
            result = new executableExpressionConstant(lt.CurrentToken.numValue());
        } else if (lt.CurrentToken.typeNum() == 2) {
            result = this.parseFunction(lt);
        } else if (lt.CurrentToken.typeNum() == 5) {
            ItemDefinitionObject ItemDefObj = this.ItemDataBase.getValidItemDefObj(lt.CurrentToken.stringValue().trim());
            if (ItemDefObj.getDataType() == 2) {
                throw new GSEException("The item \"" + lt.CurrentToken.stringValue() + "\" is a float and cannot be converted to an int", this.ErrDBPath + "FLOAT_CANNOT_BE_CONVERTED_TO_INT");
            }
            if (ItemDefObj.getDataType() == 3) {
                throw new GSEException("The item \"" + lt.CurrentToken.stringValue() + "\" is a double and cannot be converted to an int", this.ErrDBPath + "DOUBLE_CANNOT_BE_CONVERTED_TO_INT");
            }
            if (ItemDefObj.getDataType() == 4) {
                throw new GSEException("The item \"" + lt.CurrentToken.stringValue() + "\" is a char and cannot be converted to a int", this.ErrDBPath + "CHAR_CANNOT_BE_CONVERTED_TO_INT");
            }
            if (ItemDefObj.getItemType() == 1) {
                executableExpressionItemExtract Extractor = new executableExpressionItemExtract();
                Extractor.LengthInBitsExpression = this.ParseDB(ItemDefObj.getStrLengthInBits());
                Extractor.BitsOffsetToNextElementInDataBlockExpression = this.ParseDB(ItemDefObj.getStrBitsOffsetToNextElementInDataBlock());
                Extractor.RepetitionsInSingleDataBlockExpression = this.ParseDB(ItemDefObj.getStrRepetitionsInSingleDataBlock());
                Extractor.BitsOffsetToNextDataBlockExpression = this.ParseDB(ItemDefObj.getStrBitsOffsetToNextDataBlock());
                Extractor.TotalNumberOfDataBlocksExpression = this.ParseDB(ItemDefObj.getStrTotalNumberOfDataBlocks());
                Extractor.AreaExpression = this.ParseDB(ItemDefObj.getStrArea());
                Extractor.BitsOffsetFromStartOfAreaExpression = this.ParseDB(ItemDefObj.getStrBitsOffsetFromStartOfArea());
                Extractor.SignedPullExpression = this.ParseDB(ItemDefObj.getStrSigned());
                Extractor.ItemName = ItemDefObj.getNameOfItem();
                Extractor.EventData = this.EventData;
                result = Extractor;
            } else {
                result = this.ParseDB(ItemDefObj.getStrNonExtractCase());
            }
        } else {
            throw new GSEException("In ParseI4 Unexpected symbol: " + lt.CurrentToken.stringValue(), this.ErrDBPath + "EXPRESSION_UNEXPECTED_SYMBOL");
        }
        return result;
    }

    private generalExecutableExpression primary(LexicalTokenizer lt) throws GSEException {
        lt.nextToken();
        generalExecutableExpression result = lt.CurrentToken.isOp(9) ? new executableExpressionNOT(this.primary(lt)) : (lt.CurrentToken.isOp(2) ? new executableExpressionNEG(this.primary(lt)) : (lt.CurrentToken.isOp(19) ? new executableExpressionBNOT(this.primary(lt)) : this.element(lt)));
        return result;
    }

    private generalExecutableExpression factor(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.primary(lt);
        if (lt.hasMoreTokens()) {
            lt.nextToken();
            if (lt.CurrentToken.isOp(5)) {
                result = new executableExpressionEXP(result, this.factor(lt));
            }
        }
        return result;
    }

    private generalExecutableExpression term(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.factor(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(3)) {
                result = new executableExpressionMUL(result, this.factor(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(4)) break;
            result = new executableExpressionDIV(result, this.factor(lt));
        }
        return result;
    }

    private generalExecutableExpression sum(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.term(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(1)) {
                result = new executableExpressionADD(result, this.term(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(2)) break;
            result = new executableExpressionSUB(result, this.term(lt));
        }
        return result;
    }

    private generalExecutableExpression shift(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.sum(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(21)) {
                result = new executableExpressionLEFTSHIFT(result, this.sum(lt));
                continue;
            }
            if (lt.CurrentToken.isOp(22)) {
                result = new executableExpressionRIGHTSHIFTZERO(result, this.sum(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(23)) break;
            result = new executableExpressionRIGHTSHIFTSIGN(result, this.sum(lt));
        }
        return result;
    }

    private generalExecutableExpression relation(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.shift(lt);
        if (lt.hasMoreTokens() && lt.CurrentToken.typeNum() == 4) {
            switch (lt.CurrentToken.getFunctionCodeInt()) {
                case 10: {
                    result = new executableExpressionEQ(result, this.shift(lt));
                    break;
                }
                case 11: {
                    result = new executableExpressionNE(result, this.shift(lt));
                    break;
                }
                case 12: {
                    result = new executableExpressionLT(result, this.shift(lt));
                    break;
                }
                case 13: {
                    result = new executableExpressionLE(result, this.shift(lt));
                    break;
                }
                case 14: {
                    result = new executableExpressionGT(result, this.shift(lt));
                    break;
                }
                case 15: {
                    result = new executableExpressionGE(result, this.shift(lt));
                }
            }
        }
        return result;
    }

    private generalExecutableExpression logic(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.relation(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(6)) {
                result = new executableExpressionAND(result, this.relation(lt));
                continue;
            }
            if (lt.CurrentToken.isOp(8)) {
                result = new executableExpressionXOR(result, this.relation(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(7)) break;
            result = new executableExpressionIOR(result, this.relation(lt));
        }
        return result;
    }

    public generalExecutableExpression expression(LexicalTokenizer lt) throws GSEException {
        generalExecutableExpression result = this.logic(lt);
        while (lt.hasMoreTokens()) {
            if (lt.CurrentToken.isOp(16)) {
                result = new executableExpressionBAND(result, this.logic(lt));
                continue;
            }
            if (lt.CurrentToken.isOp(17)) {
                result = new executableExpressionBIOR(result, this.logic(lt));
                continue;
            }
            if (!lt.CurrentToken.isOp(18)) break;
            result = new executableExpressionBXOR(result, this.logic(lt));
        }
        return result;
    }

    public generalExecutableExpression ParseDB(String StrToParse) throws GSEException {
        generalExecutableExpression result;
        LogClient.log(TMlibLogLevel.Item_Low, "Entering I4 parse.  Item name " + StrToParse);
        StrToParse = StrToParse.toLowerCase().trim();
        if (this.I4_Cache.containsKey(StrToParse)) {
            result = (generalExecutableExpression)this.I4_Cache.get(StrToParse);
        } else {
            LexicalTokenizer lt = new LexicalTokenizer(StrToParse);
            result = this.expression(lt);
            result = new executableExpressionConstant(result.resolve());
            this.I4_Cache.put(StrToParse, result);
        }
        return result;
    }

    public void ParseDB(String StrToParse, ByteBuffer ByteBuffForClient) throws GSEException {
        StrToParse = StrToParse.toLowerCase().trim();
        generalExecutableExpression result = this.ParseDB(StrToParse);
        int[] output = result.resolve();
        int ItemSiz = 4 * output.length + 8;
        ByteBuffForClient.putInt(ItemSiz - 4);
        ByteBuffForClient.putInt(0);
        for (int i = 0; i < output.length; ++i) {
            ByteBuffForClient.putInt(output[i]);
        }
    }

    public int getItemInt(String StrToParse) throws GSEException {
        generalExecutableExpression intExecutable = this.ParseDB(StrToParse);
        return intExecutable.resolve()[0];
    }
}

