/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item.itemparser;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.item.itemparser.Token;

public class LexicalTokenizer {
    String ErrDBPath = "Universe.edu.umn.space.swaves.stereoLib.item.itemparser.";
    private int currentPos = 0;
    char[] buffer;
    public Token CurrentToken;

    public LexicalTokenizer(String newString) {
        this.buffer = newString.toLowerCase().trim().toCharArray();
    }

    public boolean hasMoreTokens() {
        return this.currentPos < this.buffer.length;
    }

    private Token parseBooleanOp() {
        StringBuffer sb = new StringBuffer();
        int len = 0;
        Token r = null;
        do {
            sb.append(this.buffer[this.currentPos + len]);
        } while (this.isLetter(this.buffer[this.currentPos + ++len]) && this.currentPos + len < this.buffer.length && len < 7);
        if (this.currentPos + len < this.buffer.length && this.buffer[this.currentPos + len] == '.') {
            sb.append('.');
            ++len;
            String x = sb.toString();
            for (int i = 0; i < Token.boolOps.length; ++i) {
                if (!x.equalsIgnoreCase(Token.boolOps[i])) continue;
                r = new Token(4, Token.boolOps[i], Token.boolTokens[i]);
                this.currentPos += len;
                break;
            }
        }
        return r;
    }

    private Token parseNumericConstant() throws GSEException {
        StringBuffer sb = new StringBuffer("");
        boolean foundConstant = false;
        Token r = null;
        while (this.currentPos < this.buffer.length && (this.isDigit(this.buffer[this.currentPos]) || this.buffer[this.currentPos] == '.' || this.buffer[this.currentPos] == 'E' || this.buffer[this.currentPos] == 'e' || this.buffer[this.currentPos] == '-')) {
            sb.append(this.buffer[this.currentPos]);
            foundConstant = true;
            ++this.currentPos;
        }
        if (foundConstant) {
            try {
                double myDbl = Double.parseDouble(sb.toString());
                r = new Token(1, myDbl);
            }
            catch (NumberFormatException nfe) {
                throw new GSEException("Invalid numeric constant " + sb.toString(), this.ErrDBPath + "TOKENIZER_INVALID_NUMERIC_CONSTANT");
            }
        }
        return r;
    }

    private Token parseHexConstant() throws GSEException {
        StringBuffer sb = new StringBuffer("");
        boolean foundConstant = false;
        Token r = null;
        while (this.currentPos < this.buffer.length && this.isHexDigit(this.buffer[this.currentPos])) {
            sb.append(this.buffer[this.currentPos]);
            foundConstant = true;
            ++this.currentPos;
        }
        if (foundConstant) {
            try {
                double myDbl = Integer.parseInt(sb.toString(), 16);
                r = new Token(1, myDbl);
            }
            catch (NumberFormatException nfe) {
                throw new GSEException("Invalid hex constant " + sb.toString(), this.ErrDBPath + "TOKENIZER_INVALID_NUMERIC_CONSTANT");
            }
        }
        return r;
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isHexDigit(char c) {
        return this.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public Token nextToken() throws GSEException {
        Token r = null;
        while (this.currentPos < this.buffer.length && this.isSpace(this.buffer[this.currentPos])) {
            ++this.currentPos;
        }
        if (this.currentPos < this.buffer.length) {
            switch (this.buffer[this.currentPos]) {
                case '+': {
                    ++this.currentPos;
                    r = new Token(4, "+", 1);
                    break;
                }
                case '-': {
                    ++this.currentPos;
                    r = new Token(4, "-", 2);
                    break;
                }
                case '*': {
                    if (this.buffer[this.currentPos + 1] == '*') {
                        this.currentPos += 2;
                        r = new Token(4, "**", 5);
                        break;
                    }
                    ++this.currentPos;
                    r = new Token(4, "*", 3);
                    break;
                }
                case '/': {
                    ++this.currentPos;
                    r = new Token(4, "/", 4);
                    break;
                }
                case '^': {
                    ++this.currentPos;
                    r = new Token(4, "^", 8);
                    break;
                }
                case '&': {
                    ++this.currentPos;
                    r = new Token(4, "&", 6);
                    break;
                }
                case '|': {
                    ++this.currentPos;
                    r = new Token(4, "|", 7);
                    break;
                }
                case '!': {
                    ++this.currentPos;
                    r = new Token(4, "!", 9);
                    break;
                }
                case '=': {
                    ++this.currentPos;
                    r = new Token(4, "=", 10);
                    break;
                }
                case '<': {
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == '=') {
                        this.currentPos += 2;
                        r = new Token(4, "<=", 13);
                        break;
                    }
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == '>') {
                        this.currentPos += 2;
                        r = new Token(4, "<>", 11);
                        break;
                    }
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == '<') {
                        this.currentPos += 2;
                        r = new Token(4, "<<", 21);
                        break;
                    }
                    ++this.currentPos;
                    r = new Token(4, "<", 12);
                    break;
                }
                case '>': {
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == '=') {
                        this.currentPos += 2;
                        r = new Token(4, ">=", 15);
                        break;
                    }
                    if (this.currentPos + 2 < this.buffer.length && this.buffer[this.currentPos + 1] == '>' && this.buffer[this.currentPos + 2] == '>') {
                        this.currentPos += 3;
                        r = new Token(4, ">>>", 22);
                        break;
                    }
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == '>') {
                        this.currentPos += 2;
                        r = new Token(4, ">>", 23);
                        break;
                    }
                    ++this.currentPos;
                    r = new Token(4, ">", 14);
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case ':': 
                case ';': 
                case '?': {
                    r = new Token(0, (double)this.buffer[this.currentPos]);
                    ++this.currentPos;
                    break;
                }
                case '.': {
                    r = this.parseBooleanOp();
                    if (r != null) break;
                }
                case '0': {
                    if (this.currentPos + 1 < this.buffer.length && this.buffer[this.currentPos + 1] == 'x') {
                        this.currentPos += 2;
                        r = this.parseHexConstant();
                        break;
                    }
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    r = this.parseNumericConstant();
                    break;
                }
            }
            if (r == null) {
                StringBuffer q = new StringBuffer();
                while (this.currentPos < this.buffer.length && (this.isLetter(this.buffer[this.currentPos]) || this.isDigit(this.buffer[this.currentPos]) || this.buffer[this.currentPos] == '_')) {
                    q.append(this.buffer[this.currentPos]);
                    ++this.currentPos;
                }
                String t = q.toString();
                Integer function_vector = Token.functions.get(t);
                r = function_vector != null ? new Token(2, t, function_vector) : new Token(5, t);
            }
        }
        this.CurrentToken = r;
        return r;
    }

    public Token getArgs() {
        StringBuffer q = new StringBuffer();
        int NumOpenParens = 1;
        while (NumOpenParens != 0) {
            if (this.buffer[this.currentPos] == ')') {
                --NumOpenParens;
            }
            if (this.buffer[this.currentPos] == '(') {
                ++NumOpenParens;
            }
            if (NumOpenParens == 0) continue;
            q.append(this.buffer[this.currentPos]);
            ++this.currentPos;
        }
        String ArgString = q.toString();
        String[] ArgArray = ArgString.split("\\s*,\\s*");
        this.CurrentToken = new Token(6, ArgArray);
        return this.CurrentToken;
    }
}

