/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.DbFileSearch.SearchList;
import edu.umn.space.swaves.stereoLib.item.ItemDefinitionObject;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpression;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ItemDB
extends SearchList {
    private static final String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.item.itemparser.";
    private String ExcepName;
    private String ErrComment;
    private ParseExpression I4Parse;
    private AbstractMap ItemDefExtracted = new TreeMap();
    private AbstractMap AlwaysValidDefExtracted = new HashMap();

    public void setI4Parse(ParseExpression inI4Parse) {
        this.I4Parse = inI4Parse;
    }

    public ItemDefinitionObject getValidItemDefObj(String ItemName) throws GSEException {
        String CaseSensitiveItemName = ItemName;
        ItemDefinitionObject ValidItemDef = null;
        String ValidityStr = null;
        if (this.AlwaysValidDefExtracted.containsKey(ItemName)) {
            ValidItemDef = (ItemDefinitionObject)this.AlwaysValidDefExtracted.get(ItemName);
        } else {
            Vector ItemDefObjVect = this.getItemDefObjVect(ItemName);
            for (int i = 0; i < ItemDefObjVect.size() && this.I4Parse.getItemInt(ValidityStr = (ValidItemDef = (ItemDefinitionObject)ItemDefObjVect.get(i)).getStrValidity()) != 1; ++i) {
                ValidItemDef = null;
            }
        }
        if (ValidItemDef == null) {
            this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.item.itemparser.VALID_ITEM_NOT_IN_THIS_EVENT";
            this.ErrComment = "No valid item found for " + CaseSensitiveItemName;
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return ValidItemDef;
    }

    private Vector getItemDefObjVect(String ItemName) throws GSEException {
        Vector ItemDefObjVect = new Vector();
        ItemDefinitionObject ItemDBExtract = null;
        if (this.ItemDefExtracted.containsKey(ItemName)) {
            ItemDefObjVect = (Vector)this.ItemDefExtracted.get(ItemName);
        } else {
            Vector XmlElementVectFromDB = super.getNodeVectFromName(ItemName, "item");
            for (int i = 0; i < XmlElementVectFromDB.size(); ++i) {
                ItemDBExtract = new ItemDefinitionObject();
                Element DB_Element = (Element)XmlElementVectFromDB.get(i);
                this.pullXlateFromNode(DB_Element, ItemDBExtract);
                this.pullPluginParameters(DB_Element, ItemDBExtract);
                this.loadDefObjFromDB(DB_Element, ItemDBExtract);
                ItemDefObjVect.add(ItemDBExtract);
            }
            this.ItemDefExtracted.put(ItemName, ItemDefObjVect);
            if (XmlElementVectFromDB.size() == 1 && ItemDBExtract.getStrValidity() == "1") {
                this.AlwaysValidDefExtracted.put(ItemName, ItemDBExtract);
            }
        }
        return ItemDefObjVect;
    }

    private void pullXlateFromNode(Element XML_Node, ItemDefinitionObject ItemDBExtract) throws GSEException {
        NodeList PossibleXlate = XML_Node.getChildNodes();
        int XlateHashKey = 0;
        String XlateHashValue = null;
        for (int i = 0; i < PossibleXlate.getLength(); ++i) {
            Node tempNode = PossibleXlate.item(i);
            if (!tempNode.getNodeName().equalsIgnoreCase("xlate")) continue;
            NamedNodeMap AttrList = tempNode.getAttributes();
            for (int j = 0; j < AttrList.getLength(); ++j) {
                Node current = AttrList.item(j);
                if (current.getNodeName().equalsIgnoreCase("string")) {
                    XlateHashValue = current.getNodeValue();
                }
                if (!current.getNodeName().equalsIgnoreCase("value")) continue;
                XlateHashKey = this.convertStrToInt(current.getNodeValue());
            }
            ItemDBExtract.putInXlateHash(XlateHashKey, XlateHashValue);
        }
    }

    private void pullPluginParameters(Element XML_Node, ItemDefinitionObject ItemDBExtract) throws GSEException {
        String ValueString;
        if (XML_Node.hasAttribute("fixed_value") && (ValueString = XML_Node.getAttribute("fixed_value")).toLowerCase().startsWith("ascii_find_dependent_value")) {
            this.recursivelyFillPluginParameters(XML_Node, ItemDBExtract);
        }
    }

    private void recursivelyFillPluginParameters(Element XML_Node, ItemDefinitionObject ItemDBExtract) throws GSEException {
        NodeList AllChildren = XML_Node.getChildNodes();
        HashMap<String, String> PluginHash = new HashMap<String, String>();
        for (int i = 0; i < AllChildren.getLength(); ++i) {
            Node OneChildNode = AllChildren.item(i);
            String ChildName = OneChildNode.getNodeName().toLowerCase();
            if (ChildName.equals("#text")) continue;
            NamedNodeMap AttrList = OneChildNode.getAttributes();
            for (int j = 0; j < AttrList.getLength(); ++j) {
                Node currentAttr = AttrList.item(j);
                String Key = ChildName + "_" + currentAttr.getNodeName().toLowerCase();
                String Value = currentAttr.getNodeValue().toLowerCase();
                PluginHash.put(Key, Value);
            }
        }
        if (PluginHash.size() != 0) {
            ItemDBExtract.setPluginArgs(PluginHash);
            ItemDBExtract.setPluginArgsPresent(true);
        }
    }

    private int convertStrToInt(String StrVersionOfLong) {
        int TempInt;
        if (StrVersionOfLong.startsWith("0X") || StrVersionOfLong.startsWith("0x")) {
            StrVersionOfLong = StrVersionOfLong.substring(2);
            TempInt = Integer.valueOf(StrVersionOfLong, 16);
        } else {
            TempInt = Integer.valueOf(StrVersionOfLong, 10);
        }
        return TempInt;
    }

    private void loadDefObjFromDB(Element XML_Node, ItemDefinitionObject ItemDBExtract) throws GSEException {
        String DataTypeString = XML_Node.getAttribute("dataType").trim().toLowerCase();
        ItemDBExtract.setNameOfItem(XML_Node.getAttribute("name").trim());
        ItemDBExtract.setXMLFileCommonPath(XML_Node.getAttribute("CommonSearchDir").trim());
        if (XML_Node.hasAttribute("format")) {
            ItemDBExtract.setFormat(XML_Node.getAttribute("format").trim());
        }
        if (DataTypeString.equals("integer")) {
            ItemDBExtract.setDataType(1);
        } else if (DataTypeString.equals("float")) {
            ItemDBExtract.setDataType(2);
        } else if (DataTypeString.equals("double")) {
            ItemDBExtract.setDataType(3);
        } else if (DataTypeString.trim().equals("char")) {
            ItemDBExtract.setDataType(4);
            if (XML_Node.hasAttribute("string")) {
                ItemDBExtract.setStringValue(XML_Node.getAttribute("string"));
                ItemDBExtract.setItemType(2);
                ItemDBExtract.setStrNonExtractCase(XML_Node.getAttribute("string").trim());
            }
        } else {
            this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.item.itemparser..ItemDataBase.REQUESTED_DATATYPE_NOT_VALID";
            this.ErrComment = DataTypeString + " is not a valid datatype";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        ItemDBExtract.setStrValidity("1");
        if (XML_Node.hasAttribute("validity")) {
            ItemDBExtract.setStrValidity(XML_Node.getAttribute("validity").trim());
        }
        if (XML_Node.hasAttribute("fixed_value")) {
            ItemDBExtract.setItemType(2);
            ItemDBExtract.setStrNonExtractCase(XML_Node.getAttribute("fixed_value").trim());
        } else if (XML_Node.hasAttribute("extractArea")) {
            ItemDBExtract.setItemType(1);
            ItemDBExtract.setNameOfItem(XML_Node.getAttribute("name").trim());
            ItemDBExtract.setStrArea(XML_Node.getAttribute("extractArea").trim());
            ItemDBExtract.setStrLengthInBits(XML_Node.getAttribute("lengthInBits").trim());
            ItemDBExtract.setStrBitsOffsetFromStartOfArea(XML_Node.getAttribute("bitsOffsetFromStartOfArea").trim());
            ItemDBExtract.setStrBitsOffsetToNextElementInDataBlock("0");
            if (XML_Node.hasAttribute("bitsOffsetToNextElementInBlock")) {
                ItemDBExtract.setStrBitsOffsetToNextElementInDataBlock(XML_Node.getAttribute("bitsOffsetToNextElementInBlock").trim());
            }
            ItemDBExtract.setStrRepetitionsInSingleDataBlock("1");
            if (XML_Node.hasAttribute("repetitionsInSingleDataBlock")) {
                ItemDBExtract.setStrRepetitionsInSingleDataBlock(XML_Node.getAttribute("repetitionsInSingleDataBlock").trim());
            }
            ItemDBExtract.setStrBitsOffsetToNextDataBlock("0");
            if (XML_Node.hasAttribute("bitsOffsetToNextDataBlock")) {
                ItemDBExtract.setStrBitsOffsetToNextDataBlock(XML_Node.getAttribute("bitsOffsetToNextDataBlock").trim());
            }
            ItemDBExtract.setStrTotalNumberOfDataBlocks("1");
            if (XML_Node.hasAttribute("totalNumberOfDataBlocks")) {
                ItemDBExtract.setStrTotalNumberOfDataBlocks(XML_Node.getAttribute("totalNumberOfDataBlocks").trim());
            }
            ItemDBExtract.setStrSigned("0");
            if (XML_Node.hasAttribute("signed")) {
                ItemDBExtract.setStrSigned(XML_Node.getAttribute("signed").trim());
            }
        }
    }
}

