/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.item;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.ItemDefinitionObject;
import edu.umn.space.swaves.stereoLib.item.TMlibAreaDataBuffers;
import edu.umn.space.swaves.stereoLib.item.itemparser.ParseExpression;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class InsertHiddenItems {
    private ItemDB ItemDataBase;
    private ParseExpression I4Parse;
    private TMlibAreaDataBuffers AreaBuffers;
    private Charset AsciiCharset = Charset.forName("US-ASCII");

    public InsertHiddenItems(ParseExpression inI4Parse, TMlibAreaDataBuffers inAreaBuffers) throws GSEException {
        this.I4Parse = inI4Parse;
        this.AreaBuffers = inAreaBuffers;
        int NumHidden = this.I4Parse.getItemInt("NUMBER_HIDDEN_AREAS");
        for (int i = 1; i < NumHidden + 1; ++i) {
            String LengthAreaItemName = "LENGTH_HIDDEN_AREA_" + i;
            int LengthArea = this.I4Parse.getItemInt(LengthAreaItemName);
            this.AreaBuffers.addArea(-1 * i, LengthArea);
        }
    }

    public void setItemDB(ItemDB inItemDataBase) {
        this.ItemDataBase = inItemDataBase;
    }

    public void insertStringInHiddenArea(String ItemName, String ItemValue) throws GSEException {
        ItemDefinitionObject ItemDefObj = this.ItemDataBase.getValidItemDefObj(ItemName);
        int Area = this.I4Parse.getItemInt(ItemDefObj.getStrArea());
        int BitOffset = this.I4Parse.getItemInt(ItemDefObj.getStrBitsOffsetFromStartOfArea());
        int LengthBytes = this.I4Parse.getItemInt(ItemDefObj.getStrLengthInBits()) / 8;
        if (ItemValue.length() > LengthBytes) {
            ItemValue = ItemValue.substring(0, LengthBytes - 1);
        }
        this.AreaBuffers.insertBuffer(Area, BitOffset, this.AsciiCharset.encode(ItemValue));
    }

    public void insertIntIntoHiddenArea(String ItemName, int ItemValue) throws GSEException {
        ItemDefinitionObject ItemDefObj = this.ItemDataBase.getValidItemDefObj(ItemName);
        int Area = this.I4Parse.getItemInt(ItemDefObj.getStrArea());
        int BitOffset = this.I4Parse.getItemInt(ItemDefObj.getStrBitsOffsetFromStartOfArea());
        this.AreaBuffers.insertInt(Area, BitOffset, ItemValue);
    }

    public ByteBuffer mapToArea(String ItemName) throws GSEException {
        ItemDefinitionObject ItemDefObj = this.ItemDataBase.getValidItemDefObj(ItemName);
        int Area = this.I4Parse.getItemInt(ItemDefObj.getStrArea());
        int BitOffset = this.I4Parse.getItemInt(ItemDefObj.getStrBitsOffsetFromStartOfArea());
        int LengthBits = this.I4Parse.getItemInt(ItemDefObj.getStrLengthInBits());
        return this.AreaBuffers.makeMap(Area, BitOffset, LengthBits);
    }

    public void insertUR8(String DayItemName, String MilleSecItemName, double UR8) throws GSEException {
        double Day = Math.floor(UR8);
        double FractDays = UR8 - Day;
        int millisec = (int)Math.floor(FractDays * 8.64E7);
        this.insertIntIntoHiddenArea(MilleSecItemName, millisec);
        this.insertIntIntoHiddenArea(DayItemName, (int)Day);
    }
}

