/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.event;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.event.EventFilters;
import edu.umn.space.swaves.stereoLib.event.MultiPacket_EventPlugin;
import edu.umn.space.swaves.stereoLib.event.SinglePacket_EventPlugin;
import edu.umn.space.swaves.stereoLib.event.TMlibEvent;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.item;

public class EventPluginSelector {
    public static String RECORD_LENGTH_STRING = "TOTAL_RECORD_LENGTH_BYTES";
    private static String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.event.";

    public static TMlibEvent pickEventBuilder(ItemDB XmlDB, item MSIE_Item) throws GSEException {
        int MainAreaLength = EventPluginSelector.findMaxBytesInEvent(XmlDB, MSIE_Item);
        MSIE_Item.createPrimaryArea(MainAreaLength);
        MSIE_Item.setAreaReadable(0, true);
        EventFilters EventBuilder = null;
        String EventName = XmlDB.getStrAttrLowCase("name", "event");
        if (!XmlDB.hasAttribute("event_builder", "event")) {
            String ExcepName = ErrPath + "EVENT_BUILDER_ATTRIBUTE_NOT_DEFINED";
            String ErrComment = "The event: " + EventName + " does not have the event_builder attribute defined." + "This attribute is required.";
            throw new GSEException(ErrComment, ExcepName);
        }
        String BuilderType = XmlDB.getStrAttrLowCase("event_builder", "event");
        if (BuilderType.equals("general_spe")) {
            EventBuilder = new SinglePacket_EventPlugin();
        } else if (BuilderType.equals("general_mpe")) {
            if (!XmlDB.hasAttribute("firstpacket", "event")) {
                String ExcepName = ErrPath + "FIRST_PACKET_ATTRIBUTE_NOT_DEFINED";
                String ErrComment = "The multi packet event: " + EventName + " does not have the firstpacket attribute defined." + "This attribute is required for a multi packet event.";
                throw new GSEException(ErrComment, ExcepName);
            }
            if (!XmlDB.hasAttribute("lastpacket", "event")) {
                String ExcepName = ErrPath + "LAST_PACKET_ATTRIBUTE_NOT_DEFINED";
                String ErrComment = "The multi packet event: " + EventName + " does not have the lastpacket attribute defined." + "This attribute is required for a multi packet event.";
                throw new GSEException(ErrComment, ExcepName);
            }
            EventBuilder = new MultiPacket_EventPlugin();
        }
        EventBuilder.setXmlDB(XmlDB);
        EventBuilder.setItemObj(MSIE_Item);
        return EventBuilder;
    }

    public static int findMaxBytesInEvent(ItemDB XmlDB, item MSIE_Item) throws GSEException {
        String StrMaxBytesInEvent = !XmlDB.hasAttribute("maxeventbytes", "event") ? RECORD_LENGTH_STRING : XmlDB.getStrAttrLowCase("maxeventbytes", "event");
        return MSIE_Item.getItemInt(StrMaxBytesInEvent);
    }
}

