/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.event;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.GSEException.TMlibErrorStack;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.stereoLib.event.EventCache;
import edu.umn.space.swaves.stereoLib.event.EventPluginSelector;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.TMlibAreaDataBuffers;
import edu.umn.space.swaves.stereoLib.item.item;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public abstract class EventFilters {
    private String UR8_ItemName = "GetTime_UR8";
    private ByteBuffer TempBuffer;
    private TMlibStream StreamObj;
    private item ItemObj;
    private ItemDB XmlDB;
    private TMlibAreaDataBuffers Areas;
    private final int EVENT_AREA_NUMBER = 0;
    private int FirstUR8_days;
    private int FirstUR8_millesec;
    private int LastUR8_days;
    private int LastUR8_millesec;
    private int meatLength;
    private int PacketsFound;
    private int NumEventBuildFails;
    private ByteBuffer StreamBufferArea;
    private ByteBuffer EventBeingBuiltBuffer;
    private String FirstPacketIndicator = null;
    private String LastPacketIndicator = null;
    private String VadidateStr = null;
    private boolean UseVadidate = false;
    private String FilterStr = null;
    private boolean UseFilterStr = false;
    private String CounterStr = null;
    private boolean UseCounter = false;
    private String MatchAbortStr = null;
    private boolean UseMatchAbort = false;
    private String MatchSkipStr = null;
    private boolean UseMatchSkip = false;
    private String LastByteToKeepStr = null;
    private boolean UseLastByteToKeepStr = false;
    private String FirstByteToSlice = null;
    private EventCache BooleanTests;
    private int RecordLength;
    private TMlibErrorStack ErrorStack = new TMlibErrorStack();
    private static final String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.event.";

    public void setXmlDB(ItemDB inXmlDB) {
        this.XmlDB = inXmlDB;
    }

    public void setItemObj(item inItemObj) throws GSEException {
        this.ItemObj = inItemObj;
        this.RecordLength = this.ItemObj.getItemInt(EventPluginSelector.RECORD_LENGTH_STRING);
        this.Areas = this.ItemObj.AreaBuffers;
        this.StreamBufferArea = this.Areas.getAreaBuffer(0);
        int MaxLengthStreamArea = this.StreamBufferArea.capacity();
        this.EventBeingBuiltBuffer = ByteBuffer.allocateDirect(MaxLengthStreamArea);
        this.BooleanTests = new EventCache(this.ItemObj);
        this.TempBuffer = ByteBuffer.allocateDirect(25);
        if (this.XmlDB.hasAttribute("filter", "event")) {
            this.FilterStr = this.XmlDB.getStrAttrLowCase("filter", "event");
            this.BooleanTests.loadItemString(this.FilterStr);
            this.UseFilterStr = true;
        }
        if (this.XmlDB.hasAttribute("validate", "event")) {
            this.VadidateStr = this.XmlDB.getStrAttrLowCase("validate", "event");
            this.UseVadidate = true;
        }
        if (this.XmlDB.hasAttribute("match_or_abort", "event")) {
            this.MatchAbortStr = this.XmlDB.getStrAttrLowCase("match_or_abort", "event");
            this.BooleanTests.loadItemString(this.MatchAbortStr);
            this.UseMatchAbort = true;
        }
        if (this.XmlDB.hasAttribute("match_or_skip", "event")) {
            this.MatchSkipStr = this.XmlDB.getStrAttrLowCase("match_or_skip", "event");
            this.BooleanTests.loadItemString(this.MatchSkipStr);
            this.UseMatchSkip = true;
        }
        if (this.XmlDB.hasAttribute("counter", "event")) {
            this.CounterStr = this.XmlDB.getStrAttrLowCase("counter", "event");
            this.BooleanTests.loadItemString(this.CounterStr);
            this.UseCounter = true;
        }
        if (this.XmlDB.hasAttribute("lastpacket", "event")) {
            this.LastPacketIndicator = this.XmlDB.getStrAttrLowCase("lastpacket", "event");
            this.BooleanTests.loadItemString(this.LastPacketIndicator);
        }
        if (this.XmlDB.hasAttribute("firstpacket", "event")) {
            this.FirstPacketIndicator = this.XmlDB.getStrAttrLowCase("firstpacket", "event");
            this.BooleanTests.loadItemString(this.FirstPacketIndicator);
        }
        this.FirstByteToSlice = this.XmlDB.getStrAttrLowCase("firstByteToSlice", "event");
        if (this.XmlDB.hasAttribute("lastByteToSlice", "event")) {
            this.LastByteToKeepStr = this.XmlDB.getStrAttrLowCase("lastByteToSlice", "event");
            this.UseLastByteToKeepStr = true;
        }
    }

    public void NewEvent() {
        this.NumEventBuildFails = 0;
    }

    public void setTMlibStream(TMlibStream inStreamObj) {
        this.StreamObj = inStreamObj;
        this.StreamObj.setRecordLength(this.RecordLength);
    }

    private void clearBuilder() {
        this.EventBeingBuiltBuffer.clear();
        this.StreamBufferArea.clear();
        this.meatLength = 0;
        this.PacketsFound = 0;
    }

    public void cacheItemsForNextRecordTests() throws GSEException {
        this.BooleanTests.updateCache();
    }

    public boolean isLastRecord() throws GSEException {
        boolean LastRecord = this.ItemObj.getItemInt(this.LastPacketIndicator) == 1;
        return LastRecord;
    }

    public boolean isFirstRecord() throws GSEException {
        boolean FirstRecord = this.ItemObj.getItemInt(this.FirstPacketIndicator) == 1;
        return FirstRecord;
    }

    public boolean MatchOrSkip() throws GSEException {
        boolean MachSkipBool = true;
        if (this.UseMatchSkip) {
            MachSkipBool = this.BooleanTests.evaluateString(this.MatchSkipStr);
            if (!this.UseMatchSkip) {
                LogClient.log(TMlibLogLevel.Event_Low, "Packet failed match or skip test");
            }
        }
        return MachSkipBool;
    }

    public boolean MatchOrAbort() throws GSEException {
        boolean MachAbortBool = true;
        if (this.UseMatchAbort && !(MachAbortBool = this.BooleanTests.evaluateString(this.MatchAbortStr))) {
            ++this.NumEventBuildFails;
            LogClient.log(TMlibLogLevel.Event_Low, "Packet failed match or abort test");
        }
        return MachAbortBool;
    }

    public boolean filter() throws GSEException {
        boolean FilterBool = true;
        if (this.UseFilterStr && !(FilterBool = this.BooleanTests.evaluateString(this.FilterStr))) {
            LogClient.log(TMlibLogLevel.Event_Low, "Packet failed filter test");
        }
        return FilterBool;
    }

    public boolean validate() throws GSEException {
        boolean ValidateBool = true;
        if (this.UseVadidate) {
            boolean bl = ValidateBool = this.ItemObj.getItemInt(this.VadidateStr) == 1;
            if (!ValidateBool) {
                ++this.NumEventBuildFails;
                LogClient.log(TMlibLogLevel.Event_Low, "Packet failed validate test");
            }
        }
        return ValidateBool;
    }

    public boolean checkCounter() throws GSEException {
        boolean CounterGood = true;
        if (this.UseCounter && !(CounterGood = this.BooleanTests.evaluateString(this.CounterStr))) {
            ++this.NumEventBuildFails;
        }
        return CounterGood;
    }

    public void insertFirstRecordIntoBuffer() throws GSEException {
        LogClient.log(TMlibLogLevel.Event_Low, "First packet packet put in event buffer");
        this.clearBuilder();
        this.findFirstUR8();
        this.StreamBufferArea.position(0);
        int LastByte = this.RecordLength;
        if (this.UseLastByteToKeepStr) {
            LastByte = this.ItemObj.getItemInt(this.LastByteToKeepStr);
        }
        this.StreamBufferArea.limit(LastByte);
        try {
            this.EventBeingBuiltBuffer.put(this.StreamBufferArea);
        }
        catch (BufferOverflowException execp) {
            String ExcepName = "Universe.edu.umn.space.swaves..stereoLib.event.EVENT_LENGTH_EXCEEDS_MAX";
            String ErrComment = "Error on first packet loaded into event";
            throw new GSEException(ErrComment, ExcepName);
        }
        this.meatLength += LastByte;
        ++this.PacketsFound;
    }

    public void insertAdditionalRecordIntoBuffer() throws GSEException {
        LogClient.log(TMlibLogLevel.Event_Low, "Additional packet packet put in event buffer");
        int FirstByte = this.ItemObj.getItemInt(this.FirstByteToSlice);
        this.StreamBufferArea.position(FirstByte);
        int LastByte = this.RecordLength;
        if (this.UseLastByteToKeepStr) {
            LastByte = this.ItemObj.getItemInt(this.LastByteToKeepStr);
        }
        this.StreamBufferArea.limit(LastByte);
        try {
            this.EventBeingBuiltBuffer.put(this.StreamBufferArea);
        }
        catch (BufferOverflowException execp) {
            String ExcepName = "Universe.edu.umn.space.swaves..stereoLib.event.EVENT_LENGTH_EXCEEDS_MAX";
            String ErrComment = "Error on first packet loaded into event";
            throw new GSEException(ErrComment, ExcepName);
        }
        this.meatLength += LastByte - FirstByte;
        ++this.PacketsFound;
    }

    private void findFirstUR8() throws GSEException {
        this.FirstUR8_days = this.GRT_UR8_Day();
        this.FirstUR8_millesec = this.GRT_UR8_millisec();
    }

    private int GRT_UR8_Day() throws GSEException {
        this.ItemObj.getItemR8AsByteBuff(this.UR8_ItemName, this.TempBuffer);
        double UR8 = this.TempBuffer.getDouble(8);
        int Day = (int)Math.floor(UR8);
        return Day;
    }

    private int GRT_UR8_millisec() throws GSEException {
        this.ItemObj.getItemR8AsByteBuff(this.UR8_ItemName, this.TempBuffer);
        double UR8 = this.TempBuffer.getDouble(8);
        double Day = Math.floor(UR8);
        double FractDays = UR8 - Day;
        int millisec = (int)Math.floor(FractDays * 8.64E7);
        return millisec;
    }

    public void getNextRecord() throws GSEException {
        this.ItemObj.clearCache();
        this.StreamBufferArea.clear();
        this.StreamBufferArea.limit(this.RecordLength);
        this.StreamObj.getNextRecord(this.StreamBufferArea);
        this.StreamBufferArea.flip();
    }

    public void completeEventBuild() throws GSEException {
        this.LastUR8_days = this.GRT_UR8_Day();
        this.LastUR8_millesec = this.GRT_UR8_millisec();
        this.ItemObj.insertIntIntoHiddenArea("EVENT_SAUSAGE_LENGTH", this.meatLength);
        this.ItemObj.insertIntIntoHiddenArea("EVENT_NUM_BUILD_FAILURES", this.NumEventBuildFails);
        this.ItemObj.insertIntIntoHiddenArea("EVENT_NUM_BUILD_PACKETS", this.PacketsFound);
        this.ItemObj.insertIntIntoHiddenArea("Time_BOE_days", this.FirstUR8_days);
        this.ItemObj.insertIntIntoHiddenArea("Time_BOE_mSec_in_day", this.FirstUR8_millesec);
        this.ItemObj.insertIntIntoHiddenArea("Time_EOE_days", this.LastUR8_days);
        this.ItemObj.insertIntIntoHiddenArea("Time_EOE_mSec_in_day", this.LastUR8_millesec);
        this.NumEventBuildFails = 0;
        this.EventBeingBuiltBuffer.flip();
        this.StreamBufferArea.clear();
        this.StreamBufferArea.put(this.EventBeingBuiltBuffer);
        this.StreamBufferArea.flip();
        this.ItemObj.clearCache();
    }

    public abstract void next() throws GSEException;
}

