/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.TM_Help;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.DbFileSearch.SearchList;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamFamilySelector;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.DaqStream;
import edu.umn.space.swaves.stereoLib.TM_Help.FileProperties;
import edu.umn.space.swaves.util.xml.SearchConfigFileList;
import edu.umn.space.swaves.util.xml.XmlTransform;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TMlibHelp {
    private String Log_dir = null;
    private String ChooserDir = null;
    private SearchList ProbeXMLDB = new SearchList();
    private String XmlBoilerPlate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private LinkedList FileList = new LinkedList();
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private CharsetDecoder AsciiDecoder = this.AsciiCharset.newDecoder();
    private static String DeltaIndent = "  ";
    private XmlTransform TransXML = null;
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.help.";
    private String ExcepName;
    private String ErrComment;
    private static Pattern UrlRegex = Pattern.compile("tmlib://(\\w*)(/.*)");
    private static final String ItemUrl = "itemdb";
    private static final String LogUrl = "log";
    private static final String ChooserUrl = "chooser";
    HashMap<String, ByteBuffer> HelpHash = new HashMap();

    public void setMission(String Mission) throws GSEException {
        SearchConfigFileList ConfigFiles = new SearchConfigFileList();
        try {
            this.Log_dir = ConfigFiles.getLoggerPath();
        }
        catch (GSEException excep) {
            this.Log_dir = null;
        }
        this.ChooserDir = ConfigFiles.getCHOOSER_ROOT(Mission);
    }

    public void getHelp(String HelpURL, ByteBuffer ResultOfHelp) throws GSEException {
        String LowCaseURL = HelpURL.toLowerCase();
        if (this.HelpHash.containsKey(LowCaseURL)) {
            ByteBuffer FromHash = this.HelpHash.get(LowCaseURL);
            FromHash.position(0);
            FromHash.limit(FromHash.capacity());
            ResultOfHelp.clear();
            ResultOfHelp.put(FromHash);
        } else {
            ResultOfHelp.clear();
            ResultOfHelp.putInt(0);
            ResultOfHelp.putInt(0);
            Matcher URLmatcher = UrlRegex.matcher(HelpURL);
            if (URLmatcher.find()) {
                String TMlibURLType = URLmatcher.group(1);
                String UrlPath = URLmatcher.group(2);
                if (TMlibURLType.equalsIgnoreCase(ItemUrl)) {
                    this.itemDBSearch(UrlPath, ResultOfHelp);
                } else if (TMlibURLType.equalsIgnoreCase(LogUrl)) {
                    this.LogSearch(UrlPath, this.Log_dir, ResultOfHelp);
                } else if (TMlibURLType.equalsIgnoreCase(ChooserUrl)) {
                    this.ChooserSearch(UrlPath, this.ChooserDir, ResultOfHelp);
                } else {
                    String ExcepName = "Universe.edu.umn.space.swaves.stereoLib.help.TMHELP_URL_NOT_VALID";
                    String ErrComment = TMlibURLType + "is not a valid type of URL for TMlib_Help";
                    throw new GSEException(ErrComment, ExcepName);
                }
            }
            int NumberOfBytesForBuffer = ResultOfHelp.position() - 4;
            ResultOfHelp.putInt(0, NumberOfBytesForBuffer);
            ByteBuffer Buff_For_Hash = ByteBuffer.allocate(NumberOfBytesForBuffer + 4);
            ResultOfHelp.flip();
            Buff_For_Hash.put(ResultOfHelp);
            this.HelpHash.put(LowCaseURL, Buff_For_Hash);
            ResultOfHelp.position(ResultOfHelp.getInt(0) + 4);
        }
    }

    private void itemDBSearch(String PathFromURL, ByteBuffer HelpBuff) throws GSEException {
        Iterator FileIterate = this.ProbeXMLDB.getXmlItemDBHelp(PathFromURL);
        if (!this.ProbeXMLDB.isLastFileDir()) {
            this.ProbeXMLDB.readXMLandIncludeEntities((File)FileIterate.next(), HelpBuff);
        } else {
            this.FileList.clear();
            while (FileIterate.hasNext()) {
                File FileToCheck = (File)FileIterate.next();
                this.keepDirAndXMLfiles(FileToCheck, this.FileList);
            }
            this.createDir(PathFromURL, this.FileList, HelpBuff);
        }
    }

    private void LogSearch(String PathFromURL, String TopDbDir, ByteBuffer HelpBuff) throws GSEException {
        File RequestedFile = new File(TopDbDir + PathFromURL);
        if (!RequestedFile.isFile()) {
            this.FileList.clear();
            File[] FilesInTheDir = RequestedFile.listFiles();
            for (int i = 0; i < FilesInTheDir.length; ++i) {
                File FileToCheck = FilesInTheDir[i];
                this.keepDirAndXMLfiles(FileToCheck, this.FileList);
            }
            this.createDir(PathFromURL, this.FileList, HelpBuff);
        }
    }

    private void ChooserSearch(String PathFromURL, String ChooserDir, ByteBuffer HelpBuff) throws GSEException {
        this.FileList.clear();
        File RequestedFile = new File(ChooserDir + PathFromURL);
        if (RequestedFile.isFile()) {
            String ExcepName = "Universe.edu.umn.space.swaves.stereoLib.help.FILE_REQUESTED_OF_CHOOSER_HELP";
            String ErrComment = PathFromURL + "points to a file and the chooser does not return files";
            throw new GSEException(ErrComment, ExcepName);
        }
        this.FileList.clear();
        if ((PathFromURL.equals("/") || PathFromURL.equals(" ")) && this.DaqExists()) {
            this.FileList.add(new FileProperties("REALTIME", "q", 0L, 0.0));
        }
        File[] FilesInTheDir = RequestedFile.listFiles();
        for (int i = 0; i < FilesInTheDir.length; ++i) {
            File FileToCheck = FilesInTheDir[i];
            String FileName = FileToCheck.getName();
            if (FileName.startsWith(".", 0)) continue;
            if (FileToCheck.isFile()) {
                StreamProperties FileProp = StreamFamilySelector.getStreamFamilyFromStreamName(FileName);
                double UR8 = FileProp.getUR8(FileName);
                this.FileList.add(new FileProperties(FileName, "f", FileToCheck.length(), UR8));
                continue;
            }
            this.FileList.add(new FileProperties(FileName, "d", 0L, 0.0));
        }
        this.createDir(PathFromURL, this.FileList, HelpBuff);
    }

    private void keepDirAndXMLfiles(File FileToCheck, LinkedList FileList) {
        String FileName = FileToCheck.getName();
        if (!FileName.startsWith(".", 0)) {
            if (FileToCheck.isFile()) {
                if (FileName.endsWith(".xml")) {
                    FileList.add(new FileProperties(FileName, "f", FileToCheck.length(), 0.0));
                }
            } else {
                FileList.add(new FileProperties(FileName, "d", 0L, 0.0));
            }
        }
    }

    private void createDir(String PathFromURL, LinkedList FileList, ByteBuffer HelpBuff) throws GSEException {
        String StrHelp = this.XmlBoilerPlate;
        StrHelp = StrHelp + "<DirectorySet>\n";
        StrHelp = StrHelp + DeltaIndent + "<header \n" + DeltaIndent + "         fileName = \"" + PathFromURL + "\"\n" + DeltaIndent + "         fileType = \"Directory Description XML\"\n" + DeltaIndent + " />\n";
        for (int i = 0; i < FileList.size(); ++i) {
            FileProperties NextFile = (FileProperties)FileList.get(i);
            StrHelp = StrHelp + DeltaIndent + "<file nm=\"" + NextFile.getName() + "\"" + " ty=\"" + NextFile.getType() + "\"" + " sz=\"" + NextFile.getLength() + "\"" + " ur8=\"" + NextFile.getUR8() + "\"/>\n";
        }
        StrHelp = StrHelp + "</DirectorySet>\n";
        HelpBuff.put(this.AsciiCharset.encode(StrHelp));
    }

    private boolean DaqExists() {
        boolean DaqPresent = true;
        try {
            DaqStream TestTheDaq = new DaqStream();
            TestTheDaq.close();
        }
        catch (GSEException e) {
            DaqPresent = false;
        }
        return DaqPresent;
    }
}

