/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.GSEException.TMlibErrorStack;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.MsieItemDB;
import edu.umn.space.swaves.stereoLib.ServerShutdownException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class TMLibWireProtServer
extends MsieItemDB {
    public static final int TM_CMD_HELP = 1;
    public static final int TM_CMD_ERROR_STACK = 2;
    public static final int TM_CMD_SELECT_DOMAIN = 3;
    public static final int TM_CMD_SELECT_STREAM = 4;
    public static final int TM_CMD_FIND_EVENT = 5;
    public static final int TM_CMD_GET_ITEMI4 = 6;
    public static final int TM_CMD_GET_ITEMR8 = 8;
    public static final int TM_CMD_GET_ITEMCHAR = 9;
    public static final int TM_CMD_CLOSE_STREAM = 11;
    public static final int TM_CMD_GET_ITEMR4 = 12;
    public static final int TM_CMD_GET_POSITION = 13;
    public static final int TM_CMD_SET_POSITION = 14;
    public static final int TM_CMD_NOOP = 15;
    public static final int TM_CMD_SELECT_STREAM_TIMERANGE = 16;
    private TMlibErrorStack ErrorStack = new TMlibErrorStack();
    private static final String ErrPath = "Universe.edu.umn.space.swaves.";
    private String ExcepName;
    private String ErrComment;
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private CharsetDecoder AsciiDecoder = this.AsciiCharset.newDecoder();

    public final void CommandToTmLib(ByteBuffer Command, ByteBuffer ByteBuff_ForClient) throws ServerShutdownException {
        try {
            this.SwitchToParseCommand(Command, ByteBuff_ForClient);
        }
        catch (GSEException ipe) {
            this.ErrorStack.enterElementIntoStack(ipe);
        }
        int NewErrorCode = this.ErrorStack.getNewErrorStackCode();
        if (NewErrorCode != 0) {
            TMLibWireProtServer.setNoDataJustError(NewErrorCode, ByteBuff_ForClient);
        }
    }

    public static void setNoDataJustError(int ErrorCode, ByteBuffer ByteBuff_ForClient) {
        ByteBuff_ForClient.clear();
        ByteBuff_ForClient.putInt(4);
        ByteBuff_ForClient.putInt(ErrorCode);
    }

    private void SwitchToParseCommand(ByteBuffer Command, ByteBuffer ByteBuff_ForClient) throws GSEException, ServerShutdownException {
        Command.position(4);
        byte CommandCode = Command.get();
        switch (CommandCode) {
            case 1: {
                this.ErrorStack.clear();
                super.getHelp(this.BBtoStr(Command), ByteBuff_ForClient);
                break;
            }
            case 2: {
                String ErrorString = this.ErrorStack.queryErrorStack(this.BBtoStr(Command));
                ByteBuff_ForClient.clear();
                int NumberOfBytesForBuffer = ErrorString.length() + 4;
                ByteBuff_ForClient.putInt(NumberOfBytesForBuffer);
                ByteBuff_ForClient.putInt(0);
                ByteBuff_ForClient.put(this.AsciiCharset.encode(ErrorString));
                this.ErrorStack.queryErrorStack(this.BBtoStr(Command));
                break;
            }
            case 3: {
                this.ErrorStack.clear();
                super.TM_Select_Domain(this.BBtoStr(Command));
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                break;
            }
            case 4: {
                this.ErrorStack.clear();
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                super.TM_Select_Stream(this.BBtoStr(Command));
                break;
            }
            case 5: {
                this.ErrorStack.clear();
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                super.nextEvent();
                break;
            }
            case 6: {
                this.ErrorStack.clear();
                String ItemName = this.BBtoStr(Command);
                LogClient.log(TMlibLogLevel.Item_High, "Requesting I4 item: " + ItemName);
                super.getItemI4AsByteBuff(ItemName, ByteBuff_ForClient);
                break;
            }
            case 12: {
                this.ErrorStack.clear();
                String ItemName = this.BBtoStr(Command);
                LogClient.log(TMlibLogLevel.Item_High, "Requesting R4 item: " + ItemName);
                super.getItemR4AsByteBuff(ItemName, ByteBuff_ForClient);
                break;
            }
            case 8: {
                this.ErrorStack.clear();
                String ItemName = this.BBtoStr(Command);
                LogClient.log(TMlibLogLevel.Item_High, "Requesting R8 item: " + ItemName);
                super.getItemR8AsByteBuff(ItemName, ByteBuff_ForClient);
                break;
            }
            case 9: {
                this.ErrorStack.clear();
                super.getItemCharByteBuff(this.BBtoStr(Command), ByteBuff_ForClient);
                break;
            }
            case 13: {
                this.ErrorStack.clear();
                super.TM_GET_POSITION(ByteBuff_ForClient);
                break;
            }
            case 14: {
                this.ErrorStack.clear();
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                super.TM_Set_Time(Command);
                break;
            }
            case 11: {
                LogClient.log(TMlibLogLevel.Domain_High, "Client requested shutown");
                this.ErrorStack.clear();
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                super.streamClose();
                throw new ServerShutdownException();
            }
            case 15: {
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                break;
            }
            case 16: {
                this.ErrorStack.clear();
                TMLibWireProtServer.setNoDataJustError(0, ByteBuff_ForClient);
                super.TM_SelectStream_TimeRange(Command);
                break;
            }
            default: {
                this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.CommmandInput.COMMAND_TYPE_NOT_KNOWN";
                this.ErrComment = "CommandCode: " + CommandCode + " is not a valid command";
                throw new GSEException(this.ErrComment, this.ExcepName);
            }
        }
    }

    private String BBtoStr(ByteBuffer inBuff) throws GSEException {
        String OutString;
        try {
            OutString = this.AsciiDecoder.decode(inBuff).toString();
        }
        catch (CharacterCodingException excep) {
            this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.CommmandInput.NON_ASCII_CHAR_IN_INPUT";
            this.ErrComment = "Command is not ASCII";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return OutString;
    }
}

