/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.DaqStream;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.DirTreeSearch;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.FileStream;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.util.xml.SearchConfigFileList;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TMlibStreamFactory {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private static final String Sep = File.separator;
    private static final Pattern ChooserPattern = Pattern.compile("(?i).*tmlib://chooser(.*)");
    private static final Pattern PlusStartPattern = Pattern.compile("(\\+)(.*)");
    private static final Pattern FullPathPattern = Pattern.compile("\\^" + Sep + "(.*)");

    public static TMlibStream pickTMlibStream(String StreamName, String MissionName) throws GSEException {
        String FileName = TMlibStreamFactory.deriveFileName(StreamName, MissionName);
        TMlibStream NewStream = null;
        if (FileName.equals("isrealtime")) {
            LogClient.log(TMlibLogLevel.Stream_High, "Resolved StreamName: \n realtime");
            NewStream = new DaqStream();
        } else {
            LogClient.log(TMlibLogLevel.Stream_High, "Resolved StreamName: \n" + FileName);
            NewStream = new FileStream(FileName);
        }
        return NewStream;
    }

    public static String deriveFileName(String StreamName, String MissionName) throws GSEException {
        SearchConfigFileList GetParameters = new SearchConfigFileList();
        String WildcardRoot = GetParameters.getWILDCARD_ROOT(MissionName);
        String ChooserDir = GetParameters.getCHOOSER_ROOT(MissionName);
        String inFileName = StreamName.toLowerCase().trim();
        Matcher ChooserMatcher = ChooserPattern.matcher(inFileName);
        Matcher PlusMatcher = PlusStartPattern.matcher(inFileName);
        Matcher FullPathMatcher = FullPathPattern.matcher(inFileName);
        String FileName = "";
        if (inFileName.matches("(?i).*realtime")) {
            FileName = "isrealtime";
        } else if (ChooserMatcher.find()) {
            FileName = inFileName.replaceAll("(?i)tmlib://chooser", ChooserDir + Sep);
        } else if (PlusMatcher.find()) {
            FileName = WildcardRoot + Sep + PlusMatcher.group(2);
        } else if (FullPathMatcher.find()) {
            FileName = inFileName;
        } else {
            DirTreeSearch DirTreeSearcher = new DirTreeSearch();
            DirTreeSearcher.setRegex(inFileName);
            File MatchFile = DirTreeSearcher.findFileInTree(new File(WildcardRoot));
            if (MatchFile != null) {
                FileName = MatchFile.toString();
            } else {
                String ErrorMessage = "No file with the pattern: " + StreamName + "\n" + "found in: " + WildcardRoot;
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.NO_FILE_FOUND_TO_MATCH_PATTERN";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
        }
        return FileName;
    }
}

