/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.StreamReposition;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.item.item;
import java.io.File;
import java.nio.charset.Charset;

public class Stream_Names_Times {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private static final double START_AT_BEGINNING_OF_INFORMATION = 0.0;
    private static final double START_AT_BEGINNING_OF_INFORMATION_2 = -1.0;
    private static final double END_AT_END_OF_DAY = 0.0;
    private static final double END_AT_END_OF_INFORMATION = -1.0;
    private item MSIE_Item;
    private StreamReposition JumpInStream;
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    public StreamProperties StreamFamily;
    private double BOI_UR8;
    private double EOI_UR8;
    public double BOR_UR8;
    public double EOR_UR8;
    public double BOS_UR8;
    public double EOS_UR8;
    public double BOF_UR8;
    public double EOF_UR8;
    public long BOA_Record;
    public long EOA_Record;
    private String FilePath;

    public void setMSIE_Item(item inMSIE_Item) {
        this.MSIE_Item = inMSIE_Item;
    }

    public void setStreamFamily(StreamProperties inStreamFamily) {
        this.StreamFamily = inStreamFamily;
    }

    public void setJumpInStream(StreamReposition inJumpInStream) {
        this.JumpInStream = inJumpInStream;
    }

    public void findBOI_EOI() throws GSEException {
        this.BOI_UR8 = this.StreamFamily.findBOI_UR8();
        this.EOI_UR8 = this.StreamFamily.findEOI_UR8();
        this.MSIE_Item.insertUR8("TIME_BOI_DAYS", "TIME_BOI_MSEC_IN_DAY", this.BOI_UR8);
        this.MSIE_Item.insertUR8("TIME_EOI_DAYS", "TIME_EOI_MSEC_IN_DAY", this.EOI_UR8);
    }

    public final double getBOR_UR8() {
        return this.BOR_UR8;
    }

    public final double getEOR_UR8() {
        return this.EOR_UR8;
    }

    public void resolveBeginEndTimeRange(double UserLowUR8, double InputHiUR8) throws GSEException {
        boolean StartATBOI = UserLowUR8 == 0.0 || UserLowUR8 == -1.0;
        boolean StopAtEOD = InputHiUR8 == 0.0;
        boolean StopAtEOI = InputHiUR8 == -1.0;
        this.BOR_UR8 = UserLowUR8;
        this.EOR_UR8 = InputHiUR8;
        LogClient.log(TMlibLogLevel.Domain_High, "Requested BOR/EOR " + this.BOR_UR8 + " " + this.EOR_UR8);
        if (StartATBOI && StopAtEOD) {
            this.BOR_UR8 = this.BOI_UR8;
            this.EOR_UR8 = this.BOI_UR8 + 1.0;
        } else {
            if (StopAtEOD) {
                this.EOR_UR8 = Math.floor(UserLowUR8) + 1.0 - 1.0E-10;
            } else if (StopAtEOI) {
                this.EOR_UR8 = this.EOI_UR8 - 1.0E-10;
            } else if (this.EOR_UR8 == Math.floor(this.EOR_UR8)) {
                this.EOR_UR8 -= 1.0E-10;
            }
            if (this.BOI_UR8 > this.BOR_UR8) {
                this.BOR_UR8 = this.BOI_UR8;
            }
            if (StartATBOI) {
                this.BOR_UR8 = this.BOI_UR8;
            }
        }
        if (UserLowUR8 > this.EOR_UR8) {
            String ErrorMessage = "For Requested Time Range in UR8: " + UserLowUR8 + " " + InputHiUR8 + " the starting time is before the end time.";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.STARTING_TIME_AFTER_END_TIME";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (this.BOI_UR8 > this.EOR_UR8) {
            String ErrorMessage = "For Requested Time Range(UR8): " + UserLowUR8 + " " + InputHiUR8 + " the requested ending time is before the Beginning Of Information: " + this.BOI_UR8;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ENDING_TIME_BEFORE_BOI";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (this.BOR_UR8 > this.EOI_UR8) {
            String ErrorMessage = "For Requested Time Range(UR8): " + UserLowUR8 + " " + InputHiUR8 + " the requested beginning time is after the End Of Information: " + this.BOI_UR8;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.BEGINNING_TIME_AFTER_EOI";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        this.setBOR_UR8(this.BOR_UR8);
        this.setEOR_UR8(this.EOR_UR8);
    }

    public void setBOR_UR8(double inBOR_UR8) throws GSEException {
        this.BOR_UR8 = inBOR_UR8;
        this.MSIE_Item.insertUR8("TIME_BOR_DAYS", "TIME_BOR_MSEC_IN_DAY", this.BOR_UR8);
    }

    public void setEOR_UR8(double inEOR_UR8) throws GSEException {
        this.EOR_UR8 = inEOR_UR8;
        this.MSIE_Item.insertUR8("TIME_EOR_DAYS", "TIME_EOR_MSEC_IN_DAY", this.EOR_UR8);
    }

    public void setBOS_UR8(double inBOS_UR8) throws GSEException {
        this.BOS_UR8 = inBOS_UR8;
        this.MSIE_Item.insertUR8("TIME_BOS_DAYS", "TIME_BOS_MSEC_IN_DAY", this.BOS_UR8);
    }

    public void setEOS_UR8(double inEOS_UR8) throws GSEException {
        this.EOS_UR8 = inEOS_UR8;
        this.MSIE_Item.insertUR8("TIME_EOS_DAYS", "TIME_EOS_MSEC_IN_DAY", this.EOS_UR8);
    }

    public void setBOF_UR8(double inBOF_UR8) throws GSEException {
        this.BOF_UR8 = inBOF_UR8;
        this.MSIE_Item.insertUR8("TIME_BOF_DAYS", "TIME_BOF_MSEC_IN_DAY", this.BOF_UR8);
    }

    public void setEOF_UR8(double inEOF_UR8) throws GSEException {
        this.EOF_UR8 = inEOF_UR8;
        this.MSIE_Item.insertUR8("TIME_EOF_DAYS", "TIME_EOF_MSEC_IN_DAY", this.EOF_UR8);
    }

    public void setBOA_Record(long inBOA_Record) throws GSEException {
        this.BOA_Record = inBOA_Record;
        this.MSIE_Item.insertIntIntoHiddenArea("Time_BOA_Record", (int)this.BOA_Record);
    }

    public void setEOA_Record(long inEOA_Record) throws GSEException {
        this.EOA_Record = inEOA_Record;
        this.MSIE_Item.insertIntIntoHiddenArea("Time_EOA_Record", (int)this.EOA_Record);
    }

    public void setStreamName(String inStreamName) throws GSEException {
        this.FilePath = inStreamName;
        this.MSIE_Item.insertStringInHiddenArea("FILEPATH", inStreamName);
        String[] SplitPath = inStreamName.split(File.separator);
        this.MSIE_Item.insertStringInHiddenArea("FILENAME", SplitPath[SplitPath.length - 1]);
    }

    public void setNumPackets(long NumPackets) throws GSEException {
        this.MSIE_Item.insertIntIntoHiddenArea("Number_Of_Packets_In_File", (int)NumPackets);
    }

    public String getStreamNameFromUR8(double newUR8) throws GSEException {
        LogClient.log(TMlibLogLevel.Stream_High, "In Rollover Stream Searching for file corresponding to UR8: " + newUR8);
        if (newUR8 > this.EOR_UR8) {
            String ErrorMessage = "Requested UR8: " + newUR8 + " past EOR: " + this.EOR_UR8;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.PAST_EOR_FROM_OPEN_NEW_DATA_SOURCE_CALL";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (newUR8 < this.BOR_UR8) {
            String ErrorMessage = "Requested UR8: " + newUR8 + " before BOR: " + this.BOR_UR8;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.BEFORE_BOR_FROM_OPEN_NEW_DATA_SOURCE_CALL";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        String FilePath = this.StreamFamily.getFilePathFromUR8(newUR8);
        if (FilePath == null) {
            String ErrorMessage = "File not found containing the UR8 " + newUR8;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.FILE_NOT_FOUND_FOR_TIME_VALUE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        File FileToOpen = new File(FilePath);
        if (!FileToOpen.exists()) {
            String ErrorMessage = FilePath + " Not in file system";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.FILE_NOT_FOUND";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (FileToOpen.length() == 0L) {
            String ErrorMessage = FilePath + " Has length zero";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ZERO_LENGTH_FILE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        return FilePath;
    }

    public void findBOF_EOF() throws GSEException {
        this.JumpInStream.configure();
        this.BOF_UR8 = this.JumpInStream.getFirstTimeStamp();
        this.EOF_UR8 = this.JumpInStream.getLastTimeStamp();
        this.setBOF_UR8(this.BOF_UR8);
        this.setEOF_UR8(this.EOF_UR8);
        LogClient.log(TMlibLogLevel.Stream_Low, "BOF_UR8:  " + this.BOF_UR8);
        LogClient.log(TMlibLogLevel.Stream_Low, "EOF_UR8:  " + this.EOF_UR8);
        LogClient.log(TMlibLogLevel.Stream_Low, "BOR_UR8:  " + this.BOR_UR8);
        LogClient.log(TMlibLogLevel.Stream_Low, "EOR_UR8:  " + this.EOR_UR8);
    }

    public boolean findGaps(double newUR8) throws GSEException {
        boolean RecursionHappened = false;
        if (this.BOR_UR8 > this.EOF_UR8) {
            if (Math.floor(newUR8 + 1.0) > this.EOR_UR8) {
                this.JumpInStream.TM_Set_Position(this.EOF_UR8);
                String ErrorMessage = "Within in the file: " + this.FilePath + " \n" + "For the time range: BOR " + this.BOR_UR8 + " EOR " + this.EOR_UR8 + "\n" + "No records are present.";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.NO_RECORDS_FOUND_BETWEEN_BEGINNING_AND_END_OF_RANGE";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
            double OpenUR8 = newUR8 + 1.0;
            LogClient.log(TMlibLogLevel.Stream_Low, "Gap at end of File.  openNextFile: ");
            this.JumpInStream.openNextFile();
            RecursionHappened = true;
        }
        return RecursionHappened;
    }

    public void findBOA_EOA(double newUR8) throws GSEException {
        long BOA_Record = 0L;
        if (Math.floor(this.BOR_UR8) + 1.0 > newUR8 && newUR8 >= Math.floor(this.BOR_UR8) && this.BOF_UR8 < this.BOR_UR8) {
            this.JumpInStream.TM_Set_Position(this.BOR_UR8);
            this.setBOS_UR8(this.JumpInStream.getStreamPosition());
            BOA_Record = this.JumpInStream.getRecordIndexInStream();
        }
        this.setBOA_Record(BOA_Record);
        long EOA_Record = this.JumpInStream.getNumRecordsInStream();
        if (Math.floor(this.EOR_UR8) + 1.0 > newUR8 && newUR8 >= Math.floor(this.EOR_UR8) && this.EOF_UR8 > this.EOR_UR8) {
            this.JumpInStream.TM_Set_Position(this.EOR_UR8);
            this.setEOS_UR8(this.JumpInStream.getStreamPosition());
            EOA_Record = this.JumpInStream.getRecordIndexInStream();
        }
        if (BOA_Record == EOA_Record) {
            this.JumpInStream.TM_Set_Position(this.EOF_UR8);
            String ErrorMessage = "Within the time range: \n" + this.BOR_UR8 + " to " + this.EOR_UR8 + "\n" + "Which resolves to the file \n" + this.FilePath + "\nNo records were found";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.NO_RECORDS_FOUND_BETWEEN_BEGINNING_AND_END_OF_RANGE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        this.setEOA_Record(EOA_Record);
    }
}

