/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.StreamReposition;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.Stream_Names_Times;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RollOverStream
implements TMlibStream {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private String FullPathToFile;
    private FileChannel ChannelFromFile = null;
    private long IndexInStream;
    private long NumBytesInStream;
    private long RecordLength;
    private long StartReadbytes;
    private long StopReadbytes;
    private Stream_Names_Times StreamTimesNames = null;
    private StreamReposition JumpInStream;
    private double CurrentFileUR8;

    public String getStreamName() {
        return this.FullPathToFile;
    }

    public void setStream_Names_Times(Stream_Names_Times inStreamTimesNames) {
        this.StreamTimesNames = inStreamTimesNames;
    }

    public boolean isPossibleToSetPosition() {
        return true;
    }

    public void setRecordLength(int inRecordLength) {
        this.RecordLength = inRecordLength;
    }

    public void setJumpInStream(StreamReposition inJumpInStream) throws GSEException {
        this.JumpInStream = inJumpInStream;
    }

    public long getNumRecordsInStream() {
        return this.NumBytesInStream / this.RecordLength;
    }

    public long getRecordIndexInStream() {
        return this.IndexInStream / this.RecordLength;
    }

    public void setRecordIndexInStream(long inRecordIndexNumber) throws GSEException {
        this.IndexInStream = inRecordIndexNumber * this.RecordLength + this.StartReadbytes;
    }

    public void getNextRecord(ByteBuffer RecordToFill) throws GSEException {
        try {
            if (this.IndexInStream >= this.StopReadbytes) {
                throw new Exception();
            }
            RecordToFill.position(0);
            this.ChannelFromFile.position(this.IndexInStream);
            this.ChannelFromFile.read(RecordToFill);
        }
        catch (Exception excep) {
            if (Math.floor(this.CurrentFileUR8 + 1.0) > this.StreamTimesNames.getEOR_UR8()) {
                LogClient.log(TMlibLogLevel.Stream_High, "In Rollover Stream, hit EOR");
                String ErrorMessage = "User request for next record went past EOR UR8: " + this.StreamTimesNames.getEOR_UR8();
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.PAST_EOR_FROM_GET_NEXT_RECORD_CALL";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
            LogClient.log(TMlibLogLevel.Stream_High, "In Rollover Stream, hit EOF");
            this.openNewDataSource(Math.floor(this.CurrentFileUR8 + 1.0));
            this.getNextRecord(RecordToFill);
            this.IndexInStream -= this.RecordLength;
        }
        this.IndexInStream += this.RecordLength;
    }

    public void getLastRecord(ByteBuffer RecordToFill) throws GSEException {
    }

    public void openFirstFile() throws GSEException {
        this.openNewDataSource(this.StreamTimesNames.getBOR_UR8());
    }

    public void openNewDataSource(double newUR8) throws GSEException {
        if (this.ChannelFromFile != null) {
            this.closeFiles();
        }
        if (newUR8 == 0.0) {
            newUR8 = this.StreamTimesNames.getBOR_UR8();
        }
        try {
            this.FullPathToFile = this.StreamTimesNames.getStreamNameFromUR8(newUR8);
            this.CurrentFileUR8 = newUR8;
            File StreamAsFile = new File(this.FullPathToFile);
            LogClient.log(TMlibLogLevel.Stream_High, "In Rollover Stream Opening new file: \n" + StreamAsFile.getCanonicalPath());
            this.StreamTimesNames.setStreamName(StreamAsFile.getCanonicalPath());
            FileInputStream FileStream2 = new FileInputStream(this.FullPathToFile);
            this.ChannelFromFile = FileStream2.getChannel();
            this.StopReadbytes = this.ChannelFromFile.size();
            this.NumBytesInStream = (int)this.ChannelFromFile.size();
            this.StreamTimesNames.setNumPackets(this.getNumRecordsInStream());
            this.IndexInStream = 0L;
            this.StartReadbytes = 0L;
        }
        catch (IOException excep) {
            String ErrorMessage = "Error Trying to open file: " + this.FullPathToFile;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ERROR_TRYING_TO_OPEN_FILE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        this.StreamTimesNames.findBOF_EOF();
        boolean RecursionCalledForNewFile = this.StreamTimesNames.findGaps(newUR8);
        if (!RecursionCalledForNewFile) {
            this.setLimits(newUR8);
        }
    }

    private void setLimits(double newUR8) throws GSEException {
        this.StreamTimesNames.findBOA_EOA(newUR8);
        this.StartReadbytes = this.StreamTimesNames.BOA_Record * this.RecordLength;
        this.StopReadbytes = this.StreamTimesNames.EOA_Record * this.RecordLength;
        this.NumBytesInStream = this.StopReadbytes - this.StartReadbytes;
        this.IndexInStream = this.StartReadbytes;
        this.JumpInStream.configure();
    }

    private void closeFiles() {
        try {
            this.ChannelFromFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws GSEException {
        this.closeFiles();
        LogClient.log(TMlibLogLevel.Stream_High, "Close Rollover Stream");
    }
}

