/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileStream
implements TMlibStream {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private String FullPathToFile = "";
    private FileChannel ChannelFromFile = null;
    private long NumBytesInStream;
    private long IndexInStream = 0L;
    private long RecordLength;

    public FileStream(String inFullPathToFile) throws GSEException {
        this.FullPathToFile = inFullPathToFile;
        try {
            File DataFile = new File(this.FullPathToFile);
            this.NumBytesInStream = DataFile.length();
            if (!DataFile.exists()) {
                String ErrorMessage = this.FullPathToFile + " Not in file system";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.FILE_NOT_FOUND";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
            if (this.NumBytesInStream == 0L) {
                String ErrorMessage = this.FullPathToFile + " Has length zero";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ZERO_LENGTH_FILE";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
            FileInputStream FileInStream = new FileInputStream(this.FullPathToFile);
            this.ChannelFromFile = FileInStream.getChannel();
            this.IndexInStream = 0L;
            LogClient.log(TMlibLogLevel.Stream_High, "In FileStream opening  file: \n" + DataFile.getCanonicalPath());
        }
        catch (IOException excep) {
            String ErrorMessage = "Error Trying to open file: " + this.FullPathToFile;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ERROR_TRYING_TO_OPEN_FILE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
    }

    public boolean isPossibleToSetPosition() {
        return true;
    }

    public String getStreamName() {
        return this.FullPathToFile;
    }

    public void setRecordLength(int inRecordLength) {
        this.RecordLength = inRecordLength;
    }

    public long getNumRecordsInStream() {
        return this.NumBytesInStream / this.RecordLength;
    }

    public void setRecordIndexInStream(long inRecordNumber) throws GSEException {
        this.IndexInStream = inRecordNumber * this.RecordLength;
    }

    public long getRecordIndexInStream() {
        return this.IndexInStream / this.RecordLength;
    }

    public void getNextRecord(ByteBuffer RecordToFill) throws GSEException {
        try {
            if (this.IndexInStream >= this.NumBytesInStream) {
                throw new Exception();
            }
            RecordToFill.position(0);
            this.ChannelFromFile.position(this.IndexInStream);
            this.ChannelFromFile.read(RecordToFill);
            this.IndexInStream += this.RecordLength;
        }
        catch (Exception excep) {
            LogClient.log(TMlibLogLevel.Stream_High, "File Stream hit EOF");
            String ErrorMessage = "End of file hit for file: " + this.FullPathToFile;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.END_OF_FILE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
    }

    public void getLastRecord(ByteBuffer RecordToFill) throws GSEException {
    }

    public void openNewDataSource(double newFileSpec) throws GSEException {
        String ErrorMessage = "Current file " + this.FullPathToFile;
        String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.CANNOT_OPEN_NEW_DATA_SOURCE_IN_FILESTREAM";
        throw new GSEException(ErrorMessage, ErrorCode);
    }

    public void close() throws GSEException {
        try {
            this.ChannelFromFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogClient.log(TMlibLogLevel.Stream_High, "Close File Stream");
    }
}

