/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.GSEException.TMlibErrorStack;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class DaqStream
implements TMlibStream {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private TMlibErrorStack ErrorStack = new TMlibErrorStack();
    private ByteBuffer FourByteBuff = ByteBuffer.allocate(4);
    private static SocketChannel TcpConnectionToDAQ = null;
    private InetSocketAddress MOC_Address;
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private CharsetDecoder AsciiDecoder = this.AsciiCharset.newDecoder();
    private ByteBuffer MetaData = ByteBuffer.allocate(30);
    private static final int SPACECRAFT_REQUEST_CODE = 512;
    private static final int CONTEXT_REQUEST_CODE = 768;
    private int DaqReaderSleep;
    private int LimitFails;
    private int port;
    private String host;

    public DaqStream() throws GSEException {
        if (TcpConnectionToDAQ == null) {
            ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
            this.DaqReaderSleep = propData.getInt("Java#*TMDAQring#*ReaderSleep_ms");
            this.LimitFails = propData.getInt("Java#*TMDAQring#*Reader_LimitFails");
            this.port = propData.getInt("Java#*TMDAQring#*Port_Of_DAQ");
            this.host = propData.getStr("Java#*TMDAQring#*Host_For_DAQ");
            try {
                LogClient.log(TMlibLogLevel.Stream_High, "Opening DAQ Stream");
                this.MOC_Address = new InetSocketAddress(InetAddress.getByName(this.host), this.port);
                TcpConnectionToDAQ = SocketChannel.open();
                TcpConnectionToDAQ.connect(this.MOC_Address);
                TcpConnectionToDAQ.configureBlocking(true);
            }
            catch (IOException excep) {
                String ErrorMessage = "Connection to DAQ failed ";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.CANNOT_CONNECT_TO_DAQ";
                throw new GSEException(ErrorMessage, ErrorCode);
            }
        }
    }

    public String getStreamName() {
        return "realtime";
    }

    public boolean isPossibleToSetPosition() {
        return false;
    }

    public void setRecordLength(int inRecordLength) {
    }

    public long getNumRecordsInStream() throws GSEException {
        return -1L;
    }

    public void setRecordIndexInStream(long RecordNumber) throws GSEException {
        String ErrorMessage = "The DAQ stream does not have a setRecordIndexInStream method";
        String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.STREAM_METHOD_NOT_IMPLEMENTED";
        throw new GSEException(ErrorMessage, ErrorCode);
    }

    public long getRecordIndexInStream() {
        return -1L;
    }

    public void getLastRecord(ByteBuffer RecordToFill) throws GSEException {
        String ErrorMessage = "The DAQ stream does not have a getLastRecord method";
        String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.STREAM_METHOD_NOT_IMPLEMENTED";
        throw new GSEException(ErrorMessage, ErrorCode);
    }

    public void getNextRecord(ByteBuffer RecordFromRing) throws GSEException {
        boolean NeedData = true;
        while (NeedData) {
            try {
                this.FourByteBuff.clear();
                this.FourByteBuff.putInt(256);
                this.FourByteBuff.flip();
                int NumFails = 0;
                while (this.FourByteBuff.hasRemaining()) {
                    TcpConnectionToDAQ.write(this.FourByteBuff);
                    if (!this.FourByteBuff.hasRemaining()) continue;
                    if (++NumFails < this.LimitFails) {
                        this.sleeper(this.DaqReaderSleep);
                        continue;
                    }
                    throw new IOException();
                }
                NumFails = 0;
                while (RecordFromRing.hasRemaining()) {
                    TcpConnectionToDAQ.read(RecordFromRing);
                    if (!RecordFromRing.hasRemaining()) continue;
                    if (++NumFails < this.LimitFails) {
                        this.sleeper(this.DaqReaderSleep);
                        continue;
                    }
                    throw new IOException();
                }
                NeedData = false;
            }
            catch (IOException excep) {
                boolean isConnected = false;
                String ErrorMessage = "Client disconnected from DAQ in getNextRecord";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.CLIENT_DISCONNECTED_FROM_DAQ";
                this.ErrorStack.enterElementIntoStack(new GSEException(ErrorMessage, ErrorCode));
                LogClient.log(TMlibLogLevel.Stream_High, ErrorMessage);
                while (!isConnected) {
                    try {
                        if (!isConnected) {
                            this.sleeper(750);
                        }
                        TcpConnectionToDAQ.close();
                        TcpConnectionToDAQ = SocketChannel.open();
                        TcpConnectionToDAQ.connect(this.MOC_Address);
                        TcpConnectionToDAQ.configureBlocking(true);
                        isConnected = true;
                    }
                    catch (IOException excepII) {
                        isConnected = false;
                    }
                }
                LogClient.log(TMlibLogLevel.Stream_High, "Client reconnected to DAQ");
            }
        }
    }

    private String getNonRecordInfoFromDaq(int requestCode) {
        boolean NeedData = true;
        while (NeedData) {
            try {
                this.FourByteBuff.clear();
                this.FourByteBuff.putInt(requestCode);
                this.FourByteBuff.flip();
                while (this.FourByteBuff.hasRemaining()) {
                    TcpConnectionToDAQ.write(this.FourByteBuff);
                    if (!this.FourByteBuff.hasRemaining()) continue;
                    this.sleeper(this.DaqReaderSleep);
                }
                this.FourByteBuff.clear();
                while (this.FourByteBuff.hasRemaining()) {
                    TcpConnectionToDAQ.read(this.FourByteBuff);
                    if (!this.FourByteBuff.hasRemaining()) continue;
                    this.sleeper(this.DaqReaderSleep);
                }
                this.MetaData.clear();
                int NumBytes = this.FourByteBuff.getInt(0);
                this.MetaData.limit(NumBytes);
                while (this.MetaData.hasRemaining()) {
                    TcpConnectionToDAQ.read(this.MetaData);
                    if (!this.MetaData.hasRemaining()) continue;
                    this.sleeper(this.DaqReaderSleep);
                }
                NeedData = false;
            }
            catch (IOException excep) {
                boolean isConnected = false;
                String ErrorMessage = "Client disconnected from DAQ in getSpacecraftName";
                String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.CLIENT_DISCONNECTED_FROM_DAQ";
                this.ErrorStack.enterElementIntoStack(new GSEException(ErrorMessage, ErrorCode));
                LogClient.log(TMlibLogLevel.Stream_High, ErrorMessage);
                while (!isConnected) {
                    try {
                        if (isConnected) {
                            this.sleeper(750);
                        }
                        TcpConnectionToDAQ = SocketChannel.open();
                        TcpConnectionToDAQ.connect(this.MOC_Address);
                        TcpConnectionToDAQ.configureBlocking(true);
                        isConnected = true;
                    }
                    catch (IOException excepII) {
                        isConnected = false;
                    }
                }
                LogClient.log(TMlibLogLevel.Stream_High, "Client reconnected to DAQ");
            }
        }
        this.MetaData.flip();
        String StringMetaData = null;
        try {
            StringMetaData = this.AsciiDecoder.decode(this.MetaData).toString();
        }
        catch (CharacterCodingException exp) {
            // empty catch block
        }
        return StringMetaData;
    }

    public String getSpacecraftCode() {
        return this.getNonRecordInfoFromDaq(512);
    }

    public String getContextCode() {
        return this.getNonRecordInfoFromDaq(768);
    }

    public void openNewDataSource(double newFileSpec) throws GSEException {
        String ErrorMessage = "Only one connection to the DAQ is allowed";
        String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.CANNOT_OPEN_NEW_DATA_SOURCE_IN_DAQSTREAM";
        throw new GSEException(ErrorMessage, ErrorCode);
    }

    public void close() throws GSEException {
        try {
            this.FourByteBuff.clear();
            this.FourByteBuff.putInt(57005);
            this.FourByteBuff.flip();
            while (this.FourByteBuff.hasRemaining()) {
                TcpConnectionToDAQ.write(this.FourByteBuff);
                if (!this.FourByteBuff.hasRemaining()) continue;
                this.sleeper(this.DaqReaderSleep);
            }
        }
        catch (Exception excep) {
            String ErrorMessage = "Error while closing connection to DAQ";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.EXCEPTION_WHILE_CLOSING_DAQ";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        TcpConnectionToDAQ = null;
        LogClient.log(TMlibLogLevel.Stream_High, "Close DAQ Stream");
    }

    private void sleeper(int MilliSec) {
        try {
            Thread.sleep(MilliSec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

