/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.StreamReposition;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.StreamCache;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.StreamParameters;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.stereoLib.item.itemparser.ReadFile.VariableRecordLength_UR8Rules_Plugin;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public abstract class AbstractTextStream
implements TMlibStream {
    protected static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private CharsetDecoder AsciiDecoder = this.AsciiCharset.newDecoder();
    private StreamCache CacheOfFileStreams = new StreamCache();
    protected FileChannel ChannelFromFile;
    protected long IndexInStream;
    protected long RecordLength = 0L;
    protected long NumBytesInStream;
    protected long StartReadbytes;
    protected int LengthOfLineTerminator;
    protected int MaxHeader;
    protected ByteBuffer Line;
    protected double CurrentFileUR8;
    protected VariableRecordLength_UR8Rules_Plugin UR8Properties;
    protected StreamProperties StreamFamily;
    protected StreamReposition JumpInStream;
    protected String FilePath;
    protected ByteBuffer RecordDelimiter;
    protected ByteBuffer RecordDelimiterTest;

    public AbstractTextStream() throws GSEException {
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        this.MaxHeader = propData.getInt("TMlibStream#*LimitForHeaderSize");
    }

    public void setStreamFamily(StreamProperties inStreamFamily) {
        this.StreamFamily = inStreamFamily;
    }

    public void setLINE_MAX(int LINE_MAX) {
        this.Line = ByteBuffer.allocate(LINE_MAX);
    }

    public void setUR8Properties(VariableRecordLength_UR8Rules_Plugin inUR8Properties) {
        this.UR8Properties = inUR8Properties;
    }

    public boolean isPossibleToSetPosition() {
        return true;
    }

    public void setRecordLength(int inRecordLength) {
        this.RecordLength = inRecordLength;
    }

    public long getRecordLength() {
        return this.RecordLength;
    }

    public void setJumpInStream(StreamReposition inJumpInStream) {
        this.JumpInStream = inJumpInStream;
    }

    public long getNumRecordsInStream() {
        return this.NumBytesInStream / this.RecordLength;
    }

    public void setRecordIndexInStream(long inRecordIndexNumber) throws GSEException {
        this.IndexInStream = inRecordIndexNumber * this.RecordLength + this.StartReadbytes;
    }

    public long getRecordIndexInStream() {
        return this.IndexInStream / this.RecordLength;
    }

    public String getStreamName() {
        return this.FilePath;
    }

    public abstract void getNextRecord(ByteBuffer var1) throws GSEException;

    public abstract void getLastRecord(ByteBuffer var1) throws GSEException;

    public void setRecordDelimiter(String StrRecordDelimiter) {
        if (StrRecordDelimiter.equals("\\n")) {
            this.RecordDelimiter = ByteBuffer.allocate(1);
            this.RecordDelimiter.put(0, (byte)10);
        } else if (StrRecordDelimiter.equals("\\r")) {
            this.RecordDelimiter = ByteBuffer.allocate(1);
            this.RecordDelimiter.put(0, (byte)13);
        } else if (StrRecordDelimiter.equals("\\r\\n")) {
            this.RecordDelimiter = ByteBuffer.allocate(2);
            this.RecordDelimiter.put(0, (byte)13);
            this.RecordDelimiter.put(1, (byte)10);
        } else {
            this.RecordDelimiter = this.AsciiCharset.encode(StrRecordDelimiter);
        }
        this.LengthOfLineTerminator = this.RecordDelimiter.capacity();
        this.RecordDelimiterTest = ByteBuffer.allocate(this.LengthOfLineTerminator);
    }

    protected boolean testForRecordTerminator(ByteBuffer BuffToTest) {
        boolean BufferMatches = false;
        int NumberOfBytesThatMatch = 0;
        for (int i = 0; i < this.LengthOfLineTerminator && this.RecordDelimiter.get(i) == BuffToTest.get(i); ++i) {
            ++NumberOfBytesThatMatch;
        }
        if (NumberOfBytesThatMatch == this.LengthOfLineTerminator) {
            BufferMatches = true;
        }
        return BufferMatches;
    }

    public void openNewDataSource(double newUR8) throws GSEException {
        if (this.ChannelFromFile != null) {
            this.closeFiles();
        }
        this.ChannelFromFile = this.configTextFile(newUR8);
        this.IndexInStream = this.StartReadbytes;
        this.JumpInStream.configure();
        this.CurrentFileUR8 = newUR8;
    }

    private FileChannel configTextFile(double newUR8) throws GSEException {
        LogClient.log(TMlibLogLevel.Stream_Low, "In ASCII Stream searching for file corresponding to UR8: " + newUR8);
        this.FilePath = this.StreamFamily.getFilePathFromUR8(newUR8);
        if (this.FilePath == null) {
            LogClient.log(TMlibLogLevel.Stream_High, "Could not find file based on UR8: \n " + newUR8);
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ANCILLARY_FILE_COULD_NOT_BE_LOCATED";
            String ErrorMessage = "For the UR8: " + newUR8 + "\n" + "No ancillary file could be found ";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        LogClient.log(TMlibLogLevel.Stream_High, "In ASCII Stream opening new file: \n " + this.FilePath);
        StreamParameters theNextStream = null;
        theNextStream = this.obtainStreamParameters(this.FilePath);
        this.RecordLength = theNextStream.RecordLength;
        this.StartReadbytes = theNextStream.StartReadbytes;
        this.NumBytesInStream = theNextStream.NumBytesInStream;
        LogClient.log(TMlibLogLevel.Stream_Low, "In ASCII Stream  \nRecordLength:     " + theNextStream.RecordLength + "\n" + "StartReadbytes:   " + theNextStream.StartReadbytes + "\n" + "NumBytesInStream: " + theNextStream.NumBytesInStream);
        return theNextStream.TheStream;
    }

    private StreamParameters obtainStreamParameters(String FilePath) throws GSEException {
        this.StartReadbytes = 0L;
        int LineCount = 0;
        FileInputStream TheFileStream = null;
        FileChannel NewChannelToFile = null;
        try {
            TheFileStream = new FileInputStream(FilePath);
            NewChannelToFile = TheFileStream.getChannel();
            BufferedReader BuffRead = new BufferedReader(new InputStreamReader(TheFileStream));
            while (this.MaxHeader > LineCount) {
                String line = this.NIO_ReadLine(NewChannelToFile);
                boolean GoodTimeStamp = this.UR8Properties.isValidColumn(line);
                if (GoodTimeStamp) {
                    int SigmaRecordLength = 0;
                    int Count = 25;
                    for (int i = 0; i < Count; ++i) {
                        line = this.NIO_ReadLine(NewChannelToFile);
                        SigmaRecordLength += line.length() + this.LengthOfLineTerminator;
                    }
                    this.RecordLength = SigmaRecordLength / Count;
                    break;
                }
                ++LineCount;
                this.StartReadbytes += (long)(line.length() + this.LengthOfLineTerminator);
            }
            this.NumBytesInStream = NewChannelToFile.size() - this.StartReadbytes;
        }
        catch (IOException excep) {
            excep.printStackTrace();
            String ErrorMessage = "Error Trying to open file: " + FilePath;
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.ERROR_TRYING_TO_OPEN_FILE";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (LineCount == this.MaxHeader) {
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.FILE_BAD_COULD_NOT_FIND_END_OF_HEADER";
            String ErrorMessage = "In the file: " + FilePath + "\n" + "The end of the header was not found after " + this.MaxHeader + " lines.  Assume that the file is bad";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        StreamParameters NewStreamParameters = new StreamParameters();
        NewStreamParameters.TheStream = NewChannelToFile;
        NewStreamParameters.RecordLength = this.RecordLength;
        NewStreamParameters.NumBytesInStream = this.NumBytesInStream;
        NewStreamParameters.StartReadbytes = this.StartReadbytes;
        this.CacheOfFileStreams.put(FilePath, NewStreamParameters);
        return NewStreamParameters;
    }

    protected String NIO_ReadLine(FileChannel ChannelToFile) {
        String StrLine = null;
        try {
            this.Line.clear();
            long BeginningOfRecord = ChannelToFile.position();
            long Spot = ChannelToFile.position();
            this.zerosInBuffer(this.RecordDelimiterTest);
            while (!this.testForRecordTerminator(this.RecordDelimiterTest)) {
                this.RecordDelimiterTest.clear();
                ChannelToFile.position(Spot);
                ChannelToFile.read(this.RecordDelimiterTest);
                ++Spot;
            }
            ChannelToFile.position(BeginningOfRecord);
            this.Line.position(0);
            this.Line.limit((int)(Spot - BeginningOfRecord - 1L));
            ChannelToFile.read(this.Line);
            this.Line.position(0);
            ChannelToFile.position(ChannelToFile.position() + (long)this.LengthOfLineTerminator);
            StrLine = this.AsciiDecoder.decode(this.Line).toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return StrLine;
    }

    protected void zerosInBuffer(ByteBuffer BuffToClear) {
        BuffToClear.clear();
        for (int i = 0; i < BuffToClear.capacity(); ++i) {
            BuffToClear.put(i, (byte)0);
        }
        BuffToClear.clear();
    }

    private void closeFiles() {
        try {
            this.ChannelFromFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws GSEException {
        this.closeFiles();
        LogClient.log(TMlibLogLevel.Stream_High, "Close ASCII Stream");
    }
}

