/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.DAQ_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.GGS_KAG_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.LZ_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.NULL_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.PTP_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.Renamed_LZ_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.Renamed_PTPDAQ_StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStreamFactory;
import edu.umn.space.swaves.util.xml.SearchConfigFileList;
import java.io.File;
import java.util.LinkedList;

public class StreamFamilySelector {
    private static final String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.MSIE.";
    private static final String Sep = File.separator;

    public static StreamProperties getStreamFamilyFromMSI(String MissionName, String SpaceCraftName, String InstrumentName) throws GSEException {
        SearchConfigFileList ConfigFiles = new SearchConfigFileList();
        String LZRoot = ConfigFiles.getLZ_ROOT(MissionName);
        SpaceCraftName = SpaceCraftName.toLowerCase().trim();
        String SpaceCraftPath = "Ahead";
        if (SpaceCraftName.equals("stereo_b")) {
            SpaceCraftPath = "Behind";
        }
        String DataPath = LZRoot + Sep + MissionName + Sep + SpaceCraftPath + Sep + InstrumentName;
        File PathInFileSystem = new File(DataPath);
        String[] AllTheFiles = PathInFileSystem.list();
        StreamProperties StreamFamily = null;
        if (AllTheFiles != null) {
            for (int i = 0; i < AllTheFiles.length && (StreamFamily = StreamFamilySelector.getStreamFamilyFromStreamName(AllTheFiles[i])).getSpacecraftName() == null; ++i) {
            }
        }
        if (StreamFamily == null) {
            StreamFamily = new NULL_StreamProperties();
        }
        StreamFamily.setFileDirectory(DataPath);
        return StreamFamily;
    }

    public static StreamProperties getStreamFamilyFromStreamNameMission(String StreamName, String MissionName) throws GSEException {
        String FileName = TMlibStreamFactory.deriveFileName(StreamName, MissionName);
        return StreamFamilySelector.getStreamFamilyFromStreamName(FileName);
    }

    public static StreamProperties getStreamFamilyFromStreamName(String StreamName) throws GSEException {
        LinkedList PossibleStreamFamily = StreamFamilySelector.getListOffamilies();
        StreamProperties Canidate = null;
        for (int i = 0; i < PossibleStreamFamily.size() && !(Canidate = (StreamProperties)PossibleStreamFamily.get(i)).isFamilyMember(StreamName); ++i) {
        }
        return Canidate;
    }

    private static LinkedList getListOffamilies() {
        LinkedList<StreamProperties> StreamFamilies = new LinkedList<StreamProperties>();
        NULL_StreamProperties OutputFamily = new NULL_StreamProperties();
        StreamFamilies.add(new DAQ_StreamProperties());
        StreamFamilies.add(new LZ_StreamProperties());
        StreamFamilies.add(new PTP_StreamProperties());
        StreamFamilies.add(new GGS_KAG_StreamProperties());
        StreamFamilies.add(new Renamed_PTPDAQ_StreamProperties());
        StreamFamilies.add(new Renamed_LZ_StreamProperties());
        return StreamFamilies;
    }
}

