/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins;

import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StartsWithStringFileFilter;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.util.Conversions.DateTimeConversions;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LZ_StreamProperties
implements StreamProperties {
    private DateTimeConversions DateConvert = new DateTimeConversions(1982, 0, 0, 0, 0, 0, 0);
    private String StreamName;
    private String SpaceCraftName;
    private String AheadOrBehind;
    private File Dir;
    Pattern StreamNameRegex = Pattern.compile(".*swaves_(ahead|behind)_\\d{4}?_\\d{3}?_\\d{1}?.*");

    public String getSpacecraftName() {
        Matcher MatchRegex = this.StreamNameRegex.matcher(this.StreamName);
        MatchRegex.find();
        this.AheadOrBehind = MatchRegex.group(1);
        this.SpaceCraftName = null;
        if (this.AheadOrBehind.equals("ahead")) {
            this.SpaceCraftName = "stereo_a";
        }
        if (this.AheadOrBehind.equals("behind")) {
            this.SpaceCraftName = "stereo_b";
        }
        return this.SpaceCraftName;
    }

    public double getUR8(String Filename) {
        String[] SubFile = Filename.split("_");
        int Year = Integer.valueOf(SubFile[2], 10);
        int DOY = Integer.valueOf(SubFile[3], 10);
        this.DateConvert.setYear(Year);
        this.DateConvert.setDOY(DOY);
        return this.DateConvert.getUR8Time();
    }

    public boolean isFamilyMember(String inStreamName) {
        this.StreamName = inStreamName.toLowerCase();
        Matcher MatchRegex = this.StreamNameRegex.matcher(this.StreamName);
        return MatchRegex.find();
    }

    public String getContext() {
        return "spacecraft_l0_ptp";
    }

    public String selectBestFile(String CurrentBestLZName, String CanidateLZName) {
        String CanidateAppend;
        String CurentAppend = CurrentBestLZName.split("\\.")[1];
        if (CurentAppend.equals(CanidateAppend = CanidateLZName.split("\\.")[1])) {
            if (CanidateLZName.compareToIgnoreCase(CurrentBestLZName) > 0) {
                CurrentBestLZName = CanidateLZName;
            }
        } else if (CanidateAppend.equals("fin")) {
            CurrentBestLZName = CanidateLZName;
        }
        return CurrentBestLZName;
    }

    public void setFileDirectory(String Directory) {
        this.Dir = new File(Directory);
    }

    public String getFilePathFromUR8(double inUR8) {
        String FilePath;
        this.DateConvert.setUR8Time(inUR8);
        int Year = this.DateConvert.getYear();
        String DOY = this.DateConvert.getDOY_3CharString();
        String StartOfFile = "swaves_" + this.AheadOrBehind + "_" + Integer.toString(Year) + "_" + DOY;
        StartsWithStringFileFilter FileFilter2 = new StartsWithStringFileFilter();
        FileFilter2.setStartofFile(StartOfFile);
        File[] FilesWithRightUR8 = this.Dir.listFiles(FileFilter2);
        if (FilesWithRightUR8.length == 0) {
            FilePath = null;
        } else {
            FilePath = FilesWithRightUR8[0].getPath();
            for (int i = 1; i < FilesWithRightUR8.length; ++i) {
                FilePath = this.selectBestFile(FilePath, FilesWithRightUR8[i].getPath());
            }
        }
        return FilePath;
    }

    public double findBOI_UR8() {
        double BOI_UR8 = -1.0;
        Object[] FilesInDir = this.Dir.list();
        Arrays.sort(FilesInDir);
        for (int i = 0; i < FilesInDir.length; ++i) {
            if (!this.isFamilyMember((String)FilesInDir[i])) continue;
            BOI_UR8 = this.getUR8((String)FilesInDir[i]);
            break;
        }
        return BOI_UR8;
    }

    public double findEOI_UR8() {
        double EOI_UR8 = -1.0;
        Object[] FilesInDir = this.Dir.list();
        Arrays.sort(FilesInDir);
        for (int i = FilesInDir.length - 1; i > 0; --i) {
            if (!this.isFamilyMember((String)FilesInDir[i])) continue;
            EOI_UR8 = this.getUR8((String)FilesInDir[i]) + 1.0;
            break;
        }
        return EOI_UR8;
    }
}

