/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.Stream.Reposition;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.RepositionRules_Plugin;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;

public class StreamReposition {
    private static final String ErrPath = "Universe.edu.umn.space.swaves.stereoLib.stream.";
    public static final double GOTO_BOR = 0.0;
    public static final String UR8forGetTime = "GetTime_UR8";
    private TMlibStream TMStream;
    private RepositionRules_Plugin UR8Rules_Plugin;
    private double FirstUR8 = -1.0;
    private double LastUR8 = -1.0;
    private double DeltaUR8 = 0.0;
    private long NumRecordsInStream;
    private long RecordLocationInStream;
    private long MarkRecordLocationInStream;

    public StreamReposition(TMlibStream inTMStream, RepositionRules_Plugin inUR8Rules_Plugin) throws GSEException {
        this.UR8Rules_Plugin = inUR8Rules_Plugin;
        this.TMStream = inTMStream;
    }

    public double getFirstTimeStamp() {
        return this.FirstUR8;
    }

    public double getLastTimeStamp() {
        return this.LastUR8;
    }

    public void configure() throws GSEException {
        if (this.TMStream.isPossibleToSetPosition()) {
            this.FirstUR8 = this.UR8Rules_Plugin.getStreamPosition(0L);
            this.NumRecordsInStream = this.TMStream.getNumRecordsInStream();
            this.LastUR8 = this.UR8Rules_Plugin.getStreamPosition(this.NumRecordsInStream - 1L);
            this.TMStream.setRecordIndexInStream(0L);
            this.RecordLocationInStream = 0L;
            this.DeltaUR8 = (this.LastUR8 - this.FirstUR8) / (double)(this.NumRecordsInStream - 1L);
        }
    }

    public void openNextFile() throws GSEException {
        this.TMStream.openNewDataSource(this.FirstUR8 + 1.0);
    }

    public void TM_Set_Position(double TargetUR8) throws GSEException {
        LogClient.log(TMlibLogLevel.Stream_Low, "In TM_Set_Position setting Position to: " + TargetUR8);
        if (!this.TMStream.isPossibleToSetPosition()) {
            String ErrorMessage = "The current stream does not support TM_Set_Position";
            String ErrorCode = "Universe.edu.umn.space.swaves.stereoLib.stream.STREAM_DOES_NOT_SUPPORT_SET_POSITION";
            throw new GSEException(ErrorMessage, ErrorCode);
        }
        if (TargetUR8 == 0.0) {
            this.TMStream.openNewDataSource(0.0);
        } else {
            boolean HitPointExactly = this.openNewTMlibStreamIfNeeded(TargetUR8);
            if (!HitPointExactly) {
                this.binaryHuntForUR8(TargetUR8);
            }
        }
    }

    private boolean openNewTMlibStreamIfNeeded(double TargetUR8) throws GSEException {
        boolean HitPointExactly = false;
        if (TargetUR8 < this.FirstUR8 || TargetUR8 > this.LastUR8) {
            LogClient.log(TMlibLogLevel.Stream_Low, "Open new file from set position \nBecause: (TargetUR8 < FirstUR8) || (TargetUR8 > LastUR8) \nFirstUR8 " + this.FirstUR8 + "\n" + "LastUR8 " + this.LastUR8 + "\n" + "TargetUR8 " + TargetUR8 + "\n");
            this.TMStream.openNewDataSource(TargetUR8);
        }
        if (TargetUR8 < this.FirstUR8) {
            LogClient.log(TMlibLogLevel.Stream_Low, " TargetUR8 < FirstUR8 openNewDataSource\nFirstUR8 " + this.FirstUR8 + "\n" + "LastUR8 " + this.LastUR8 + "\n" + "TargetUR8 " + TargetUR8 + "\n");
            this.TMStream.openNewDataSource(TargetUR8 - 25.0 * this.DeltaUR8);
            this.TMStream.setRecordIndexInStream(this.NumRecordsInStream);
            HitPointExactly = true;
        }
        return HitPointExactly;
    }

    private void binaryHuntForUR8(double TargetUR8) throws GSEException {
        this.RecordLocationInStream = (int)Math.round((TargetUR8 - this.FirstUR8) / this.DeltaUR8);
        long MagnitudeStep = 1L;
        long Step = 0L;
        boolean MaxHit = false;
        LogClient.log(TMlibLogLevel.Stream_Low, "Start of binaryHuntForUR8 \nFirstUR8 " + this.FirstUR8 + "\n" + "LastUR8 " + this.LastUR8 + "\n" + "TargetUR8 " + TargetUR8 + "\n");
        double CurrentUR8 = this.UR8Rules_Plugin.getStreamPosition(this.RecordLocationInStream);
        double ErrorInUR8 = CurrentUR8 - TargetUR8;
        int DirectionToStep = ErrorInUR8 < 0.0 ? 1 : -1;
        int LastDirection = 0;
        while (MagnitudeStep != 0L) {
            Step = (long)DirectionToStep * MagnitudeStep;
            LogClient.log(TMlibLogLevel.Stream_Low, "In binaryHuntForUR8 loop \nFirstUR8                " + this.FirstUR8 + "\n" + "LastUR8                 " + this.LastUR8 + "\n" + "CurrentUR8              " + CurrentUR8 + "\n" + "RecordLocationInStream  " + this.RecordLocationInStream + "\n" + "Step                    " + Step + "\n" + "ErrorInUR8              " + ErrorInUR8 + "\n" + "TargetUR8               " + TargetUR8);
            if (this.RecordLocationInStream + Step <= 0L) {
                if (MagnitudeStep == 1L) {
                    CurrentUR8 = this.UR8Rules_Plugin.getStreamPosition(1L);
                    this.RecordLocationInStream = 0L;
                    break;
                }
                MaxHit = true;
                for (MagnitudeStep = 1L; MagnitudeStep < this.RecordLocationInStream; MagnitudeStep *= 2L) {
                }
                this.RecordLocationInStream = 0L;
                DirectionToStep = 1;
                continue;
            }
            if (this.RecordLocationInStream + Step > this.NumRecordsInStream) {
                if (MagnitudeStep == 1L) {
                    CurrentUR8 = this.UR8Rules_Plugin.getStreamPosition((int)this.NumRecordsInStream);
                    break;
                }
                MaxHit = true;
                for (MagnitudeStep = 1L; MagnitudeStep < this.NumRecordsInStream - this.RecordLocationInStream; MagnitudeStep *= 2L) {
                }
                this.RecordLocationInStream = this.NumRecordsInStream - 1L;
                DirectionToStep = -1;
                continue;
            }
            this.RecordLocationInStream += Step;
            CurrentUR8 = this.UR8Rules_Plugin.getStreamPosition(this.RecordLocationInStream);
            ErrorInUR8 = CurrentUR8 - TargetUR8;
            LastDirection = DirectionToStep;
            int n = DirectionToStep = ErrorInUR8 < 0.0 ? 1 : -1;
            if (LastDirection != DirectionToStep) {
                MaxHit = true;
            }
            if (MaxHit) {
                MagnitudeStep /= 2L;
                continue;
            }
            MagnitudeStep *= 2L;
        }
        this.UR8Rules_Plugin.getStreamPositionBySingleStep(TargetUR8, this.RecordLocationInStream, ErrorInUR8);
        LogClient.log(TMlibLogLevel.Stream_Low, "End of binaryHuntForUR8 \nFirstUR8                " + this.FirstUR8 + "\n" + "LastUR8                 " + this.LastUR8 + "\n" + "CurrentUR8              " + CurrentUR8 + "\n" + "RecordLocationInStream  " + this.RecordLocationInStream + "\n" + "Step                    " + Step + "\n" + "ErrorInUR8              " + ErrorInUR8 + "\n" + "TargetUR8               " + TargetUR8);
    }

    public double getStreamPosition() throws GSEException {
        return this.UR8Rules_Plugin.getStreamPosition();
    }

    public long getRecordIndexInStream() {
        return this.TMStream.getRecordIndexInStream();
    }

    public long getNumRecordsInStream() throws GSEException {
        return this.TMStream.getNumRecordsInStream();
    }

    public void mark() {
        this.MarkRecordLocationInStream = this.RecordLocationInStream;
    }

    public void reset() throws GSEException {
        this.UR8Rules_Plugin.getStreamPosition(this.MarkRecordLocationInStream);
    }
}

