/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.MSIE_UR8Rules_Plugin;
import edu.umn.space.swaves.stereoLib.Stream.Reposition.StreamReposition;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamFamilySelector;
import edu.umn.space.swaves.stereoLib.Stream.StreamFamily_Plugins.StreamProperties;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.RollOverStream;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.Stream_Names_Times;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStream;
import edu.umn.space.swaves.stereoLib.Stream.StreamSource_Plugins.TMlibStreamFactory;
import edu.umn.space.swaves.stereoLib.TM_Help.TMlibHelp;
import edu.umn.space.swaves.stereoLib.event.EventPluginSelector;
import edu.umn.space.swaves.stereoLib.event.TMlibEvent;
import edu.umn.space.swaves.stereoLib.item.ItemDB;
import edu.umn.space.swaves.stereoLib.item.item;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class MsieItemDB {
    private String MissionName;
    private String SpaceCraftName;
    private String InstrumentName;
    private String EventName;
    private String UserInputStreamName;
    private TMlibStream MSIE_Stream;
    private TMlibEvent MSIE_Event;
    private item MSIE_Item = new item();
    private TMlibHelp MSIE_Help = new TMlibHelp();
    private StreamReposition JumpInStream;
    private Stream_Names_Times StreamTimesNames = new Stream_Names_Times();
    private StreamProperties StreamFamily;
    private static final String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.MSIE.";
    private ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
    private String LogOutput;

    public void TM_Select_Domain(String strCommand) throws GSEException {
        double MinSupportedClientVersion;
        String[] MSIEandVersionNum = strCommand.split("\\s+");
        double VersionNumber = Double.parseDouble(MSIEandVersionNum[0]);
        if (VersionNumber < (MinSupportedClientVersion = this.propData.getDbl("VersionControl#*ClientVersionMinimum"))) {
            String pathToExcep = "Universe.edu.umn.space.swaves.stereoLib.stream.CLIENT_NOT_COMPATIBLE_WITH_SERVER";
            throw new GSEException("MSIE will not be formed ", pathToExcep);
        }
        this.MissionName = MSIEandVersionNum[1];
        this.SpaceCraftName = MSIEandVersionNum[2];
        this.InstrumentName = MSIEandVersionNum[3];
        this.EventName = MSIEandVersionNum[4];
        String[] LevelNames = new String[]{this.MissionName, this.SpaceCraftName, this.InstrumentName, null, this.EventName};
        ItemDB XmlDb = new ItemDB();
        XmlDb.LoadDB(LevelNames);
        this.MSIE_Item.insertRangeForDB(XmlDb);
        this.MSIE_Item.createHiddenAreas();
        this.insertDomainItems();
        this.MSIE_Help.setMission(this.MissionName);
        this.LogOutput = "Requested Domain: \n Mission    :  " + this.MissionName + " \n " + "SpaceCraft :  " + this.SpaceCraftName + " \n " + "Instrument :  " + this.InstrumentName + " \n " + "Event Type :  " + this.EventName;
        LogClient.log(TMlibLogLevel.Domain_High, this.LogOutput);
    }

    private void insertDomainItems() throws GSEException {
        this.StreamFamily = StreamFamilySelector.getStreamFamilyFromMSI(this.MissionName, this.SpaceCraftName, this.InstrumentName);
        this.StreamTimesNames.setStreamFamily(this.StreamFamily);
        this.StreamTimesNames.setMSIE_Item(this.MSIE_Item);
        this.StreamTimesNames.findBOI_EOI();
        this.MSIE_Item.insertStringInHiddenArea("Domain_Mission", this.MissionName);
        this.MSIE_Item.insertStringInHiddenArea("Domain_Spacecraft", this.SpaceCraftName);
        this.MSIE_Item.insertStringInHiddenArea("Domain_Instrument", this.InstrumentName);
        this.MSIE_Item.insertStringInHiddenArea("Domain_EventType", this.EventName);
        int GseVersion = this.propData.getInt("VersionControl#*ServerVersion");
        this.MSIE_Item.insertIntIntoHiddenArea("Server_Version", GseVersion);
        try {
            InetAddress LocalHost = InetAddress.getLocalHost();
            this.MSIE_Item.insertStringInHiddenArea("SERVER_HOSTNAME", LocalHost.getHostName());
            this.MSIE_Item.insertStringInHiddenArea("SERVER_IP", LocalHost.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.MSIE_Item.setAreaReadable(-1, true);
    }

    public void TM_Select_Stream(String StreamName) throws GSEException {
        this.UserInputStreamName = StreamName;
        LogClient.log(TMlibLogLevel.Stream_High, "Requested StreamName: \n" + StreamName);
        this.MSIE_Stream = TMlibStreamFactory.pickTMlibStream(StreamName, this.MissionName);
        this.StreamFamily = StreamFamilySelector.getStreamFamilyFromStreamNameMission(StreamName, this.MissionName);
        this.configMainTMlibObjs();
        this.JumpInStream.configure();
        double FirstTime = this.JumpInStream.getFirstTimeStamp();
        double LastTime = this.JumpInStream.getLastTimeStamp();
        this.StreamTimesNames.setBOR_UR8(FirstTime);
        this.StreamTimesNames.setEOR_UR8(LastTime);
        this.StreamTimesNames.setBOF_UR8(FirstTime);
        this.StreamTimesNames.setEOF_UR8(LastTime);
        this.StreamTimesNames.setStreamName(this.MSIE_Stream.getStreamName());
        this.StreamTimesNames.setNumPackets(this.MSIE_Stream.getNumRecordsInStream());
        this.MSIE_Item.setAreaReadable(0, false);
    }

    public void TM_SelectStream_TimeRange(ByteBuffer InputUR8s) throws GSEException {
        double UserBOR = InputUR8s.getDouble();
        double UserEOR = InputUR8s.getDouble();
        this.StreamTimesNames.resolveBeginEndTimeRange(UserBOR, UserEOR);
        LogClient.log(TMlibLogLevel.Stream_High, "Resolved BOR/EOR: " + this.StreamTimesNames.BOR_UR8 + " " + this.StreamTimesNames.EOR_UR8);
        RollOverStream NewRollOverStream = new RollOverStream();
        NewRollOverStream.setStream_Names_Times(this.StreamTimesNames);
        this.MSIE_Stream = NewRollOverStream;
        this.configMainTMlibObjs();
        NewRollOverStream.setJumpInStream(this.JumpInStream);
        NewRollOverStream.openFirstFile();
        this.MSIE_Item.setAreaReadable(0, false);
    }

    private void configMainTMlibObjs() throws GSEException {
        String ContextName = this.StreamFamily.getContext();
        String SpaceCraftNameFromStream = this.StreamFamily.getSpacecraftName();
        if (SpaceCraftNameFromStream != null) {
            this.SpaceCraftName = SpaceCraftNameFromStream;
        }
        this.MSIE_Item.insertStringInHiddenArea("Domain_Spacecraft", this.SpaceCraftName);
        String[] LevelNames = new String[]{this.MissionName, this.SpaceCraftName, this.InstrumentName, ContextName, this.EventName};
        ItemDB XmlDb = new ItemDB();
        XmlDb.LoadDB(LevelNames);
        this.MSIE_Item.insertRangeForDB(XmlDb);
        this.MSIE_Event = EventPluginSelector.pickEventBuilder(XmlDb, this.MSIE_Item);
        this.MSIE_Event.setTMlibStream(this.MSIE_Stream);
        this.MSIE_Item.setAreaReadable(-2, true);
        this.MSIE_Item.setAreaReadable(-3, true);
        MSIE_UR8Rules_Plugin UR8_Rules = new MSIE_UR8Rules_Plugin(this.MSIE_Stream, LevelNames);
        this.JumpInStream = new StreamReposition(this.MSIE_Stream, UR8_Rules);
        this.StreamTimesNames.setJumpInStream(this.JumpInStream);
        String CommonPath = this.MSIE_Item.ItemDataBase.getStrAttrValue("SearchList_Common", "mission");
        this.MSIE_Item.insertStringInHiddenArea("Domain_Common_Branch", CommonPath);
        this.LogOutput = "Resolved Domain and Context: \n Mission    :  " + this.MissionName + " \n " + "SpaceCraft :  " + this.SpaceCraftName + " \n " + "Instrument :  " + this.InstrumentName + " \n " + "Event Type :  " + this.EventName + " \n " + "Context    :  " + ContextName;
        LogClient.log(TMlibLogLevel.Domain_High, this.LogOutput);
    }

    public void nextEvent() throws GSEException {
        if (this.MSIE_Event != null) {
            this.MSIE_Item.setAreaReadable(0, true);
            LogClient.log(TMlibLogLevel.Event_High, "Requesting Event: " + this.EventName);
            try {
                this.MSIE_Event.next();
            }
            catch (GSEException EventExep) {
                this.MSIE_Item.setAreaReadable(0, false);
                throw EventExep;
            }
        } else {
            if (this.MSIE_Stream == null) {
                String ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.STREAM_NOT_CREATED";
                String ErrComment = "The stream named " + this.UserInputStreamName + " could not be created";
                throw new GSEException(ErrComment, ExcepName);
            }
            String ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.EVENT_NOT_DEFINED";
            String ErrComment = "The event object was not created";
            throw new GSEException(ErrComment, ExcepName);
        }
    }

    public void getItemI4AsByteBuff(String ItemName, ByteBuffer BBuffShipToClient) throws GSEException {
        this.MSIE_Item.getItemI4AsByteBuff(ItemName, BBuffShipToClient);
    }

    public void getItemR4AsByteBuff(String ItemName, ByteBuffer BBuffShipToClient) throws GSEException {
        this.MSIE_Item.getItemR4AsByteBuff(ItemName, BBuffShipToClient);
    }

    public void getItemR8AsByteBuff(String ItemName, ByteBuffer BBuffShipToClient) throws GSEException {
        this.MSIE_Item.getItemR8AsByteBuff(ItemName, BBuffShipToClient);
    }

    public void getItemCharByteBuff(String ItemName, ByteBuffer BBuffShipToClient) throws GSEException {
        this.MSIE_Item.getItemCharByteBuff(ItemName, BBuffShipToClient);
    }

    public void TM_Set_Time(ByteBuffer InputUR8) throws GSEException {
        double TargetUR8 = InputUR8.getDouble();
        this.JumpInStream.TM_Set_Position(TargetUR8);
    }

    public void TM_GET_POSITION(ByteBuffer BBuffShipToClient) throws GSEException {
        this.MSIE_Item.getItemR8AsByteBuff("GetTime_UR8", BBuffShipToClient);
    }

    public void getHelp(String strCommand, ByteBuffer ResultOfHelp) throws GSEException {
        this.MSIE_Help.getHelp(strCommand, ResultOfHelp);
    }

    public void streamClose() throws GSEException {
        if (this.MSIE_Stream != null) {
            this.MSIE_Stream.close();
        }
    }
}

