/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.DbFileSearch;

import edu.umn.space.swaves.GSEException.GSEException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TMlibDB {
    private HashSet FileAlreadyOpenedHash = new HashSet();
    private AbstractMap<String, Element> NodeForMSIElevel = new HashMap<String, Element>();
    private AbstractMap<String, HashSet> XmlDB = new HashMap<String, HashSet>();
    private static final String ErrPath = "Universe.edu.umn.space.swaves.";
    private String ExcepName;
    private String ErrComment;
    private String[] LevelTypes;

    public void setLevelTypes(String[] inLevelTypes) {
        this.LevelTypes = inLevelTypes;
        for (int i = 0; i < this.LevelTypes.length; ++i) {
            String LevelType = this.LevelTypes[i];
            this.XmlDB.put(LevelType, new HashSet());
        }
    }

    public HashSet getHash(String Type) {
        return this.XmlDB.get(Type);
    }

    public void setThisLevelName(String LevelName, String LevelType) throws GSEException {
        LevelName = LevelName.trim();
        Vector LevelProperties = this.getNodeVectFromName(LevelName, LevelType);
        Element SingleDbElement = (Element)LevelProperties.get(0);
        this.NodeForMSIElevel.put(LevelType, SingleDbElement);
    }

    protected void LoadOneDOM(Document domTreeOfFile, String PathToCommonBranch) throws GSEException {
        try {
            Integer DocHash = new Integer(domTreeOfFile.hashCode());
            if (!this.FileAlreadyOpenedHash.contains(DocHash)) {
                for (int j = 0; j < this.LevelTypes.length; ++j) {
                    String Type = this.LevelTypes[j];
                    HashSet LevelHash = this.getHash(Type);
                    NodeList nameNodeList = domTreeOfFile.getElementsByTagName(Type);
                    if (nameNodeList == null) continue;
                    for (int i = 0; i < nameNodeList.getLength(); ++i) {
                        Element DBelement = (Element)nameNodeList.item(i);
                        DBelement.setAttribute("CommonSearchDir", PathToCommonBranch);
                        LevelHash.add(DBelement);
                    }
                }
                this.FileAlreadyOpenedHash.add(DocHash);
            }
        }
        catch (DOMException excep) {
            excep.printStackTrace();
        }
    }

    public boolean hasAttribute(String AttrName, String LevelType) throws GSEException {
        Element SingleDbElement = this.NodeForMSIElevel.get(LevelType);
        return SingleDbElement.hasAttribute(AttrName);
    }

    public String getStrAttrValue(String AttrName, String LevelType) throws GSEException {
        Element SingleDbElement = this.NodeForMSIElevel.get(LevelType);
        return SingleDbElement.getAttribute(AttrName);
    }

    public String getStrAttrLowCase(String AttrName, String LevelType) throws GSEException {
        return this.getStrAttrValue(AttrName, LevelType).toLowerCase();
    }

    public Vector getNodeVectFromName(String LevelName, String LevelType) throws GSEException {
        Iterator DBStuctIter = this.getHash(LevelType).iterator();
        Vector<Element> ThisLevelVectNode = new Vector<Element>();
        LevelName = LevelName.trim();
        while (DBStuctIter.hasNext()) {
            Element SingleDbElement = (Element)DBStuctIter.next();
            String NameOfElement = SingleDbElement.getAttribute("name");
            if (!NameOfElement.trim().equalsIgnoreCase(LevelName)) continue;
            ThisLevelVectNode.add(SingleDbElement);
        }
        if (ThisLevelVectNode.size() == 0) {
            this.ExcepName = "Universe.edu.umn.space.swaves..ItemDataBase.REQUESTED_NAME_NOT_IN_DATABASE";
            this.ErrComment = LevelName + " is not found in the DB";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return ThisLevelVectNode;
    }
}

