/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.DbFileSearch;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.stereoLib.DbFileSearch.IncludeEntityResolve;
import edu.umn.space.swaves.stereoLib.DbFileSearch.TMlibDB;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import edu.umn.space.swaves.util.xml.XmlTransform;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class SearchList
extends TMlibDB {
    private static final String ErrPath = "Universe.edu.umn.space.swaves..stereoLib.MSIE.";
    private String ExcepName;
    private String ErrComment;
    private HashSet<String> NodesFromFileHaveBeenLoaded = new HashSet();
    private IncludeEntityResolve HandleIncludeFiles = new IncludeEntityResolve();
    private String CommonSearchDirStr = null;
    private String SpecificSearchDirStr = null;
    private Pattern XMLFilePattern = Pattern.compile("(.*)\\.xml");
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    private DocumentBuilder DocBuilder;
    private XmlTransform TransXML;
    private String[] LevelTypes = new String[]{"mission", "spacecraft", "instrument", "context", "event", "item"};
    private boolean LastFileDir = true;
    private String pathToTopLevelFile;

    public SearchList() throws GSEException {
        super.setLevelTypes(this.LevelTypes);
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        this.pathToTopLevelFile = propData.getStr("FileSystem#*MISSION_DB_FILES");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.DocBuilder = factory.newDocumentBuilder();
            this.TransXML = new XmlTransform();
            this.TransXML.setEntityResolver(this.HandleIncludeFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.HandleIncludeFiles = new IncludeEntityResolve();
        this.DocBuilder.setEntityResolver(this.HandleIncludeFiles);
    }

    public Iterator getXmlItemDBHelp(String PathFromURL) throws GSEException {
        this.CommonSearchDirStr = this.pathToTopLevelFile;
        this.SpecificSearchDirStr = this.pathToTopLevelFile;
        String ChopFirstForwardSlash = PathFromURL;
        while (ChopFirstForwardSlash.startsWith("/")) {
            ChopFirstForwardSlash = ChopFirstForwardSlash.trim().substring(1);
        }
        String[] Path2 = ChopFirstForwardSlash.split("/+");
        Iterator OutputIterator = null;
        for (int i = 0; i < Path2.length - 1; ++i) {
            if (this.LevelTypes[i].equalsIgnoreCase("mission")) {
                this.loadOneLevel(Path2[i], "mission");
            }
            this.decendOneLevelNoFork(Path2[i], this.LevelTypes[i]);
        }
        String CommonBranchFile = null;
        String SpecificBranchFile = null;
        if (Path2.length == 0) {
            CommonBranchFile = this.CommonSearchDirStr;
            SpecificBranchFile = this.SpecificSearchDirStr;
        } else {
            CommonBranchFile = this.CommonSearchDirStr + File.separator + Path2[Path2.length - 1];
            SpecificBranchFile = this.SpecificSearchDirStr + File.separator + Path2[Path2.length - 1];
        }
        File SpecificFile = new File(SpecificBranchFile);
        File CommonFile = new File(CommonBranchFile);
        if (SpecificFile.exists()) {
            if (SpecificFile.isFile()) {
                this.LastFileDir = false;
                HashSet<File> FileSet = new HashSet<File>();
                FileSet.add(SpecificFile);
                OutputIterator = FileSet.iterator();
            } else {
                this.LastFileDir = true;
                OutputIterator = this.selectFilesFromBothBranches(CommonBranchFile, SpecificBranchFile);
            }
        } else if (CommonFile.exists()) {
            if (CommonFile.isFile()) {
                this.LastFileDir = false;
                HashSet<File> FileSet = new HashSet<File>();
                FileSet.add(CommonFile);
                OutputIterator = FileSet.iterator();
            } else {
                this.LastFileDir = true;
                OutputIterator = this.selectFilesFromBothBranches(CommonBranchFile, SpecificBranchFile);
            }
        }
        return OutputIterator;
    }

    public boolean isLastFileDir() {
        return this.LastFileDir;
    }

    public void readXMLandIncludeEntities(File RequestedFile, ByteBuffer HelpBuff) throws GSEException {
        if (this.CommonSearchDirStr != null) {
            this.HandleIncludeFiles.setCommonPath(this.CommonSearchDirStr);
        }
        if (this.SpecificSearchDirStr != null) {
            this.HandleIncludeFiles.setSpecPath(this.SpecificSearchDirStr);
        }
        try {
            this.TransXML.reset();
            this.TransXML.setFile(RequestedFile);
            this.TransXML.setEntityResolver(this.HandleIncludeFiles);
            HelpBuff.put(this.AsciiCharset.encode(this.TransXML.XmlToStringBuffer().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void LoadDB(String[] LevelNames) throws GSEException {
        this.CommonSearchDirStr = this.pathToTopLevelFile;
        this.SpecificSearchDirStr = this.pathToTopLevelFile;
        for (int i = 0; i < LevelNames.length; ++i) {
            if (LevelNames[i] != null) {
                this.loadOneLevel(LevelNames[i], this.LevelTypes[i]);
            }
            if (this.LevelTypes[i].equalsIgnoreCase("context")) continue;
            this.decendOneLevel(LevelNames[i], this.LevelTypes[i]);
        }
        this.loadFiles(this.CommonSearchDirStr, this.SpecificSearchDirStr);
    }

    private void loadOneLevel(String LevelName, String LevelType) throws GSEException {
        block8: {
            this.loadFiles(this.CommonSearchDirStr, this.SpecificSearchDirStr);
            File MainForkDir = new File(this.CommonSearchDirStr + File.separator + LevelType);
            if (MainForkDir.exists()) {
                String CommonForkDirStr = this.CommonSearchDirStr + File.separator + LevelType;
                String SpecificForkDirStr = this.SpecificSearchDirStr + File.separator + LevelType;
                this.loadFiles(CommonForkDirStr, SpecificForkDirStr);
            }
            try {
                super.setThisLevelName(LevelName, LevelType);
            }
            catch (GSEException excep) {
                if (LevelType.equals("mission")) {
                    this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.REQUESTED_MISSION_NOT_IN_DB";
                    this.ErrComment = "The mission \"" + LevelName + "\" is not in the database\n";
                    throw new GSEException(this.ErrComment, this.ExcepName);
                }
                if (LevelType.equals("spacecraft")) {
                    this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.REQUESTED_SPACECRAFT_NOT_IN_DB";
                    this.ErrComment = "The spacecraft \"" + LevelName + "\" is not in the database\n";
                    throw new GSEException(this.ErrComment, this.ExcepName);
                }
                if (LevelType.equals("instrument")) {
                    this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.REQUESTED_INSTRUMENT_NOT_IN_DB";
                    this.ErrComment = "The instrument \"" + LevelName + "\" is not in the database\n";
                    throw new GSEException(this.ErrComment, this.ExcepName);
                }
                if (LevelType.equals("context")) {
                    this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.REQUESTED_CONTEXT_NOT_IN_DB";
                    this.ErrComment = "The context \"" + LevelName + "\" is not in the database\n";
                    throw new GSEException(this.ErrComment, this.ExcepName);
                }
                if (!LevelType.equals("event")) break block8;
                this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.REQUESTED_EVENT_TYPE_NOT_IN_DB";
                this.ErrComment = "The EventType \"" + LevelName + "\" is not in the database\n";
                throw new GSEException(this.ErrComment, this.ExcepName);
            }
        }
        if (LevelType.equalsIgnoreCase("context")) {
            String SubDir = "context" + File.separator + super.getStrAttrValue("subdirWithItemFiles", "context");
            String CommonContextDirStr = this.CommonSearchDirStr + File.separator + SubDir;
            String SpecificContextStr = this.SpecificSearchDirStr + File.separator + SubDir;
            this.loadFiles(CommonContextDirStr, SpecificContextStr);
        }
    }

    private void loadFiles(String CommonSearchDirStr, String SpecificSearchDirStr) throws GSEException {
        String FilesLoadedKey = CommonSearchDirStr + "_" + SpecificSearchDirStr;
        if (!this.NodesFromFileHaveBeenLoaded.contains(FilesLoadedKey = FilesLoadedKey.toLowerCase())) {
            this.HandleIncludeFiles.setCommonPath(CommonSearchDirStr);
            this.HandleIncludeFiles.setSpecPath(SpecificSearchDirStr);
            Iterator FilesToLoad = this.selectFilesFromBothBranches(CommonSearchDirStr, SpecificSearchDirStr);
            if (FilesToLoad != null) {
                File DBFile = null;
                try {
                    while (FilesToLoad.hasNext()) {
                        DBFile = (File)FilesToLoad.next();
                        Matcher XMLMatch = this.XMLFilePattern.matcher(DBFile.toString());
                        if (!XMLMatch.find()) continue;
                        Document document = this.DocBuilder.parse(DBFile.toURI().getPath());
                        super.LoadOneDOM(document, CommonSearchDirStr);
                    }
                }
                catch (Exception exp) {
                    this.ExcepName = "Universe.edu.umn.space.swaves..stereoLib.MSIE.XML_SYNTAX_ERROR";
                    this.ErrComment = "In file " + DBFile.toString() + "\n";
                    throw new GSEException(this.ErrComment, this.ExcepName);
                }
            }
            this.NodesFromFileHaveBeenLoaded.add(FilesLoadedKey);
        }
    }

    private Iterator selectFilesFromBothBranches(String CommonSearchDirStr, String SpecificSearchDirStr) throws GSEException {
        Iterator FilesToLoad = null;
        AbstractMap JointDBFiles = this.getDirContents(CommonSearchDirStr);
        AbstractMap SpecificDBFiles = this.getDirContents(SpecificSearchDirStr);
        for (String FileName : SpecificDBFiles.keySet()) {
            if (JointDBFiles.containsKey(FileName)) {
                JointDBFiles.remove(FileName);
            }
            JointDBFiles.put(FileName, SpecificDBFiles.get(FileName));
        }
        if (JointDBFiles != null) {
            FilesToLoad = JointDBFiles.values().iterator();
        }
        return FilesToLoad;
    }

    private AbstractMap getDirContents(String DirName) {
        HashMap<String, File> FileHash = new HashMap<String, File>();
        File DirWhereXMLfilesLive = new File(DirName);
        File[] FilesToCheck = DirWhereXMLfilesLive.listFiles();
        if (FilesToCheck != null) {
            for (int i = 0; i < FilesToCheck.length; ++i) {
                ((AbstractMap)FileHash).put(FilesToCheck[i].getName().toLowerCase(), FilesToCheck[i]);
            }
        }
        return FileHash;
    }

    private void decendOneLevel(String LevelName, String LevelType) throws GSEException {
        File MainForkDir = new File(this.CommonSearchDirStr + File.separator + LevelType);
        if (MainForkDir.exists()) {
            this.SpecificSearchDirStr = this.SpecificSearchDirStr + File.separator + LevelType + File.separator + LevelName;
            this.CommonSearchDirStr = this.CommonSearchDirStr + File.separator + LevelType + File.separator + LevelName;
        } else {
            this.decendOneLevelNoFork(LevelName, LevelType);
        }
    }

    private void decendOneLevelNoFork(String LevelName, String LevelType) throws GSEException {
        this.SpecificSearchDirStr = this.SpecificSearchDirStr + File.separator + LevelName;
        if (LevelType.equalsIgnoreCase("Spacecraft")) {
            if (super.hasAttribute("SearchList_Common", "mission")) {
                String CommonPathFromFile = super.getStrAttrValue("SearchList_Common", "mission");
                this.CommonSearchDirStr = this.CommonSearchDirStr + File.separator + CommonPathFromFile;
            } else {
                this.CommonSearchDirStr = this.CommonSearchDirStr + File.separator + LevelName;
            }
        } else {
            this.CommonSearchDirStr = this.CommonSearchDirStr + File.separator + LevelName;
        }
    }
}

