/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.stereoLib.DbFileSearch;

import edu.umn.space.swaves.GSEException.GSEException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class IncludeEntityResolve
implements EntityResolver {
    private Pattern IncludePattern;
    private String Sep = File.separator;
    private String CommonPath;
    private String SpecPath;
    private static final String ErrPath = "Universe.edu.umn.space.swaves..ItemDataBase.";
    private String ExcepName;
    private String ErrComment;

    public IncludeEntityResolve() {
        this.IncludePattern = Pattern.compile("(.*)include" + this.Sep + "(.*)");
    }

    public void setCommonPath(String inCommonPath) throws GSEException {
        this.CommonPath = inCommonPath;
    }

    public void setSpecPath(String inSpecPath) throws GSEException {
        this.SpecPath = inSpecPath;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource EntitySource = null;
        Matcher IncludeMatcher = this.IncludePattern.matcher(systemId);
        if (IncludeMatcher.find()) {
            String FileName = IncludeMatcher.group(2);
            if (this.SpecPath != null) {
                EntitySource = this.findIncludeFileInputSource(FileName, this.SpecPath);
            }
            if (EntitySource == null && this.CommonPath != null) {
                EntitySource = this.findIncludeFileInputSource(FileName, this.CommonPath);
            }
        }
        return EntitySource;
    }

    private InputSource findIncludeFileInputSource(String FileName, String PathInSearchList) {
        InputSource EntitySourceForIncludeFile = null;
        String IncludeFilePath = PathInSearchList + this.Sep + "include" + this.Sep + FileName;
        File IncludeFile = new File(IncludeFilePath);
        if (IncludeFile.exists()) {
            String inclURI = IncludeFile.toURI().toString();
            EntitySourceForIncludeFile = new InputSource(inclURI);
        }
        return EntitySourceForIncludeFile;
    }
}

