/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.logServer.ClientSide;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.SocketChannelLogHandler;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogClient {
    private static Logger logger = null;
    private static final String ErrPath = "Universe.edu.umn.space.swaves..Logger";
    public static final int TM_LOGGER = 1;
    public static final int TC_LOGGER = 2;
    public static final int DAQ_LOGGER = 3;
    public static final int CONFIG_LOGGER = 4;
    private static SocketChannelLogHandler ToMainLog;

    public static final Logger getLogger(int LoggerType) throws GSEException {
        if (logger == null) {
            LogClient.createLogger(LoggerType, " ");
        }
        return logger;
    }

    public static final Logger getLogger(int LoggerType, String FileAppendage) throws GSEException {
        if (logger == null) {
            LogClient.createLogger(LoggerType, FileAppendage);
        }
        return logger;
    }

    private static final void createLogger(int LoggerType, String FileAppendage) throws GSEException {
        String LoggerName;
        String LoggerLevel;
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        switch (LoggerType) {
            case 1: {
                LoggerLevel = propData.getStr("Logs#*TM_log_level");
                LoggerName = propData.getStr("Logs#*TM_log_prefix");
                break;
            }
            case 2: {
                LoggerLevel = propData.getStr("Logs#*TC_log_level");
                LoggerName = propData.getStr("Logs#*TC_log_prefix");
                break;
            }
            case 3: {
                LoggerLevel = propData.getStr("Logs#*DAQ_log_level");
                LoggerName = propData.getStr("Logs#*DAQ_log_prefix");
                break;
            }
            case 4: {
                LoggerLevel = propData.getStr("Logs#*Config_log_level");
                LoggerName = propData.getStr("Logs#*Config_log_prefix");
                break;
            }
            default: {
                String ExcepName = "Universe.edu.umn.space.swaves..Logger.LOGGER_TYPE_NOT_KNOWN";
                String ErrComment = "The Logger type code: " + LoggerType + " is not valid\n" + "Valid logger types can be found in the Info.plist file";
                throw new GSEException(ErrComment, ExcepName);
            }
        }
        LoggerName = LoggerName + FileAppendage;
        LoggerName = LoggerName.trim();
        logger = Logger.getLogger(LoggerName);
        logger.setUseParentHandlers(false);
        Level LevelForThisLogger = TMlibLogLevel.parse(LoggerLevel);
        logger.setLevel(LevelForThisLogger);
        int LOG_PORT = propData.getInt("Logs#*LOG_PORT");
        SocketChannelLogHandler ToMainLog = new SocketChannelLogHandler(LOG_PORT);
        logger.addHandler(ToMainLog);
    }

    public static final void log(Level Log_level, String Message) {
        logger.log(Log_level, Message);
    }

    public static final void close() {
        ToMainLog.close();
    }
}

